package com.tencent.start.cgs.tools;

import java.io.File;
import java.io.IOException;

import static com.tencent.start.cgs.tools.App.safeParseLong;

public class UtilTools {

    public static void printUsage() {
        System.out.println("  java -jar gamepack.jar util cp <source> <target>");
        System.out.println("  java -jar gamepack.jar util rm <file> ...");
        System.out.println("  java -jar gamepack.jar util [crc32|md5|sha1|sha256] ...");
    }

    public static void usage() {
        System.out.println("Usage:");
        printUsage();
        System.exit(1);
    }

    private static void calcFileCrc32(AbstractFile file) throws IOException {
        if (!file.exists()) {
            System.out.println(file + " not exists");
        } else if (!file.isDirectory()) {
            System.out.printf("%s, length=%d, crc32=%d%n",
                    file.getAbsolutePath(), file.length(), App.calcFileCrc32(file));
        } else {
            AbstractFile[] files = file.listFiles();
            if (null != files) {
                for (AbstractFile each : files) {
                    calcFileCrc32(each);
                }
            }
        }
    }

    private static void calcFileHash(AbstractFile file, String algorithm) throws IOException {
        if (!file.exists()) {
            System.out.println(file + " not exists");
        } else if (!file.isDirectory()) {
            System.out.printf("%s, length=%d, digest=%s%n",
                    file.getAbsolutePath(), file.length(),
                    App.calcFileMessageDigestHexString(file, algorithm.toUpperCase()));
        } else {
            AbstractFile[] files = file.listFiles();
            if (null != files) {
                for (AbstractFile each : files) {
                    calcFileHash(each, algorithm);
                }
            }
        }
    }

    private static boolean remove(AbstractFile file) {
        try {
            if (!file.exists()) {
                return true;
            } else if (file.isDirectory()) {
                System.out.println("rm: cannot remove '" + file.getAbsolutePath() + "': Is a directory");
                return false;
            } else if (file.delete()) {
                return true;
            } else {
                System.out.println("rm: cannot remove '" + file.getAbsolutePath() + "': Permission denied");
                return false;
            }
        } catch (Exception e) {
            System.out.println("rm: cannot remove '" + file.getAbsolutePath() + "': " + e.getMessage());
            return false;
        }
    }

    @SuppressWarnings("SameParameterValue")
    private static boolean remove(String[] files, int off) {
        boolean result = true;
        for (int i = off; i < files.length; ++i) {
            try {
                String fileName = files[i];
                if (fileName.endsWith("/.trash/*")) {
                    AbstractFile[] list = AbstractFile.make(
                            fileName.substring(0, fileName.length() - 2)).listFiles();
                    if (list != null) {
                        for (AbstractFile each : list) {
                            if (!remove(each)) {
                                result = false;
                            }
                        }
                    }
                } else if (fileName.endsWith("*")) {
                    System.out.println("rm: cannot remove '" + files[i] + "': Permission denied");
                    result = false;
                } else if (!remove(AbstractFile.make(fileName))) {
                    result = false;
                }
            } catch (Exception e) {
                System.out.println("rm: cannot remove '" + files[i] + "': " + e.getMessage());
                result = false;
            }
        }
        return result;
    }

    public static void callMain(String[] args) throws IOException {
        if (args.length < 3) {
            usage();
            return;
        }
        switch (args[1]) {
            case "cp":
                if (args[2].startsWith("--retry=") && args.length == 5) {
                    FileCopy.cp(args[3], args[4], safeParseLong(args[2].substring(8), 0));
                    return;
                } else if (args.length == 4) {
                    FileCopy.cp(args[2], args[3], 0);
                    return;
                }
                break;
            case "rm":
                System.exit(remove(args, 2) ? 0 : 1);

            case "crc32":
                for (int i = 2; i < args.length; ++i) {
                    calcFileCrc32(AbstractFile.make(args[i]));
                }
                return;
            case "md5":
                for (int i = 2; i < args.length; ++i) {
                    calcFileHash(AbstractFile.make(args[i]), "MD5");
                }
                return;
            case "sha1":
                for (int i = 2; i < args.length; ++i) {
                    calcFileHash(AbstractFile.make(args[i]), "SHA-1");
                }
                return;
            case "sha256":
                for (int i = 2; i < args.length; ++i) {
                    calcFileHash(AbstractFile.make(args[i]), "SHA-256");
                }
                return;
            default:
                break;
        }
        usage();
    }
}
