const Create = require('../Create/Create.js');    
const Config = require('../Config/Config.json');
const readline = require('readline');
const Director = {};

Director.Bots = [];

// Creates Bots w/Checks for if server is enabled and if there is a bot already on it
Director.Create = async function(){
    let i = 0;
    for(Server of Config.Servers){
        // Checks if server is Active
        if(Server.Active){
            console.log(`${Server.Host} is ${Server.Active}.`)
            // Checks if bot is on server
            if(Server.Enabled){
                console.log(`${Server.Host} has a bot on.`)
                i++;
            }else{
                Director.Bots.push(await Create(Config,i));
                Server.Enabled;
                i++;
            }
        }else{
            console.log(`${Server.Host} is ${Server.Active}.`)
            i++;
        }
    }
}

Director.StartConsole = function(){
    console.log('Starting StickBot Console.')
    const rl = readline.createInterface({
        input: process.stdin,
        output: process.stdout
    });

    async function processCommand(command) {
        const parts = command.split(' ');
        const action = parts[0].toLowerCase();

        if (action.toLowerCase() === 'echo') {
            if(!parts[1]){
                console.log(`Invalid usage of echo: echo <Words>`)
            };
            console.log(parts[1]);
        }else if(action.toLowerCase() === 'create'){
            try{
                await Director.Create();
            }catch(error){
                console.log('An error occurred:', error.message);
            }
        }else if(action.toLowerCase() === 'status'){
            for(Bot of Director.Bots){
                console.log(`Bot Name: ${Bot.Name}\nBot Server: ${Bot.Host}:${Bot.Port}`);
            }
        }else{
            console.log(`Unknown command ${action}`);
        }
    }

    rl.on('line', async(input) => {
        await processCommand(input);
    });
}

module.exports = Director;