/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import java.awt.Color;
import java.util.StringTokenizer;

public class ColorStringParser
extends StringParser {
    private static final ColorStringParser INSTANCE = new ColorStringParser();

    public static ColorStringParser getParser() {
        return INSTANCE;
    }

    private ParseException colorException(String string) {
        return new ParseException("Unable to convert '" + string + "' to a Color.");
    }

    private Color parseHexColor(String string) throws ParseException {
        Color color = null;
        int n = string.length();
        if (n != 7 && n != 9) {
            throw this.colorException(string);
        }
        try {
            int n2 = Integer.parseInt(string.substring(1, 3), 16);
            int n3 = Integer.parseInt(string.substring(3, 5), 16);
            int n4 = Integer.parseInt(string.substring(5, 7), 16);
            if (n == 7) {
                color = new Color(n2, n3, n4);
            } else {
                int n5 = Integer.parseInt(string.substring(7, 9), 16);
                color = new Color(n2, n3, n4, n5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw this.colorException(string);
        }
        return color;
    }

    private Color parseFloatTuple(String string) throws ParseException {
        String[] stringArray = this.tupleToArray(string);
        Color color = null;
        try {
            float f = Float.parseFloat(stringArray[0]);
            float f2 = Float.parseFloat(stringArray[1]);
            float f3 = Float.parseFloat(stringArray[2]);
            if (stringArray.length == 3) {
                color = new Color(f, f2, f3);
            } else {
                float f4 = Float.parseFloat(stringArray[3]);
                color = new Color(f, f2, f3, f4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw this.colorException(string);
        }
        return color;
    }

    private Color parseIntTuple(String string) throws ParseException {
        String[] stringArray = this.tupleToArray(string);
        Color color = null;
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            if (stringArray.length == 3) {
                color = new Color(n, n2, n3);
            } else {
                int n4 = Integer.parseInt(stringArray[3]);
                color = new Color(n, n2, n3, n4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw this.colorException(string);
        }
        return color;
    }

    private Color parseColorName(String string) throws ParseException {
        Color color = null;
        if (string.equalsIgnoreCase("black")) {
            color = Color.black;
        } else if (string.equalsIgnoreCase("blue")) {
            color = Color.blue;
        } else if (string.equalsIgnoreCase("cyan")) {
            color = Color.cyan;
        } else if (string.equalsIgnoreCase("gray")) {
            color = Color.gray;
        } else if (string.equalsIgnoreCase("green")) {
            color = Color.green;
        } else if (string.equalsIgnoreCase("lightGray")) {
            color = Color.lightGray;
        } else if (string.equalsIgnoreCase("magenta")) {
            color = Color.magenta;
        } else if (string.equalsIgnoreCase("orange")) {
            color = Color.orange;
        } else if (string.equalsIgnoreCase("pink")) {
            color = Color.pink;
        } else if (string.equalsIgnoreCase("red")) {
            color = Color.red;
        } else if (string.equalsIgnoreCase("white")) {
            color = Color.white;
        } else if (string.equalsIgnoreCase("yellow")) {
            color = Color.yellow;
        } else {
            throw this.colorException(string);
        }
        return color;
    }

    private String[] tupleToArray(String string) throws ParseException {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        int n = stringTokenizer.countTokens();
        if (n == 5) {
            stringArray = new String[3];
        } else if (n == 7) {
            stringArray = new String[4];
        } else {
            throw this.colorException(string);
        }
        stringArray[0] = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringArray[2] = stringTokenizer.nextToken();
        if (n == 7) {
            stringTokenizer.nextToken();
            stringArray[3] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    @Override
    public Object parse(String string) throws ParseException {
        Color color = null;
        color = string.charAt(0) == '#' ? this.parseHexColor(string) : (string.indexOf(".") >= 0 ? this.parseFloatTuple(string) : (string.indexOf(",") >= 0 ? this.parseIntTuple(string) : this.parseColorName(string)));
        return color;
    }
}

