/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import io.github.waterfallmc.waterfall.console.WaterfallConsole;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ProxyServer;

public class BungeeCordLauncher {
    public static void main(String[] args) throws Exception {
        Security.setProperty("networkaddress.cache.ttl", "30");
        Security.setProperty("networkaddress.cache.negative.ttl", "10");
        if (System.getProperty("jdk.util.jar.enableMultiRelease") == null) {
            System.setProperty("jdk.util.jar.enableMultiRelease", "force");
        }
        System.setProperty("java.awt.headless", "true");
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        parser.acceptsAll(Collections.singletonList("help"), "Show the help");
        parser.acceptsAll(Arrays.asList("v", "version"), "Print version and exit");
        parser.acceptsAll(Collections.singletonList("noconsole"), "Disable console input");
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn(System.out);
            return;
        }
        if (options.has("version")) {
            System.out.println(BungeeCord.class.getPackage().getImplementationVersion());
            return;
        }
        BungeeCord bungee = new BungeeCord();
        RuntimeMXBean runtimeMX = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean osMX = ManagementFactory.getOperatingSystemMXBean();
        if (runtimeMX != null && osMX != null) {
            bungee.getLogger().info(String.format("Enabled " + bungee.getName() + " powered by shieldcommunity.net version 3.8.4 Java: %s (%s %s) Host: %s %s (%s) ", runtimeMX.getSpecVersion(), runtimeMX.getVmName(), runtimeMX.getVmVersion(), osMX.getName(), osMX.getVersion(), osMX.getArch()));
        }
        ProxyServer.setInstance(bungee);
        bungee.start();
        if (!options.has("noconsole")) {
            new WaterfallConsole().start();
        }
    }
}

