/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.LoadingCache;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Ticker;

public class ConnectionThrottle {
    private final LoadingCache<InetAddress, AtomicInteger> throttle;
    private final int throttleLimit;

    public ConnectionThrottle(int throttleTime, int throttleLimit) {
        this(Ticker.systemTicker(), throttleTime, throttleLimit);
    }

    @VisibleForTesting
    ConnectionThrottle(Ticker ticker, int throttleTime, int throttleLimit) {
        this.throttle = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).ticker(ticker).initialCapacity(1000).expireAfterAccess(throttleTime, TimeUnit.MILLISECONDS).build(key -> new AtomicInteger());
        this.throttleLimit = throttleLimit;
    }

    public void unthrottle(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return;
        }
        InetAddress address = ((InetSocketAddress)socketAddress).getAddress();
        AtomicInteger throttleCount = (AtomicInteger)this.throttle.getIfPresent(address);
        if (throttleCount != null) {
            throttleCount.decrementAndGet();
        }
    }

    public boolean throttle(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return false;
        }
        InetAddress address = ((InetSocketAddress)socketAddress).getAddress();
        int throttleCount = this.throttle.get(address).incrementAndGet();
        return throttleCount > this.throttleLimit;
    }

    public void unthrottle(InetAddress inetAddress) {
        this.throttle.invalidate(inetAddress);
    }

    public void invalidateAll() {
        this.throttle.invalidateAll();
    }

    public Set<InetAddress> getAllInetAddress() {
        return this.throttle.asMap().keySet();
    }
}

