/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import lombok.NonNull;

public class Favicon {
    private static final TypeAdapter<Favicon> FAVICON_TYPE_ADAPTER = new TypeAdapter<Favicon>(){

        @Override
        public void write(JsonWriter out, Favicon value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value.getEncoded());
            }
        }

        @Override
        public Favicon read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String enc = in.nextString();
            return enc == null ? null : Favicon.create(enc);
        }
    };
    @NonNull
    private final String encoded;

    public static TypeAdapter<Favicon> getFaviconTypeAdapter() {
        return FAVICON_TYPE_ADAPTER;
    }

    public static Favicon create(BufferedImage image) {
        byte[] imageBytes;
        Preconditions.checkArgument(image != null, "image is null");
        if (image.getWidth() != 64 || image.getHeight() != 64) {
            throw new IllegalArgumentException("Server icon must be exactly 64x64 pixels");
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", stream);
            imageBytes = stream.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        String encoded = "data:image/png;base64," + BaseEncoding.base64().encode(imageBytes);
        if (encoded.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Favicon file too large for server to process");
        }
        return new Favicon(encoded);
    }

    public static Favicon create(InputStream stream, float compressQuality) throws IOException {
        BufferedImage image;
        try (ImageInputStream in = ImageIO.createImageInputStream(stream);){
            ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
            reader.setInput(in, true, false);
            image = reader.read(0);
            reader.dispose();
        }
        if (image.getWidth() != 64 || image.getHeight() != 64) {
            throw new IllegalArgumentException("Server icon must be exactly 64x64 pixels");
        }
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try (ImageOutputStream out = ImageIO.createImageOutputStream(outBytes);){
            ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(image);
            ImageWriter writer = ImageIO.getImageWriters(type, "png").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (param.canWriteCompressed()) {
                param.setCompressionMode(2);
                param.setCompressionQuality(compressQuality);
            }
            writer.setOutput(out);
            writer.write(null, new IIOImage(image, null, null), param);
            writer.dispose();
        }
        String encoded = "data:image/png;base64," + BaseEncoding.base64().encode(outBytes.toByteArray());
        outBytes.close();
        if (encoded.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Favicon file too large for server to process");
        }
        return new Favicon(encoded);
    }

    @Deprecated
    public static Favicon create(String encodedString) {
        return new Favicon(encodedString);
    }

    private Favicon(@NonNull String encoded) {
        if (encoded == null) {
            throw new NullPointerException("encoded is marked non-null but is null");
        }
        this.encoded = encoded;
    }

    @NonNull
    public String getEncoded() {
        return this.encoded;
    }
}

