/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.forge;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.md_5.bungee.forge.ForgeConstants;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ForgeUtils {
    public static Set<String> readRegisteredChannels(PluginMessage pluginMessage) {
        String channels = new String(pluginMessage.getData(), StandardCharsets.UTF_8);
        String[] split = channels.split("\u0000");
        return ImmutableSet.copyOf(split);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readModList(PluginMessage pluginMessage) {
        HashMap<String, String> modTags = new HashMap<String, String>();
        ByteBuf payload = Unpooled.wrappedBuffer(pluginMessage.getData());
        try {
            byte discriminator = payload.readByte();
            if (discriminator == 2) {
                ByteBuf buffer = payload.slice();
                int modCount = DefinedPacket.readVarInt(buffer);
                for (int i = 0; i < modCount; ++i) {
                    modTags.put(DefinedPacket.readString(buffer), DefinedPacket.readString(buffer));
                }
            }
        }
        finally {
            payload.release();
        }
        return modTags;
    }

    @Deprecated
    public static int getFmlBuildNumber(Map<String, String> modList) {
        String fmlVersion;
        Matcher matcher;
        if (modList.containsKey("FML") && (matcher = (fmlVersion = modList.get("FML")).equals("7.10.99.99") ? ForgeConstants.FML_HANDSHAKE_VERSION_REGEX.matcher(modList.get("Forge")) : ForgeConstants.FML_HANDSHAKE_VERSION_REGEX.matcher(fmlVersion)).find()) {
            return Integer.parseInt(matcher.group(4));
        }
        return 0;
    }
}

