/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.compress.PacketCompressor;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.netty.flush.BungeeFlushConsolidationHandler;
import net.md_5.bungee.netty.flush.FlushSignalingHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.shieldcommunity.nullcordx.api.IChannelWrapper;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.natives.Natives;
import net.shieldcommunity.nullcordx.natives.compression.CompressorFactory;

public class ChannelWrapper
implements IChannelWrapper {
    private final Channel ch;
    private SocketAddress remoteAddress;
    private final SocketAddress trueRemoteAddress;
    private volatile boolean closed;
    private volatile boolean closing;
    private MinecraftDecoder decoder;
    private MinecraftEncoder encoder;
    private EpollSocketChannel epollSocketChannel = null;
    private volatile boolean queueGamePacket = false;
    private final Queue<Object> packetQueue = new ConcurrentLinkedQueue<Object>();

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
        this.trueRemoteAddress = this.remoteAddress = this.ch.remoteAddress() == null ? this.ch.parent().localAddress() : this.ch.remoteAddress();
        if (ConfigSettings.IMP.PERFORMANCE.CACHE_DECODER_AND_ENCODER_HANDLERS) {
            this.decoder = this.ch.pipeline().get(MinecraftDecoder.class);
            this.encoder = this.ch.pipeline().get(MinecraftEncoder.class);
        }
        if (this.ch instanceof EpollSocketChannel) {
            this.epollSocketChannel = (EpollSocketChannel)this.ch;
        }
    }

    @Override
    public void setProtocol(Protocol protocol) {
        this.getMinecraftDecoder().setProtocol(protocol);
        this.getMinecraftEncoder().setProtocol(protocol);
    }

    @Override
    public void setVersion(int protocol) {
        this.getMinecraftDecoder().setProtocolVersion(protocol);
        this.getMinecraftEncoder().setProtocolVersion(protocol);
    }

    @Override
    public Protocol getDecodeProtocol() {
        return this.getMinecraftDecoder().getProtocol();
    }

    @Override
    public void setDecodeProtocol(Protocol protocol) {
        this.getMinecraftDecoder().setProtocol(protocol);
    }

    @Override
    public Protocol getEncodeProtocol() {
        return this.getMinecraftEncoder().getProtocol();
    }

    @Override
    public void setEncodeProtocol(Protocol protocol) {
        this.getMinecraftEncoder().setProtocol(protocol);
    }

    @Override
    public int getEncodeVersion() {
        return this.getMinecraftEncoder().getProtocolVersion();
    }

    @Override
    public int getDecodeVersion() {
        return this.getMinecraftDecoder().getProtocolVersion();
    }

    private MinecraftEncoder getMinecraftEncoder() {
        if (this.encoder != null) {
            return this.encoder;
        }
        return this.ch.pipeline().get(MinecraftEncoder.class);
    }

    private MinecraftDecoder getMinecraftDecoder() {
        if (this.decoder != null) {
            return this.decoder;
        }
        return this.ch.pipeline().get(MinecraftDecoder.class);
    }

    public void setFlushSignalingTarget(BungeeFlushConsolidationHandler target) {
        FlushSignalingHandler handler = this.ch.pipeline().get(FlushSignalingHandler.class);
        if (handler == null) {
            this.ch.pipeline().addFirst("flush-signaling", (ChannelHandler)new FlushSignalingHandler(target));
        } else {
            handler.setTarget(target);
        }
    }

    public BungeeFlushConsolidationHandler getFlushConsolidationHandler(boolean toClient) {
        BungeeFlushConsolidationHandler handler = this.ch.pipeline().get(BungeeFlushConsolidationHandler.class);
        if (handler == null) {
            handler = BungeeFlushConsolidationHandler.newInstance(toClient);
            this.ch.pipeline().addFirst("flush-consolidation", (ChannelHandler)handler);
        }
        return handler;
    }

    @Override
    public void write(Object packet) {
        if (!this.closed && this.ch.isActive()) {
            Protocol nextProtocol;
            if (this.queueGamePacket) {
                Object actual;
                Object object = actual = packet instanceof PacketWrapper ? ((PacketWrapper)packet).packet : packet;
                if (actual instanceof LoginPayloadRequest || actual instanceof Kick || actual instanceof LoginSuccess) {
                    this.ch.writeAndFlush(actual, this.ch.voidPromise());
                } else {
                    this.packetQueue.add(packet);
                }
                return;
            }
            DefinedPacket defined = null;
            if (packet instanceof PacketWrapper) {
                PacketWrapper wrapper = (PacketWrapper)packet;
                wrapper.setReleased(true);
                this.ch.writeAndFlush(wrapper.buf, this.ch.voidPromise());
                defined = wrapper.packet;
            } else {
                this.ch.writeAndFlush(packet, this.ch.voidPromise());
                if (packet instanceof DefinedPacket) {
                    defined = (DefinedPacket)packet;
                }
            }
            if (defined != null && (nextProtocol = defined.nextProtocol()) != null) {
                this.setEncodeProtocol(nextProtocol);
            }
        }
    }

    @Override
    public void write(PacketWrapper packet) {
        if (!this.closed && packet != null) {
            Protocol nextProtocol;
            DefinedPacket defined = packet.packet;
            packet.setReleased(true);
            this.ch.writeAndFlush(packet.buf, this.ch.voidPromise());
            if (defined != null && (nextProtocol = defined.nextProtocol()) != null) {
                this.setEncodeProtocol(nextProtocol);
            }
        }
    }

    @Override
    public void markClosed() {
        this.closing = true;
        this.closed = true;
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Object packet) {
        if (!this.closed) {
            this.closing = true;
            this.closed = true;
            if (this.ch.isActive()) {
                this.ch.config().setAutoRead(false);
                if (packet != null) {
                    this.ch.writeAndFlush(packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.CLOSE});
                } else {
                    this.ch.close();
                }
            }
        }
    }

    @Deprecated
    public void delayedClose(Kick kick) {
        this.close(kick);
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    @Override
    public Channel getHandle() {
        return this.ch;
    }

    @Override
    public void setCompressionThreshold(int compressionThreshold) {
        CompressorFactory compressorFactory = Natives.getNetworkCompressorFactory();
        if (this.ch.pipeline().get(PacketCompressor.class) == null && compressionThreshold >= 0) {
            this.addBefore("packet-encoder", "compress", new PacketCompressor(compressorFactory.createCompressor(ConfigSettings.IMP.PERFORMANCE.COMPRESSION.NETWORK.LEVEL)));
            this.ch.pipeline().remove("frame-prepender");
        }
        if (compressionThreshold >= 0) {
            this.ch.pipeline().get(PacketCompressor.class).setThreshold(compressionThreshold);
        } else {
            this.ch.pipeline().remove("compress");
        }
        if (this.ch.pipeline().get(PacketDecompressor.class) == null && compressionThreshold >= 0) {
            PacketDecompressor packetDecompressor = new PacketDecompressor(compressorFactory.createDecompressor(), compressionThreshold);
            this.addBefore("packet-decoder", "decompress", packetDecompressor);
        }
        if (compressionThreshold < 0) {
            this.ch.pipeline().remove("decompress");
        }
    }

    @Override
    public void forceClose() {
        if (!this.closed) {
            this.closing = true;
            this.closed = true;
            this.ch.close();
        }
    }

    public void beginHandshake() {
        this.queueGamePacket = true;
    }

    public void endHandshake() {
        this.queueGamePacket = false;
        while (!this.packetQueue.isEmpty()) {
            this.write(this.packetQueue.poll());
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public SocketAddress getTrueRemoteAddress() {
        return this.trueRemoteAddress;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    public EpollSocketChannel getEpollSocketChannel() {
        return this.epollSocketChannel;
    }
}

