/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.util.QuietException;
import net.shieldcommunity.nullcordx.antibot.virtual.VirtualConnector;
import net.shieldcommunity.nullcordx.api.events.HAProxyConnectionInitEvent;
import net.shieldcommunity.nullcordx.config.ConfigSettings;

public class HandlerBoss
extends ChannelInboundHandlerAdapter {
    private ChannelWrapper channel;
    private PacketHandler handler;

    public void setHandler(PacketHandler handler) {
        Preconditions.checkArgument(handler != null, "handler");
        if (this.handler != null) {
            this.handler.handlerChanged();
        }
        this.handler = handler;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.channel = new ChannelWrapper(ctx);
            this.handler.connected(this.channel);
            if (ConfigSettings.IMP.LOGS.PRINT_HANDLER_BOSS_ACTIVE_INACTIVE && !(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has connected", this.handler.toString());
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.channel.markClosed();
            this.handler.disconnected(this.channel);
            if (ConfigSettings.IMP.LOGS.PRINT_HANDLER_BOSS_ACTIVE_INACTIVE && !(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler) && !(this.handler instanceof VirtualConnector)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has disconnected", this.handler.toString());
            }
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.writabilityChanged(this.channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block15: {
            Protocol nextProtocol;
            if (msg instanceof HAProxyMessage) {
                HAProxyMessage proxy = (HAProxyMessage)msg;
                try {
                    if (proxy.sourceAddress() != null) {
                        SocketAddress oldAddress = this.channel.getRemoteAddress();
                        ListenerInfo listener = this.channel.getHandle().attr(PipelineUtils.LISTENER).get();
                        HAProxyConnectionInitEvent event = new HAProxyConnectionInitEvent(oldAddress, listener, (result, ex) -> {
                            if (result.isCancelled()) {
                                this.channel.close();
                            }
                            InetSocketAddress newAddress = new InetSocketAddress(proxy.sourceAddress(), proxy.sourcePort());
                            ProxyServer.getInstance().getLogger().log(Level.FINE, "Set remote address via PROXY {0} -> {1}", new Object[]{this.channel.getRemoteAddress(), newAddress});
                            this.channel.setRemoteAddress(newAddress);
                        });
                        BungeeCord.getInstance().getPluginManager().callEvent(event);
                    }
                }
                finally {
                    proxy.release();
                }
                return;
            }
            PacketWrapper packet = (PacketWrapper)msg;
            if (packet.packet != null && (nextProtocol = packet.packet.nextProtocol()) != null) {
                this.channel.setDecodeProtocol(nextProtocol);
            }
            if (this.handler != null) {
                boolean sendPacket = this.handler.shouldHandle(packet);
                try {
                    if (this.channel.isClosed()) break block15;
                    if (sendPacket && packet.packet != null) {
                        try {
                            packet.packet.handle(this.handler);
                        }
                        catch (CancelSendSignal ex2) {
                            sendPacket = false;
                        }
                    }
                    if (sendPacket) {
                        this.handler.handle(packet);
                    }
                }
                finally {
                    packet.trySingleRelease();
                }
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            if (this.handler != null) {
                if (this.shouldPrintExceptions()) {
                    if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
                        LogRecord logRecord = new LogRecord(Level.WARNING, "{0} - An exception has been thrown:");
                        logRecord.setParameters(new Object[]{this.handler.toString()});
                        logRecord.setThrown(cause);
                        ProxyServer.getInstance().getLogger().log(logRecord);
                    } else if (cause instanceof ReadTimeoutException) {
                        ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - read timed out", this.handler.toString());
                    } else if (cause instanceof DecoderException) {
                        if (cause instanceof CorruptedFrameException) {
                            ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - corrupted frame: {1}", new Object[]{this.handler.toString(), cause.getMessage()});
                        } else if (cause.getCause() instanceof BadPacketException) {
                            ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - bad packet ID, are mods in use!? {1}", new Object[]{this.handler.toString(), cause.getCause().getMessage()});
                        } else if (cause.getCause() instanceof OverflowPacketException) {
                            ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - overflow in packet detected! {1}", new Object[]{this.handler.toString(), cause.getCause().getMessage()});
                        } else {
                            ProxyServer.getInstance().getLogger().log(Level.WARNING, this.handler.toString() + " - could not decode packet!", cause);
                        }
                    } else if (cause instanceof IOException || cause instanceof IllegalStateException && this.handler instanceof InitialHandler) {
                        ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - {1}: {2}", new Object[]{this.handler.toString(), cause.getClass().getSimpleName(), cause.getMessage()});
                    } else if (cause instanceof QuietException) {
                        ProxyServer.getInstance().getLogger().log(Level.SEVERE, "{0} - encountered exception: {1}", new Object[]{this.handler.toString(), cause});
                    } else {
                        ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler.toString() + " - encountered exception", cause);
                    }
                }
                try {
                    this.handler.exception(cause);
                }
                catch (Exception ex) {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler.toString() + " - exception processing exception", ex);
                }
            }
            if (this.channel != null) {
                this.channel.markClosed();
            }
            ctx.close();
        }
    }

    private boolean shouldPrintExceptions() {
        if (!ConfigSettings.IMP.LOGS.PRINT_HANDLER_BOSS_EXCEPTIONS) {
            return false;
        }
        return this.handler.shouldLogException();
    }
}

