/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty.flush;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.Future;

public final class BungeeFlushConsolidationHandler
extends ChannelDuplexHandler {
    private final int explicitFlushAfterFlushes;
    private final boolean consolidateWhenNoReadInProgress;
    private final Runnable flushTask;
    private int flushPendingCount;
    boolean readInProgress;
    ChannelHandlerContext ctx;
    private Future<?> nextScheduledFlush;
    public static final int DEFAULT_EXPLICIT_FLUSH_AFTER_FLUSHES = 256;

    public static BungeeFlushConsolidationHandler newInstance(boolean toClient) {
        return new BungeeFlushConsolidationHandler(20, false);
    }

    private BungeeFlushConsolidationHandler() {
        this(256, false);
    }

    private BungeeFlushConsolidationHandler(int explicitFlushAfterFlushes) {
        this(explicitFlushAfterFlushes, false);
    }

    private BungeeFlushConsolidationHandler(int explicitFlushAfterFlushes, boolean consolidateWhenNoReadInProgress) {
        this.explicitFlushAfterFlushes = ObjectUtil.checkPositive(explicitFlushAfterFlushes, "explicitFlushAfterFlushes");
        this.consolidateWhenNoReadInProgress = consolidateWhenNoReadInProgress;
        this.flushTask = consolidateWhenNoReadInProgress ? () -> {
            if (this.flushPendingCount > 0 && !this.readInProgress) {
                this.flushPendingCount = 0;
                this.nextScheduledFlush = null;
                this.ctx.flush();
            }
        } : null;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.readInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(ctx);
            }
        } else if (this.consolidateWhenNoReadInProgress) {
            if (++this.flushPendingCount == this.explicitFlushAfterFlushes) {
                this.flushNow(ctx);
            } else {
                this.scheduleFlush(ctx);
            }
        } else {
            this.flushNow(ctx);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx);
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx);
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.resetReadAndFlushIfNeeded(ctx);
        ctx.close(promise);
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (!ctx.channel().isWritable()) {
            this.flushIfNeeded(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.flushIfNeeded(ctx);
    }

    void resetReadAndFlushIfNeeded(ChannelHandlerContext ctx) {
        this.readInProgress = false;
        this.flushIfNeeded(ctx);
    }

    void flushIfNeeded(ChannelHandlerContext ctx) {
        if (this.flushPendingCount > 0) {
            this.flushNow(ctx);
        }
    }

    private void flushNow(ChannelHandlerContext ctx) {
        this.cancelScheduledFlush();
        this.flushPendingCount = 0;
        ctx.flush();
    }

    private void scheduleFlush(ChannelHandlerContext ctx) {
        if (this.nextScheduledFlush == null) {
            this.nextScheduledFlush = ctx.channel().eventLoop().submit(this.flushTask);
        }
    }

    private void cancelScheduledFlush() {
        if (this.nextScheduledFlush != null) {
            this.nextScheduledFlush.cancel(false);
            this.nextScheduledFlush = null;
        }
    }
}

