/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.function.Supplier;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClearTitles;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientChatAcknowledgement;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.md_5.bungee.protocol.packet.ClientCommandSigned;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.CookieRequest;
import net.md_5.bungee.protocol.packet.CookieResponse;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.EntityEffect;
import net.md_5.bungee.protocol.packet.EntityRemoveEffect;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.FinishConfiguration;
import net.md_5.bungee.protocol.packet.GameState;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginAcknowledged;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemRemove;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.ScoreboardScoreReset;
import net.md_5.bungee.protocol.packet.ServerData;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StartConfiguration;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.StoreCookie;
import net.md_5.bungee.protocol.packet.Subtitle;
import net.md_5.bungee.protocol.packet.SystemChat;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;
import net.md_5.bungee.protocol.packet.TitleTimes;
import net.md_5.bungee.protocol.packet.Transfer;
import net.md_5.bungee.protocol.packet.ViewDistance;
import net.shieldcommunity.nullcordx.protocol.packets.BlockUpdatePacket;
import net.shieldcommunity.nullcordx.protocol.packets.DefaultSpawnPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.EmptyChunkPacket;
import net.shieldcommunity.nullcordx.protocol.packets.EntityEffectPacket;
import net.shieldcommunity.nullcordx.protocol.packets.EntityInteractPacket;
import net.shieldcommunity.nullcordx.protocol.packets.GameEventPacket;
import net.shieldcommunity.nullcordx.protocol.packets.LoginPacket;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.protocol.packets.MultiBlockUpdatePacket;
import net.shieldcommunity.nullcordx.protocol.packets.PingTransactionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerAbilitiesPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerInfoPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerOnGroundPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionAndLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PongTransactionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.RegistryDataPacket;
import net.shieldcommunity.nullcordx.protocol.packets.RemoveEntitiesPacket;
import net.shieldcommunity.nullcordx.protocol.packets.RemoveEntityEffectPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetCenterChunkPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetEntityMetadataPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetExperiencePacket;
import net.shieldcommunity.nullcordx.protocol.packets.SetSlotPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SpawnEntityPacket;
import net.shieldcommunity.nullcordx.protocol.packets.SynchronizePlayerPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.TeleportConfirmPacket;
import net.shieldcommunity.nullcordx.protocol.packets.TimeUpdatePacket;
import net.shieldcommunity.nullcordx.protocol.packets.UniversalChatPacket;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(Handshake.class, Handshake::new, Protocol.map(47, 0));
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(47, 0), Protocol.map(107, 31), Protocol.map(393, 33), Protocol.map(477, 32), Protocol.map(573, 33), Protocol.map(735, 32), Protocol.map(751, 31), Protocol.map(755, 33), Protocol.map(759, 30), Protocol.map(760, 32), Protocol.map(761, 31), Protocol.map(762, 35), Protocol.map(764, 36), Protocol.map(0x400000BB, 38));
            this.TO_CLIENT.registerPacket(Login.class, Login::new, Protocol.map(47, 1), Protocol.map(107, 35), Protocol.map(393, 37), Protocol.map(573, 38), Protocol.map(735, 37), Protocol.map(751, 36), Protocol.map(755, 38), Protocol.map(759, 35), Protocol.map(760, 37), Protocol.map(761, 36), Protocol.map(762, 40), Protocol.map(764, 41), Protocol.map(0x400000BB, 43));
            this.TO_CLIENT.registerPacket(Chat.class, Chat::new, Protocol.map(47, 2), Protocol.map(107, 15), Protocol.map(393, 14), Protocol.map(573, 15), Protocol.map(735, 14), Protocol.map(755, 15), Protocol.map(759, -1));
            this.TO_CLIENT.registerPacket(Respawn.class, Respawn::new, Protocol.map(47, 7), Protocol.map(107, 51), Protocol.map(335, 52), Protocol.map(338, 53), Protocol.map(393, 56), Protocol.map(477, 58), Protocol.map(573, 59), Protocol.map(735, 58), Protocol.map(751, 57), Protocol.map(755, 61), Protocol.map(759, 59), Protocol.map(760, 62), Protocol.map(761, 61), Protocol.map(762, 65), Protocol.map(764, 67), Protocol.map(765, 69), Protocol.map(0x400000BB, 71));
            this.TO_CLIENT.registerPacket(BossBar.class, BossBar::new, Protocol.map(107, 12), Protocol.map(573, 13), Protocol.map(735, 12), Protocol.map(755, 13), Protocol.map(759, 10), Protocol.map(762, 11), Protocol.map(764, 10));
            this.TO_CLIENT.registerPacket(EntityEffect.class, EntityEffect::new, Protocol.map(47, 29), Protocol.map(107, -1));
            this.TO_CLIENT.registerPacket(EntityRemoveEffect.class, EntityRemoveEffect::new, Protocol.map(47, 30), Protocol.map(107, -1));
            this.TO_CLIENT.registerPacket(PlayerListItem.class, PlayerListItem::new, Protocol.map(47, 56), Protocol.map(107, 45), Protocol.map(338, 46), Protocol.map(393, 48), Protocol.map(477, 51), Protocol.map(573, 52), Protocol.map(735, 51), Protocol.map(751, 50), Protocol.map(755, 54), Protocol.map(759, 52), Protocol.map(760, 55), Protocol.map(761, -1));
            this.TO_CLIENT.registerPacket(TabCompleteResponse.class, TabCompleteResponse::new, Protocol.map(47, 58), Protocol.map(107, 14), Protocol.map(393, 16), Protocol.map(573, 17), Protocol.map(735, 16), Protocol.map(751, 15), Protocol.map(755, 17), Protocol.map(759, 14), Protocol.map(761, 13), Protocol.map(762, 15), Protocol.map(764, 16));
            this.TO_CLIENT.registerPacket(ScoreboardObjective.class, ScoreboardObjective::new, Protocol.map(47, 59), Protocol.map(107, 63), Protocol.map(335, 65), Protocol.map(338, 66), Protocol.map(393, 69), Protocol.map(477, 73), Protocol.map(573, 74), Protocol.map(755, 83), Protocol.map(760, 86), Protocol.map(761, 84), Protocol.map(762, 88), Protocol.map(764, 90), Protocol.map(765, 92), Protocol.map(0x400000BB, 94));
            this.TO_CLIENT.registerPacket(ScoreboardScore.class, ScoreboardScore::new, Protocol.map(47, 60), Protocol.map(107, 66), Protocol.map(335, 68), Protocol.map(338, 69), Protocol.map(393, 72), Protocol.map(477, 76), Protocol.map(573, 77), Protocol.map(755, 86), Protocol.map(760, 89), Protocol.map(761, 87), Protocol.map(762, 91), Protocol.map(764, 93), Protocol.map(765, 95), Protocol.map(0x400000BB, 97));
            this.TO_CLIENT.registerPacket(ScoreboardScoreReset.class, ScoreboardScoreReset::new, Protocol.map(765, 66), Protocol.map(0x400000BB, 68));
            this.TO_CLIENT.registerPacket(ScoreboardDisplay.class, ScoreboardDisplay::new, Protocol.map(47, 61), Protocol.map(107, 56), Protocol.map(335, 58), Protocol.map(338, 59), Protocol.map(393, 62), Protocol.map(477, 66), Protocol.map(573, 67), Protocol.map(755, 76), Protocol.map(760, 79), Protocol.map(761, 77), Protocol.map(762, 81), Protocol.map(764, 83), Protocol.map(765, 85), Protocol.map(0x400000BB, 87));
            this.TO_CLIENT.registerPacket(Team.class, Team::new, Protocol.map(47, 62), Protocol.map(107, 65), Protocol.map(335, 67), Protocol.map(338, 68), Protocol.map(393, 71), Protocol.map(477, 75), Protocol.map(573, 76), Protocol.map(755, 85), Protocol.map(760, 88), Protocol.map(761, 86), Protocol.map(762, 90), Protocol.map(764, 92), Protocol.map(765, 94), Protocol.map(0x400000BB, 96));
            this.TO_CLIENT.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(47, 63), Protocol.map(107, 24), Protocol.map(393, 25), Protocol.map(477, 24), Protocol.map(573, 25), Protocol.map(735, 24), Protocol.map(751, 23), Protocol.map(755, 24), Protocol.map(759, 21), Protocol.map(760, 22), Protocol.map(761, 21), Protocol.map(762, 23), Protocol.map(764, 24), Protocol.map(0x400000BB, 25));
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, Protocol.map(47, 64), Protocol.map(107, 26), Protocol.map(393, 27), Protocol.map(477, 26), Protocol.map(573, 27), Protocol.map(735, 26), Protocol.map(751, 25), Protocol.map(755, 26), Protocol.map(759, 23), Protocol.map(760, 25), Protocol.map(761, 23), Protocol.map(762, 26), Protocol.map(764, 27), Protocol.map(0x400000BB, 29));
            this.TO_CLIENT.registerPacket(Title.class, Title::new, Protocol.map(47, 69), Protocol.map(335, 71), Protocol.map(338, 72), Protocol.map(393, 75), Protocol.map(477, 79), Protocol.map(573, 80), Protocol.map(735, 79), Protocol.map(755, 89), Protocol.map(757, 90), Protocol.map(760, 93), Protocol.map(761, 91), Protocol.map(762, 95), Protocol.map(764, 97), Protocol.map(765, 99), Protocol.map(0x400000BB, 101));
            this.TO_CLIENT.registerPacket(ClearTitles.class, ClearTitles::new, Protocol.map(755, 16), Protocol.map(759, 13), Protocol.map(761, 12), Protocol.map(762, 14), Protocol.map(764, 15));
            this.TO_CLIENT.registerPacket(Subtitle.class, Subtitle::new, Protocol.map(755, 87), Protocol.map(757, 88), Protocol.map(760, 91), Protocol.map(761, 89), Protocol.map(762, 93), Protocol.map(764, 95), Protocol.map(765, 97), Protocol.map(0x400000BB, 99));
            this.TO_CLIENT.registerPacket(TitleTimes.class, TitleTimes::new, Protocol.map(755, 90), Protocol.map(757, 91), Protocol.map(760, 94), Protocol.map(761, 92), Protocol.map(762, 96), Protocol.map(764, 98), Protocol.map(765, 100), Protocol.map(0x400000BB, 102));
            this.TO_CLIENT.registerPacket(SystemChat.class, SystemChat::new, Protocol.map(759, 95), Protocol.map(760, 98), Protocol.map(761, 96), Protocol.map(762, 100), Protocol.map(764, 103), Protocol.map(765, 105), Protocol.map(0x400000BB, 108));
            this.TO_CLIENT.registerPacket(PlayerListHeaderFooter.class, PlayerListHeaderFooter::new, Protocol.map(47, 71), Protocol.map(107, 72), Protocol.map(110, 71), Protocol.map(335, 73), Protocol.map(338, 74), Protocol.map(393, 78), Protocol.map(477, 83), Protocol.map(573, 84), Protocol.map(735, 83), Protocol.map(755, 94), Protocol.map(757, 95), Protocol.map(759, 96), Protocol.map(760, 99), Protocol.map(761, 97), Protocol.map(762, 101), Protocol.map(764, 104), Protocol.map(765, 106), Protocol.map(0x400000BB, 109));
            this.TO_CLIENT.registerPacket(EntityStatus.class, EntityStatus::new, Protocol.map(47, 26), Protocol.map(107, 27), Protocol.map(393, 28), Protocol.map(477, 27), Protocol.map(573, 28), Protocol.map(735, 27), Protocol.map(751, 26), Protocol.map(755, 27), Protocol.map(759, 24), Protocol.map(760, 26), Protocol.map(761, 25), Protocol.map(762, 28), Protocol.map(764, 29), Protocol.map(0x400000BB, 31));
            this.TO_CLIENT.registerPacket(Commands.class, Commands::new, Protocol.map(393, 17), Protocol.map(573, 18), Protocol.map(735, 17), Protocol.map(751, 16), Protocol.map(755, 18), Protocol.map(759, 15), Protocol.map(761, 14), Protocol.map(762, 16), Protocol.map(764, 17));
            this.TO_CLIENT.registerPacket(GameState.class, GameState::new, Protocol.map(573, 31), Protocol.map(735, 30), Protocol.map(751, 29), Protocol.map(755, 30), Protocol.map(759, 27), Protocol.map(760, 29), Protocol.map(761, 28), Protocol.map(762, 31), Protocol.map(764, 32), Protocol.map(0x400000BB, 34));
            this.TO_CLIENT.registerPacket(ViewDistance.class, ViewDistance::new, Protocol.map(477, 65), Protocol.map(573, 66), Protocol.map(735, 65), Protocol.map(755, 74), Protocol.map(759, 73), Protocol.map(760, 76), Protocol.map(761, 75), Protocol.map(762, 79), Protocol.map(764, 81), Protocol.map(765, 83), Protocol.map(0x400000BB, 85));
            this.TO_CLIENT.registerPacket(ServerData.class, ServerData::new, Protocol.map(759, 63), Protocol.map(760, 66), Protocol.map(761, 65), Protocol.map(762, 69), Protocol.map(764, 71), Protocol.map(765, 73), Protocol.map(0x400000BB, 75));
            this.TO_CLIENT.registerPacket(PlayerListItemRemove.class, PlayerListItemRemove::new, Protocol.map(761, 53), Protocol.map(762, 57), Protocol.map(764, 59), Protocol.map(0x400000BB, 61));
            this.TO_CLIENT.registerPacket(PlayerListItemUpdate.class, PlayerListItemUpdate::new, Protocol.map(761, 54), Protocol.map(762, 58), Protocol.map(764, 60), Protocol.map(0x400000BB, 62));
            this.TO_CLIENT.registerPacket(StartConfiguration.class, StartConfiguration::new, Protocol.map(764, 101), Protocol.map(765, 103), Protocol.map(0x400000BB, 105));
            this.TO_CLIENT.registerPacket(CookieRequest.class, CookieRequest::new, Protocol.map(0x400000BB, 22));
            this.TO_CLIENT.registerPacket(StoreCookie.class, StoreCookie::new, Protocol.map(0x400000BB, 107));
            this.TO_CLIENT.registerPacket(Transfer.class, Transfer::new, Protocol.map(0x400000BB, 115));
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(47, 0), Protocol.map(107, 11), Protocol.map(335, 12), Protocol.map(338, 11), Protocol.map(393, 14), Protocol.map(477, 15), Protocol.map(735, 16), Protocol.map(755, 15), Protocol.map(759, 17), Protocol.map(760, 18), Protocol.map(761, 17), Protocol.map(762, 18), Protocol.map(764, 20), Protocol.map(765, 21), Protocol.map(0x400000BB, 24));
            this.TO_SERVER.registerPacket(Chat.class, Chat::new, Protocol.map(47, 1), Protocol.map(107, 2), Protocol.map(335, 3), Protocol.map(338, 2), Protocol.map(477, 3), Protocol.map(759, -1));
            this.TO_SERVER.registerPacket(ClientCommand.class, ClientCommand::new, Protocol.map(759, 3), Protocol.map(760, 4));
            this.TO_SERVER.registerPacket(ClientCommandSigned.class, ClientCommandSigned::new, Protocol.map(0x400000BB, 5));
            this.TO_SERVER.registerPacket(ClientChat.class, ClientChat::new, Protocol.map(759, 4), Protocol.map(760, 5), Protocol.map(0x400000BB, 6));
            this.TO_SERVER.registerPacket(ClientChatAcknowledgement.class, ClientChatAcknowledgement::new, Protocol.map(761, 3));
            this.TO_SERVER.registerPacket(TabCompleteRequest.class, TabCompleteRequest::new, Protocol.map(47, 20), Protocol.map(107, 1), Protocol.map(335, 2), Protocol.map(338, 1), Protocol.map(393, 5), Protocol.map(477, 6), Protocol.map(759, 8), Protocol.map(760, 9), Protocol.map(761, 8), Protocol.map(762, 9), Protocol.map(764, 10), Protocol.map(0x400000BB, 11));
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, Protocol.map(47, 21), Protocol.map(107, 4), Protocol.map(335, 5), Protocol.map(338, 4), Protocol.map(477, 5), Protocol.map(759, 7), Protocol.map(760, 8), Protocol.map(761, 7), Protocol.map(762, 8), Protocol.map(764, 9), Protocol.map(0x400000BB, 10));
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(47, 23), Protocol.map(107, 9), Protocol.map(335, 10), Protocol.map(338, 9), Protocol.map(393, 10), Protocol.map(477, 11), Protocol.map(755, 10), Protocol.map(759, 12), Protocol.map(760, 13), Protocol.map(761, 12), Protocol.map(762, 13), Protocol.map(764, 15), Protocol.map(765, 16), Protocol.map(0x400000BB, 18));
            this.TO_SERVER.registerPacket(StartConfiguration.class, StartConfiguration::new, Protocol.map(764, 11), Protocol.map(0x400000BB, 12));
            this.TO_SERVER.registerPacket(CookieResponse.class, CookieResponse::new, Protocol.map(0x400000BB, 17));
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(StatusResponse.class, StatusResponse::new, Protocol.map(47, 0));
            this.TO_CLIENT.registerPacket(PingPacket.class, PingPacket::new, Protocol.map(47, 1));
            this.TO_SERVER.registerPacket(StatusRequest.class, StatusRequest::new, Protocol.map(47, 0));
            this.TO_SERVER.registerPacket(PingPacket.class, PingPacket::new, Protocol.map(47, 1));
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, Protocol.map(47, 0));
            this.TO_CLIENT.registerPacket(EncryptionRequest.class, EncryptionRequest::new, Protocol.map(47, 1));
            this.TO_CLIENT.registerPacket(LoginSuccess.class, LoginSuccess::new, Protocol.map(47, 2));
            this.TO_CLIENT.registerPacket(SetCompression.class, SetCompression::new, Protocol.map(47, 3));
            this.TO_CLIENT.registerPacket(LoginPayloadRequest.class, LoginPayloadRequest::new, Protocol.map(393, 4));
            this.TO_CLIENT.registerPacket(CookieRequest.class, CookieRequest::new, Protocol.map(0x400000BB, 5));
            this.TO_SERVER.registerPacket(LoginRequest.class, LoginRequest::new, Protocol.map(47, 0));
            this.TO_SERVER.registerPacket(EncryptionResponse.class, EncryptionResponse::new, Protocol.map(47, 1));
            this.TO_SERVER.registerPacket(LoginPayloadResponse.class, LoginPayloadResponse::new, Protocol.map(393, 2));
            this.TO_SERVER.registerPacket(LoginAcknowledged.class, LoginAcknowledged::new, Protocol.map(764, 3));
            this.TO_SERVER.registerPacket(CookieResponse.class, CookieResponse::new, Protocol.map(0x400000BB, 4));
        }
    }
    ,
    CONFIGURATION{
        {
            this.TO_CLIENT.registerPacket(CookieRequest.class, CookieRequest::new, Protocol.map(0x400000BB, 0));
            this.TO_CLIENT.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(764, 0), Protocol.map(0x400000BB, 1));
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, Protocol.map(764, 1), Protocol.map(0x400000BB, 2));
            this.TO_CLIENT.registerPacket(FinishConfiguration.class, FinishConfiguration::new, Protocol.map(764, 2), Protocol.map(0x400000BB, 3));
            this.TO_CLIENT.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(764, 3), Protocol.map(0x400000BB, 4));
            this.TO_CLIENT.registerPacket(StoreCookie.class, StoreCookie::new, Protocol.map(0x400000BB, 10));
            this.TO_CLIENT.registerPacket(Transfer.class, Transfer::new, Protocol.map(0x400000BB, 11));
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, Protocol.map(764, 0));
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(764, 1), Protocol.map(0x400000BB, 2));
            this.TO_SERVER.registerPacket(FinishConfiguration.class, FinishConfiguration::new, Protocol.map(764, 2), Protocol.map(0x400000BB, 3));
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(764, 3), Protocol.map(0x400000BB, 4));
        }
    }
    ,
    CONFIGURATION_FILTER{
        {
            this.TO_CLIENT.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(764, 0));
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, Protocol.map(764, 1));
            this.TO_CLIENT.registerPacket(FinishConfiguration.class, FinishConfiguration::new, Protocol.map(764, 2));
            this.TO_CLIENT.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(764, 3));
            this.TO_CLIENT.registerPacket(RegistryDataPacket.class, RegistryDataPacket::new, Protocol.map(764, 5));
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, Protocol.map(764, 0));
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(764, 1));
            this.TO_SERVER.registerPacket(FinishConfiguration.class, FinishConfiguration::new, Protocol.map(764, 2));
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(764, 3));
        }
    }
    ,
    FILTER{
        {
            this.TO_CLIENT.registerPacket(LoginPacket.class, LoginPacket::new, Protocol.map(47, 1), Protocol.map(107, 35), Protocol.map(393, 37), Protocol.map(573, 38), Protocol.map(735, 37), Protocol.map(751, 36), Protocol.map(755, 38), Protocol.map(759, 35), Protocol.map(760, 37), Protocol.map(761, 36), Protocol.map(762, 40), Protocol.map(764, 41));
            this.TO_CLIENT.registerPacket(TimeUpdatePacket.class, TimeUpdatePacket::new, Protocol.map(47, 3), Protocol.map(107, 68), Protocol.map(335, 70), Protocol.map(338, 71), Protocol.map(393, 74), Protocol.map(477, 78), Protocol.map(573, 79), Protocol.map(735, 78), Protocol.map(755, 88), Protocol.map(757, 89), Protocol.map(760, 92), Protocol.map(761, 90), Protocol.map(762, 94), Protocol.map(764, 96), Protocol.map(765, 98));
            this.TO_CLIENT.registerPacket(SynchronizePlayerPositionPacket.class, SynchronizePlayerPositionPacket::new, Protocol.map(47, 8), Protocol.map(107, 46), Protocol.map(338, 47), Protocol.map(393, 50), Protocol.map(477, 53), Protocol.map(573, 54), Protocol.map(735, 53), Protocol.map(751, 52), Protocol.map(755, 56), Protocol.map(759, 54), Protocol.map(760, 57), Protocol.map(761, 56), Protocol.map(762, 60), Protocol.map(764, 62));
            this.TO_CLIENT.registerPacket(EmptyChunkPacket.class, EmptyChunkPacket::new, Protocol.map(47, 33), Protocol.map(107, 32), Protocol.map(393, 34), Protocol.map(477, 33), Protocol.map(573, 34), Protocol.map(735, 33), Protocol.map(751, 32), Protocol.map(755, 34), Protocol.map(759, 31), Protocol.map(760, 33), Protocol.map(761, 32), Protocol.map(762, 36), Protocol.map(764, 37));
            this.TO_CLIENT.registerPacket(SetSlotPacket.class, SetSlotPacket::new, Protocol.map(47, 47), Protocol.map(107, 22), Protocol.map(393, 23), Protocol.map(477, 22), Protocol.map(573, 23), Protocol.map(735, 22), Protocol.map(751, 21), Protocol.map(755, 22), Protocol.map(759, 19), Protocol.map(761, 18), Protocol.map(762, 20), Protocol.map(764, 21));
            this.TO_CLIENT.registerPacket(PlayerAbilitiesPacket.class, PlayerAbilitiesPacket::new, Protocol.map(47, 57), Protocol.map(107, 43), Protocol.map(338, 44), Protocol.map(393, 46), Protocol.map(477, 49), Protocol.map(573, 50), Protocol.map(735, 49), Protocol.map(751, 48), Protocol.map(755, 50), Protocol.map(759, 47), Protocol.map(760, 49), Protocol.map(761, 48), Protocol.map(762, 52), Protocol.map(764, 54));
            this.TO_CLIENT.registerPacket(MapDataPacket.class, MapDataPacket::new, Protocol.map(47, 52), Protocol.map(107, 36), Protocol.map(393, 38), Protocol.map(573, 39), Protocol.map(735, 38), Protocol.map(751, 37), Protocol.map(755, 39), Protocol.map(759, 36), Protocol.map(760, 38), Protocol.map(761, 37), Protocol.map(762, 41), Protocol.map(764, 42));
            this.TO_CLIENT.registerPacket(UniversalChatPacket.class, UniversalChatPacket::new, Protocol.map(47, 2), Protocol.map(107, 15), Protocol.map(393, 14), Protocol.map(573, 15), Protocol.map(735, 14), Protocol.map(755, 15), Protocol.map(759, 95), Protocol.map(760, 98), Protocol.map(761, 96), Protocol.map(762, 100), Protocol.map(764, 103), Protocol.map(765, 105));
            this.TO_CLIENT.registerPacket(SpawnEntityPacket.class, SpawnEntityPacket::new, Protocol.map(47, 14), Protocol.map(107, 0), Protocol.map(762, 1));
            this.TO_CLIENT.registerPacket(SetEntityMetadataPacket.class, SetEntityMetadataPacket::new, Protocol.map(47, 28), Protocol.map(107, 57), Protocol.map(335, 59), Protocol.map(338, 60), Protocol.map(393, 63), Protocol.map(477, 67), Protocol.map(573, 68), Protocol.map(755, 77), Protocol.map(760, 80), Protocol.map(761, 78), Protocol.map(762, 82), Protocol.map(764, 84), Protocol.map(765, 86));
            this.TO_CLIENT.registerPacket(RemoveEntitiesPacket.class, RemoveEntitiesPacket::new, Protocol.map(47, 19), Protocol.map(107, 48), Protocol.map(335, 49), Protocol.map(338, 50), Protocol.map(393, 53), Protocol.map(477, 55), Protocol.map(573, 56), Protocol.map(735, 55), Protocol.map(751, 54), Protocol.map(755, 58), Protocol.map(759, 56), Protocol.map(760, 59), Protocol.map(761, 58), Protocol.map(762, 62), Protocol.map(764, 64));
            this.TO_CLIENT.registerPacket(DefaultSpawnPositionPacket.class, DefaultSpawnPositionPacket::new, Protocol.map(47, 5), Protocol.map(107, 67), Protocol.map(335, 69), Protocol.map(338, 70), Protocol.map(393, 73), Protocol.map(477, 77), Protocol.map(573, 78), Protocol.map(735, 66), Protocol.map(755, 75), Protocol.map(759, 74), Protocol.map(760, 77), Protocol.map(761, 76), Protocol.map(762, 80), Protocol.map(764, 82), Protocol.map(765, 84));
            this.TO_CLIENT.registerPacket(BlockUpdatePacket.class, BlockUpdatePacket::new, Protocol.map(47, 35), Protocol.map(107, 11), Protocol.map(573, 12), Protocol.map(735, 11), Protocol.map(755, 12), Protocol.map(759, 9), Protocol.map(762, 10), Protocol.map(764, 9));
            this.TO_CLIENT.registerPacket(MultiBlockUpdatePacket.class, MultiBlockUpdatePacket::new, Protocol.map(47, 34), Protocol.map(107, 16), Protocol.map(393, 15), Protocol.map(573, 16), Protocol.map(735, 15), Protocol.map(751, 59), Protocol.map(755, 63), Protocol.map(759, 61), Protocol.map(760, 64), Protocol.map(761, 63), Protocol.map(762, 67), Protocol.map(764, 69), Protocol.map(765, 71));
            this.TO_CLIENT.registerPacket(PingTransactionPacket.class, PingTransactionPacket::new, Protocol.map(47, 50), Protocol.map(107, 17), Protocol.map(393, 18), Protocol.map(573, 19), Protocol.map(735, 18), Protocol.map(751, 17), Protocol.map(755, 48), Protocol.map(759, 45), Protocol.map(760, 47), Protocol.map(761, 46), Protocol.map(762, 50), Protocol.map(764, 51));
            this.TO_CLIENT.registerPacket(EntityEffectPacket.class, EntityEffectPacket::new, Protocol.map(47, 29), Protocol.map(107, 76), Protocol.map(110, 75), Protocol.map(335, 78), Protocol.map(338, 79), Protocol.map(393, 83), Protocol.map(477, 89), Protocol.map(573, 90), Protocol.map(735, 89), Protocol.map(755, 100), Protocol.map(757, 101), Protocol.map(759, 102), Protocol.map(760, 105), Protocol.map(761, 104), Protocol.map(762, 108), Protocol.map(764, 110), Protocol.map(765, 114));
            this.TO_CLIENT.registerPacket(RemoveEntityEffectPacket.class, RemoveEntityEffectPacket::new, Protocol.map(47, 30), Protocol.map(107, 49), Protocol.map(335, 50), Protocol.map(338, 51), Protocol.map(393, 54), Protocol.map(477, 56), Protocol.map(573, 57), Protocol.map(735, 56), Protocol.map(751, 55), Protocol.map(755, 59), Protocol.map(759, 57), Protocol.map(760, 60), Protocol.map(761, 59), Protocol.map(762, 63), Protocol.map(764, 65));
            this.TO_CLIENT.registerPacket(GameEventPacket.class, GameEventPacket::new, Protocol.map(47, 43), Protocol.map(107, 30), Protocol.map(393, 32), Protocol.map(477, 30), Protocol.map(573, 31), Protocol.map(735, 30), Protocol.map(751, 29), Protocol.map(755, 30), Protocol.map(759, 27), Protocol.map(760, 29), Protocol.map(761, 28), Protocol.map(762, 31), Protocol.map(764, 32));
            this.TO_CLIENT.registerPacket(PlayerInfoPacket.class, PlayerInfoPacket::new, Protocol.map(47, 56), Protocol.map(107, 45), Protocol.map(338, 46), Protocol.map(393, 48), Protocol.map(477, 51), Protocol.map(573, 52), Protocol.map(735, 51), Protocol.map(751, 50), Protocol.map(755, 54), Protocol.map(759, 52), Protocol.map(760, 55), Protocol.map(761, 54), Protocol.map(762, 58), Protocol.map(764, 60));
            this.TO_CLIENT.registerPacket(SetCenterChunkPacket.class, SetCenterChunkPacket::new, Protocol.map(477, 64), Protocol.map(573, 65), Protocol.map(735, 64), Protocol.map(755, 73), Protocol.map(759, 72), Protocol.map(760, 75), Protocol.map(761, 74), Protocol.map(762, 78), Protocol.map(764, 80), Protocol.map(765, 82));
            this.TO_CLIENT.registerPacket(SetExperiencePacket.class, SetExperiencePacket::new, Protocol.map(47, 31), Protocol.map(107, 61), Protocol.map(335, 63), Protocol.map(338, 64), Protocol.map(393, 67), Protocol.map(477, 71), Protocol.map(573, 72), Protocol.map(755, 81), Protocol.map(760, 84), Protocol.map(761, 82), Protocol.map(762, 86), Protocol.map(764, 88), Protocol.map(765, 90));
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, Protocol.map(47, 21), Protocol.map(107, 4), Protocol.map(335, 5), Protocol.map(338, 4), Protocol.map(477, 5), Protocol.map(759, 7), Protocol.map(760, 8), Protocol.map(761, 7), Protocol.map(762, 8), Protocol.map(764, 9));
            this.TO_SERVER.registerPacket(TeleportConfirmPacket.class, TeleportConfirmPacket::new, Protocol.map(107, 0));
            this.TO_SERVER.registerPacket(PlayerPositionAndLookPacket.class, PlayerPositionAndLookPacket::new, Protocol.map(47, 6), Protocol.map(107, 13), Protocol.map(335, 15), Protocol.map(338, 14), Protocol.map(393, 17), Protocol.map(477, 18), Protocol.map(735, 19), Protocol.map(755, 18), Protocol.map(759, 20), Protocol.map(760, 21), Protocol.map(761, 20), Protocol.map(762, 21), Protocol.map(764, 23), Protocol.map(765, 24));
            this.TO_SERVER.registerPacket(PlayerPositionPacket.class, PlayerPositionPacket::new, Protocol.map(47, 4), Protocol.map(107, 12), Protocol.map(335, 14), Protocol.map(338, 13), Protocol.map(393, 16), Protocol.map(477, 17), Protocol.map(735, 18), Protocol.map(755, 17), Protocol.map(759, 19), Protocol.map(760, 20), Protocol.map(761, 19), Protocol.map(762, 20), Protocol.map(764, 22), Protocol.map(765, 23));
            this.TO_SERVER.registerPacket(PlayerOnGroundPacket.class, PlayerOnGroundPacket::new, Protocol.map(47, 3), Protocol.map(107, 15), Protocol.map(335, 13), Protocol.map(338, 12), Protocol.map(393, 15), Protocol.map(477, 20), Protocol.map(735, 21), Protocol.map(755, 20), Protocol.map(759, 22), Protocol.map(760, 23), Protocol.map(761, 22), Protocol.map(762, 23), Protocol.map(764, 25), Protocol.map(765, 26));
            this.TO_SERVER.registerPacket(PlayerLookPacket.class, PlayerLookPacket::new, Protocol.map(47, 5), Protocol.map(107, 14), Protocol.map(335, 16), Protocol.map(338, 15), Protocol.map(393, 18), Protocol.map(477, 19), Protocol.map(735, 20), Protocol.map(755, 19), Protocol.map(759, 21), Protocol.map(760, 22), Protocol.map(761, 21), Protocol.map(762, 22), Protocol.map(764, 24), Protocol.map(765, 25));
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, Protocol.map(47, 0), Protocol.map(107, 11), Protocol.map(335, 12), Protocol.map(338, 11), Protocol.map(393, 14), Protocol.map(477, 15), Protocol.map(735, 16), Protocol.map(755, 15), Protocol.map(759, 17), Protocol.map(760, 18), Protocol.map(761, 17), Protocol.map(762, 18), Protocol.map(764, 20), Protocol.map(765, 21));
            this.TO_SERVER.registerPacket(Chat.class, Chat::new, Protocol.map(47, 1), Protocol.map(107, 2), Protocol.map(335, 3), Protocol.map(338, 2), Protocol.map(477, 3), Protocol.map(759, -1));
            this.TO_SERVER.registerPacket(ClientChat.class, ClientChat::new, Protocol.map(759, 4), Protocol.map(760, 5));
            this.TO_SERVER.registerPacket(ClientCommand.class, ClientCommand::new, Protocol.map(759, 3), Protocol.map(760, 4));
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, Protocol.map(47, 23), Protocol.map(107, 9), Protocol.map(335, 10), Protocol.map(338, 9), Protocol.map(393, 10), Protocol.map(477, 11), Protocol.map(755, 10), Protocol.map(759, 12), Protocol.map(760, 13), Protocol.map(761, 12), Protocol.map(762, 13), Protocol.map(764, 15), Protocol.map(765, 16));
            this.TO_SERVER.registerPacket(EntityInteractPacket.class, EntityInteractPacket::new, Protocol.map(47, 2), Protocol.map(107, 10), Protocol.map(335, 11), Protocol.map(338, 10), Protocol.map(393, 13), Protocol.map(477, 14), Protocol.map(755, 13), Protocol.map(759, 15), Protocol.map(760, 16), Protocol.map(761, 15), Protocol.map(762, 16), Protocol.map(764, 18), Protocol.map(765, 19));
            this.TO_SERVER.registerPacket(PongTransactionPacket.class, PongTransactionPacket::new, Protocol.map(47, 15), Protocol.map(107, 5), Protocol.map(335, 6), Protocol.map(338, 5), Protocol.map(393, 6), Protocol.map(477, 7), Protocol.map(755, 29), Protocol.map(759, 31), Protocol.map(760, 32), Protocol.map(761, 31), Protocol.map(762, 32), Protocol.map(764, 35), Protocol.map(765, 36));
        }
    };

    public static final int MAX_PACKET_ID = 255;
    public final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    public static void main(String[] args) {
        for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS) {
            Protocol.dump(version);
        }
    }

    private static void dump(int version) {
        for (Protocol protocol : Protocol.values()) {
            Protocol.dump(version, protocol);
        }
    }

    private static void dump(int version, Protocol protocol) {
        Protocol.dump(version, protocol.TO_CLIENT);
        Protocol.dump(version, protocol.TO_SERVER);
    }

    private static void dump(int version, DirectionData data) {
        for (int id = 0; id < 255; ++id) {
            DefinedPacket packet = data.createPacket(id, version);
            if (packet == null) continue;
            System.out.println(version + " " + data.protocolPhase + " " + data.direction + " " + id + " " + packet.getClass().getSimpleName());
        }
    }

    private static ProtocolMapping map(int protocol, int id) {
        return new ProtocolMapping(protocol, id);
    }

    public static final class DirectionData {
        private final TIntObjectMap<ProtocolData> protocols = new TIntObjectHashMap<ProtocolData>();
        private final Protocol protocolPhase;
        private final ProtocolConstants.Direction direction;

        public DirectionData(Protocol protocolPhase, ProtocolConstants.Direction direction) {
            this.protocolPhase = protocolPhase;
            this.direction = direction;
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                this.protocols.put(protocol, new ProtocolData(protocol));
            }
        }

        private ProtocolData getProtocolData(int version) {
            ProtocolData protocol = this.protocols.get(version);
            if (protocol == null && this.protocolPhase != GAME) {
                protocol = Iterables.getFirst(this.protocols.valueCollection(), null);
            }
            return protocol;
        }

        public boolean hasPacket(int i, boolean supportsForge) {
            return supportsForge || i >= 0 && i <= 255;
        }

        public final DefinedPacket createPacket(int id, int version) {
            return this.createPacket(id, version, true);
        }

        public final DefinedPacket createPacket(int id, int version, boolean supportsForge) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version " + version);
            }
            if (!this.hasPacket(id, supportsForge)) {
                throw new BadPacketException("Packet with id " + id + " outside of range");
            }
            Supplier<? extends DefinedPacket> constructor = protocolData.packetConstructors[id];
            return constructor == null ? null : constructor.get();
        }

        private void registerPacket(Class<? extends DefinedPacket> packetClass, Supplier<? extends DefinedPacket> constructor, ProtocolMapping ... mappings) {
            int mappingIndex = 0;
            ProtocolMapping mapping = mappings[mappingIndex];
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                if (protocol < mapping.protocolVersion) continue;
                if (mapping.protocolVersion < protocol && mappingIndex + 1 < mappings.length) {
                    ProtocolMapping nextMapping = mappings[mappingIndex + 1];
                    if (nextMapping.protocolVersion == protocol) {
                        Preconditions.checkState(nextMapping.packetID != mapping.packetID, "Duplicate packet mapping (%s, %s)", mapping.protocolVersion, nextMapping.protocolVersion);
                        mapping = nextMapping;
                        ++mappingIndex;
                    }
                }
                if (mapping.packetID < 0) break;
                ProtocolData data = this.protocols.get(protocol);
                data.packetMap.put(packetClass, mapping.packetID);
                data.packetConstructors[mapping.packetID] = constructor;
            }
        }

        public boolean hasPacket(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            return protocolData.packetMap.containsKey(packet);
        }

        public int getId(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            int packetId = protocolData.packetMap.get(packet);
            Preconditions.checkArgument(packetId >= 0, "Cannot get ID for packet %s in phase %s with direction %s for protocol version %s", packet, (Object)this.protocolPhase, (Object)this.direction, (Object)version);
            return packetId;
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }

    private static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        public ProtocolMapping(int protocolVersion, int packetID) {
            this.protocolVersion = protocolVersion;
            this.packetID = packetID;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        public int getPacketID() {
            return this.packetID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProtocolMapping)) {
                return false;
            }
            ProtocolMapping other = (ProtocolMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != other.getProtocolVersion()) {
                return false;
            }
            return this.getPacketID() == other.getPacketID();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProtocolMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocolVersion();
            result = result * 59 + this.getPacketID();
            return result;
        }

        public String toString() {
            return "Protocol.ProtocolMapping(protocolVersion=" + this.getProtocolVersion() + ", packetID=" + this.getPacketID() + ")";
        }
    }

    private static class ProtocolData {
        private final int protocolVersion;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap<Class<? extends DefinedPacket>>(255);
        private final Supplier<? extends DefinedPacket>[] packetConstructors = new Supplier[255];

        public ProtocolData(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        public TObjectIntMap<Class<? extends DefinedPacket>> getPacketMap() {
            return this.packetMap;
        }

        public Supplier<? extends DefinedPacket>[] getPacketConstructors() {
            return this.packetConstructors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProtocolData)) {
                return false;
            }
            ProtocolData other = (ProtocolData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != other.getProtocolVersion()) {
                return false;
            }
            TObjectIntMap<Class<? extends DefinedPacket>> this$packetMap = this.getPacketMap();
            TObjectIntMap<Class<? extends DefinedPacket>> other$packetMap = other.getPacketMap();
            if (this$packetMap == null ? other$packetMap != null : !((Object)this$packetMap).equals(other$packetMap)) {
                return false;
            }
            return Arrays.deepEquals(this.getPacketConstructors(), other.getPacketConstructors());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProtocolData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocolVersion();
            TObjectIntMap<Class<? extends DefinedPacket>> $packetMap = this.getPacketMap();
            result = result * 59 + ($packetMap == null ? 43 : ((Object)$packetMap).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPacketConstructors());
            return result;
        }

        public String toString() {
            return "Protocol.ProtocolData(protocolVersion=" + this.getProtocolVersion() + ", packetMap=" + this.getPacketMap() + ", packetConstructors=" + Arrays.deepToString(this.getPacketConstructors()) + ")";
        }
    }
}

