/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import es.xism4.software.ExploitExceptionHandler;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class LoginPayloadResponse
extends DefinedPacket {
    private int id;
    private byte[] data;

    @Override
    public void read(ByteBuf buf) {
        this.id = LoginPayloadResponse.readVarInt(buf);
        if (buf.readBoolean()) {
            int len = buf.readableBytes();
            if (len > 0x100000) {
                ExploitExceptionHandler.throwBigPayloadException(len);
            }
            this.data = new byte[len];
            buf.readBytes(this.data);
        }
    }

    @Override
    public void write(ByteBuf buf) {
        LoginPayloadResponse.writeVarInt(this.id, buf);
        if (this.data != null) {
            buf.writeBoolean(true);
            buf.writeBytes(this.data);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "LoginPayloadResponse(id=" + this.getId() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public LoginPayloadResponse() {
    }

    public LoginPayloadResponse(int id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPayloadResponse)) {
            return false;
        }
        LoginPayloadResponse other = (LoginPayloadResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginPayloadResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

