/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.api.LanguageManager;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyPrefixMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;

@Singleton
public class LanguageManagerImpl
extends ManagerComponent
implements LanguageManager {
    private Map<LanguageType, MessagesSettings> languages = new EnumMap<LanguageType, MessagesSettings>(LanguageType.class);
    private LanguageType defaultLanguage = LanguageType.EN_US;
    private MessagesSettings absoluteDefaultMessagesSettings;

    @Inject
    public LanguageManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "LanguageManager");
        SerializerConfig serializerConfig = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new ReadyPrefixMessageSerializer()).build();
        this.absoluteDefaultMessagesSettings = new MessagesSettings(serializerConfig, this.defaultLanguage);
        this.absoluteDefaultMessagesSettings.MESSAGES.BUNGEECORD.loadMessages();
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        File translatesDirectory = new File("NullCordX", "translates" + File.separator);
        if (!translatesDirectory.exists()) {
            translatesDirectory.mkdirs();
        }
        String language = ConfigSettings.IMP.LANGUAGE.DEFAULT_TRANSLATION;
        try {
            this.defaultLanguage = LanguageType.valueOf(language.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            this.logger.warning("Unknown language '" + language + "'!");
            this.defaultLanguage = LanguageType.EN_US;
        }
        this.logger.info("Using default language '" + this.defaultLanguage + "'");
        EnumMap<LanguageType, MessagesSettings> languages = new EnumMap<LanguageType, MessagesSettings>(LanguageType.class);
        for (LanguageType type : LanguageType.values()) {
            String fileMame = "messages_" + type.getName() + ".yml";
            try {
                File messageFile = new File(translatesDirectory, fileMame);
                try (InputStream supportedFileInputStream = this.getClass().getClassLoader().getResourceAsStream("translates/" + fileMame);){
                    if (!messageFile.exists()) {
                        if (supportedFileInputStream != null) {
                            Files.copy(supportedFileInputStream, messageFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        } else if (type != this.defaultLanguage) continue;
                    }
                    Path messagePath = messageFile.toPath();
                    ReadyComponentMessageSerializer readyComponentMessageSerializer = new ReadyComponentMessageSerializer();
                    ReadyPrefixMessageSerializer readyPrefixMessageSerializer = new ReadyPrefixMessageSerializer();
                    SerializerConfig serializerConfig = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(readyComponentMessageSerializer).registerSerializer(readyPrefixMessageSerializer).build();
                    MessagesSettings messagesSettings = new MessagesSettings(serializerConfig, type);
                    readyComponentMessageSerializer.setPrefixSerializable(messagesSettings);
                    readyPrefixMessageSerializer.setPrefixSerializable(messagesSettings);
                    languages.put(type, messagesSettings);
                    if (supportedFileInputStream != null) {
                        messagesSettings.load(new BufferedReader(new InputStreamReader(supportedFileInputStream, StandardCharsets.UTF_8)));
                    }
                    messagesSettings.reload(messagePath);
                    if (type == LanguageType.EN_US) {
                        this.absoluteDefaultMessagesSettings = messagesSettings;
                    }
                    this.logger.log(Level.INFO, "Successfully loaded " + fileMame + " file!");
                }
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to load " + fileMame + " file: ", e);
            }
        }
        this.languages = Collections.unmodifiableMap(languages);
    }

    @Override
    protected void onUnload() {
    }

    @Override
    public MessagesSettings getMessagesSettings(LanguageType type) {
        return this.languages.get((Object)type);
    }

    @Override
    public MessagesSettings getMessagesSettingsByLanguage() {
        return this.getMessagesSettingsByLanguage(this.defaultLanguage);
    }

    @Override
    public MessagesSettings getMessagesSettingsByLanguage(LanguageType type) {
        MessagesSettings messages = this.calculateMessageDataByType(this.languages, type);
        if (messages != null) {
            return messages;
        }
        return this.absoluteDefaultMessagesSettings;
    }

    @Override
    public Collection<MessagesSettings> getAllMessagesSettings() {
        HashSet<MessagesSettings> messagesSettingsSet = new HashSet<MessagesSettings>();
        if (this.languages == null || this.languages.isEmpty()) {
            messagesSettingsSet.add(this.absoluteDefaultMessagesSettings);
        }
        if (this.languages != null) {
            messagesSettingsSet.addAll(this.languages.values());
        }
        return messagesSettingsSet;
    }

    public <T> T calculateMessageDataByType(Map<LanguageType, T> map, LanguageType type) {
        T messages;
        if (!ConfigSettings.IMP.LANGUAGE.DEPEND_ON_CLIENT_SETTINGS) {
            type = this.defaultLanguage;
        }
        if ((messages = map.get((Object)type)) != null) {
            return messages;
        }
        return map.get((Object)this.defaultLanguage);
    }

    @Override
    public LanguageType getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public MessagesSettings getAbsoluteDefaultMessagesSettings() {
        return this.absoluteDefaultMessagesSettings;
    }
}

