/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.virtual.VirtualConnector;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.UserManager;
import net.shieldcommunity.nullcordx.api.database.CachedUserData;
import net.shieldcommunity.nullcordx.api.database.WhitelistedUserData;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.SQLSettings;
import net.shieldcommunity.nullcordx.database.DatabaseRepository;
import net.shieldcommunity.nullcordx.database.VerifiedUser;
import net.shieldcommunity.nullcordx.database.WhitelistedUser;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Cache;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class UserManagerImpl
extends ManagerComponent
implements UserManager {
    private final LocalScheduler localScheduler;
    private final DatabaseRepository databaseRepository;
    private final ConcurrentMap<String, VirtualConnector> usersOnCheck = new ConcurrentHashMap<String, VirtualConnector>();
    private final Cache<String, CachedUserData> cachedUsers = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).build();
    private final Cache<String, WhitelistedUserData> whitelist = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).build();
    private long lastSync = System.currentTimeMillis();

    @Inject
    public UserManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler, DatabaseRepository databaseRepository) {
        super(logger, nullCordX, "UserManager");
        this.localScheduler = localScheduler;
        this.databaseRepository = databaseRepository;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        try {
            for (VerifiedUser verifiedUser : this.databaseRepository.getAllUsers().get()) {
                this.cachedUsers.put(verifiedUser.getName(), new CachedUserData(verifiedUser.getName(), verifiedUser.getIp(), verifiedUser.getLastCheck(), verifiedUser.getLastJoin(), !AntibotSettings.IMP.ANTIBOT.ALWAYS_CHECK));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load cached users", e);
        }
        try {
            for (WhitelistedUser whiteList : this.databaseRepository.getAllWhiteList().get()) {
                this.whitelist.put(whiteList.getName(), new WhitelistedUserData(whiteList.getName(), whiteList.getTimeAdded()));
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load whitelisted users", e);
        }
        this.scheduleCleanup();
    }

    @Override
    protected void onUnload() {
        for (VirtualConnector connector : this.usersOnCheck.values()) {
            connector.kick(KickType.RELOADING, "Reloading...");
        }
        this.usersOnCheck.clear();
    }

    @Override
    public boolean isUserOnChecking(String name) {
        return this.usersOnCheck.containsKey(name.toLowerCase());
    }

    @Override
    public VirtualConnector getCheckingUserByName(String name) {
        return (VirtualConnector)this.usersOnCheck.get(name.toLowerCase());
    }

    public Collection<VirtualConnector> getAllCheckingUsers() {
        return this.usersOnCheck.values();
    }

    public CachedUserData getCachedUser(String userName) {
        return this.cachedUsers.getIfPresent(userName.toLowerCase());
    }

    public Collection<CachedUserData> getAllCachedUsers() {
        return this.cachedUsers.asMap().values();
    }

    public CachedUserData saveCachedUser(String userName, InetAddress address, boolean afterCheck) {
        userName = userName.toLowerCase();
        long timestamp = System.currentTimeMillis();
        CachedUserData cachedUserData = this.cachedUsers.getIfPresent(userName);
        if (cachedUserData != null) {
            cachedUserData.setIp(address.getHostAddress());
            cachedUserData.setLastJoin(timestamp);
            if (afterCheck) {
                cachedUserData.setLastCheck(timestamp);
            }
        } else {
            cachedUserData = new CachedUserData(userName, address.getHostAddress(), timestamp, timestamp, true);
        }
        this.cachedUsers.put(userName, cachedUserData);
        this.databaseRepository.saveUser(cachedUserData);
        return cachedUserData;
    }

    public void deleteCachedUser(String userName) {
        userName = userName.toLowerCase();
        this.cachedUsers.invalidate(userName);
        this.databaseRepository.deleteUser(userName);
    }

    public void deleteAllCachedUsers() {
        this.cachedUsers.invalidateAll();
        this.databaseRepository.deleteAllUsers();
    }

    public boolean addConnection(VirtualConnector connector) {
        return this.usersOnCheck.putIfAbsent(connector.getName().toLowerCase(), connector) != null;
    }

    public void removeConnection(VirtualConnector connector) {
        this.usersOnCheck.remove(connector.getName().toLowerCase());
    }

    public void removeConnection(String name) {
        this.usersOnCheck.remove(name.toLowerCase());
    }

    public void addPlayerToWhitelist(String name) {
        name = name.toLowerCase();
        long timeAdded = System.currentTimeMillis();
        this.whitelist.put(name, new WhitelistedUserData(name, timeAdded));
        this.databaseRepository.saveWhitelist(name, timeAdded);
    }

    public void removePlayerFromWhitelist(String name) {
        name = name.toLowerCase();
        this.whitelist.invalidate(name);
        this.databaseRepository.removeWhitelist(name);
    }

    public Collection<WhitelistedUserData> getAllWhitelistedPlayers() {
        return this.whitelist.asMap().values();
    }

    public WhitelistedUserData getWhitelistedUser(String name) {
        return this.whitelist.getIfPresent(name.toLowerCase());
    }

    private void scheduleCleanup() {
        int usersSyncTime;
        int usersPurgeTime = SQLSettings.IMP.SQL.USERS_PURGE.PURGE_CHECK_TIME;
        if (usersPurgeTime > 0) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    int cleared = UserManagerImpl.this.clearOldCachedUser(SQLSettings.IMP.SQL.USERS_PURGE.PURGE_TIME, !SQLSettings.IMP.SQL.USERS_PURGE.PURGE_ONLY_MEMORY);
                    UserManagerImpl.this.logger.log(Level.INFO, "Cleared " + cleared + " cached players.");
                }
            }, usersPurgeTime, usersPurgeTime, TimeUnit.MINUTES);
        }
        if ((usersSyncTime = SQLSettings.IMP.SQL.USERS_SYNC_CHECK_TIME) > 0) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    int sync = UserManagerImpl.this.syncUsers();
                    UserManagerImpl.this.logger.log(Level.INFO, "Synchronized " + sync + " cached players.");
                }
            }, usersSyncTime, usersSyncTime, TimeUnit.MINUTES);
        }
    }

    private int clearOldCachedUser(int purgeTime, boolean database) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -purgeTime);
        long until = calendar.getTimeInMillis();
        HashSet<String> toRemove = new HashSet<String>();
        for (CachedUserData cachedUserData : this.cachedUsers.asMap().values()) {
            if (cachedUserData.getLastJoin() >= until) continue;
            toRemove.add(cachedUserData.getName());
        }
        for (String name : toRemove) {
            this.cachedUsers.invalidate(name);
        }
        if (database) {
            this.databaseRepository.clearOldUsers(until);
        }
        return toRemove.size();
    }

    private int syncUsers() {
        try {
            long current = System.currentTimeMillis();
            List<VerifiedUser> verifiedUsers = this.databaseRepository.getAllUsersByLastJoin(this.lastSync).get();
            for (VerifiedUser verifiedUser : verifiedUsers) {
                CachedUserData data = this.cachedUsers.getIfPresent(verifiedUser.getName());
                CachedUserData newData = data != null ? new CachedUserData(verifiedUser.getName(), verifiedUser.getIp(), verifiedUser.getLastCheck(), verifiedUser.getLastJoin(), data.isAllowJoin()) : new CachedUserData(verifiedUser.getName(), verifiedUser.getIp(), verifiedUser.getLastCheck(), verifiedUser.getLastJoin(), !AntibotSettings.IMP.ANTIBOT.ALWAYS_CHECK);
                this.cachedUsers.put(verifiedUser.getName(), newData);
            }
            this.lastSync = current;
            return verifiedUsers.size();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to sync users", e);
            return 0;
        }
    }
}

