/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot;

import java.net.InetAddress;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.connection.InitialHandler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Cache;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;

@Singleton
public class AntiBotDirectConnection
extends ManagerComponent {
    private Cache<InetAddress, InetAddress> cache = null;

    @Inject
    public AntiBotDirectConnection(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "AntiBotDirectConnection");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (AntibotSettings.IMP.ANTIBOT.DIRECT_CONNECTION_CHECK.MODE == -1) {
            this.logger.log(Level.INFO, this.componentName + " disabled by configuration!");
            return;
        }
        this.cache = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).expireAfterWrite(AntibotSettings.IMP.ANTIBOT.DIRECT_CONNECTION_CHECK.CACHE_TIME, TimeUnit.SECONDS).build();
    }

    @Override
    protected void onUnload() {
        this.clear();
        this.cache = null;
    }

    public boolean isEnabled() {
        if (this.cache == null) {
            return false;
        }
        if (AntibotSettings.IMP.ANTIBOT.DIRECT_CONNECTION_CHECK.MODE == 1) {
            return true;
        }
        return AntibotSettings.IMP.ANTIBOT.DIRECT_CONNECTION_CHECK.MODE == 0 && this.nullCordX.isUnderBotAttack();
    }

    public boolean isDirectConnected(InitialHandler handler) {
        boolean present;
        if (this.cache == null) {
            return false;
        }
        if (handler.isGeyser()) {
            return false;
        }
        InetAddress address = handler.getAddress().getAddress();
        boolean bl = present = this.cache.getIfPresent(address) == null;
        if (!present) {
            this.cache.invalidate(address);
        }
        return present;
    }

    public void add(InetAddress address) {
        if (this.cache == null) {
            return;
        }
        this.cache.put(address, address);
    }

    public void clear() {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidateAll();
    }
}

