/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.ChannelHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.protocol.Protocol;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.UserManagerImpl;
import net.shieldcommunity.nullcordx.antibot.AntiBotDirectConnection;
import net.shieldcommunity.nullcordx.antibot.antiproxy.AntiProxyManagerImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.CachedProxyCheckerImpl;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AntiBotAttributesLimiter;
import net.shieldcommunity.nullcordx.antibot.checklimiter.AddressLimitResult;
import net.shieldcommunity.nullcordx.antibot.checklimiter.AntiBotCheckLimiter;
import net.shieldcommunity.nullcordx.antibot.maxmind.AntiASNManagerImpl;
import net.shieldcommunity.nullcordx.antibot.maxmind.AntiCountryManagerImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.VirtualConnector;
import net.shieldcommunity.nullcordx.antibot.virtual.ping.AveragePingCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.ping.MaximumPingCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.ping.NonePingCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.ping.PingCheckFactory;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.antibot.AntiBotManager;
import net.shieldcommunity.nullcordx.api.antibot.CustomNeedCheckHandler;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.CachedDataChecker;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.MaxMindResult;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.asnlimiter.ASNResultData;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.countrylimiter.CountryResultData;
import net.shieldcommunity.nullcordx.api.checking.AbstractChecking;
import net.shieldcommunity.nullcordx.api.checking.AntiBotCheckResult;
import net.shieldcommunity.nullcordx.api.checking.AntiBotCheckResultType;
import net.shieldcommunity.nullcordx.api.database.CachedUserData;
import net.shieldcommunity.nullcordx.blacklist.BlacklistManager;
import net.shieldcommunity.nullcordx.cache.CachedPacketManagerImpl;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class AntiBotManagerImpl
extends ManagerComponent
implements AntiBotManager {
    private final LanguageManagerImpl languageManager;
    private final LocalScheduler localScheduler;
    private final StatisticsManagerImpl statisticsManager;
    private final UserManagerImpl userManager;
    private final CachedPacketManagerImpl cachedPacketManager;
    private final AntiBotCheckLimiter antiBotCheckLimiter;
    private final BlacklistManager blacklistManager;
    private final AntiBotAttributesLimiter antiBotAttributesLimiter;
    private final AntiBotDirectConnection antiBotDirectConnection;
    private final AntiCountryManagerImpl antiCountryManager;
    private final AntiASNManagerImpl antiASNManager;
    private final AntiProxyManagerImpl antiProxyManager;
    private PingCheckFactory pingCheckFactory = () -> NonePingCheck.INSTANCE;
    private ExecutorService executor = null;
    private CustomNeedCheckHandler customNeedCheckHandler;

    @Inject
    public AntiBotManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LanguageManagerImpl languageManager, LocalScheduler localScheduler, StatisticsManagerImpl statisticsManager, UserManagerImpl userManager, CachedPacketManagerImpl cachedPacketManager, AntiBotCheckLimiter antiBotCheckLimiter, BlacklistManager blacklistManager, AntiBotAttributesLimiter antiBotAttributesLimiter, AntiBotDirectConnection antiBotDirectConnection, AntiCountryManagerImpl antiCountryManager, AntiASNManagerImpl antiASNManager, AntiProxyManagerImpl antiProxyManager) {
        super(logger, nullCordX, "AntiBotManager");
        this.languageManager = languageManager;
        this.localScheduler = localScheduler;
        this.statisticsManager = statisticsManager;
        this.userManager = userManager;
        this.cachedPacketManager = cachedPacketManager;
        this.antiBotCheckLimiter = antiBotCheckLimiter;
        this.blacklistManager = blacklistManager;
        this.antiBotAttributesLimiter = antiBotAttributesLimiter;
        this.antiBotDirectConnection = antiBotDirectConnection;
        this.antiCountryManager = antiCountryManager;
        this.antiASNManager = antiASNManager;
        this.antiProxyManager = antiProxyManager;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        int type;
        if (AntibotSettings.IMP.ANTIBOT.DIMENSION.ITEM_FRAME.PLAYER_DIRECTION_THRESHOLD != -1.0) {
            this.executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-AntiBot-Utils-%d").setPriority(1).build());
        }
        this.pingCheckFactory = (type = AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.TYPE) == 1 ? () -> new AveragePingCheck(false) : (type == 2 ? () -> new AveragePingCheck(true) : (type == 3 ? MaximumPingCheck::new : () -> NonePingCheck.INSTANCE));
        this.scheduleFilterCleanup();
    }

    @Override
    protected void onUnload() {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during executor shutdown", e);
            }
        }
    }

    @Override
    public AntiBotCheckResult isNeedCheck(PendingConnection connection) {
        boolean enabledCheck;
        AntiBotCheckResult result;
        if (this.customNeedCheckHandler != null && (result = this.customNeedCheckHandler.isNeedCheck(connection)) != null) {
            return result;
        }
        boolean bl = enabledCheck = connection.isGeyser() ? AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.ENABLED : AntibotSettings.IMP.ANTIBOT.MODES.JAVA.ENABLED;
        if (!enabledCheck) {
            return AntiBotCheckResultType.DISABLED;
        }
        String userName = connection.getName();
        if (this.userManager.getWhitelistedUser(userName) != null) {
            return AntiBotCheckResultType.WHITELISTED;
        }
        InetAddress inetAddress = connection.getAddress().getAddress();
        if (this.antiBotCheckLimiter.isIgnoredIp(inetAddress)) {
            return AntiBotCheckResultType.IGNORED_IP;
        }
        if (AntibotSettings.IMP.ANTIBOT.CONNECT_TO_FILTER_ONLY_ON_ATTACK.ENABLED && !this.nullCordX.isUnderBotAttack()) {
            return AntiBotCheckResultType.ALLOWED_DUE_TO_MODE;
        }
        CachedUserData userFilter = this.userManager.getCachedUser(userName.toLowerCase());
        if (userFilter == null) {
            return AntiBotCheckResultType.FIRST_JOIN;
        }
        if (AntibotSettings.IMP.ANTIBOT.ALWAYS_CHECK || AntibotSettings.IMP.ANTIBOT.ALWAYS_CHECK_ON_ATTACK && this.nullCordX.isUnderBotAttack()) {
            if (connection.isOnlineMode() || AntibotSettings.IMP.ANTIBOT.REJOIN_AFTER_CHECK == 1 || AntibotSettings.IMP.ANTIBOT.REJOIN_AFTER_CHECK == 0 && this.nullCordX.isUnderBotAttack()) {
                if (!userFilter.isAllowJoin()) {
                    return AntiBotCheckResultType.ALWAYS_DENY;
                }
                userFilter.setAllowJoin(false);
                return AntiBotCheckResultType.ALWAYS_ALLOW;
            }
            return AntiBotCheckResultType.ALWAYS_DENY;
        }
        String address = inetAddress.getHostAddress();
        if (AntibotSettings.IMP.ANTIBOT.CHECK_PLAYER_ON_IP_CHANGE && !userFilter.getIp().equalsIgnoreCase(address)) {
            return AntiBotCheckResultType.CHANGED_IP;
        }
        return AntiBotCheckResultType.NONE;
    }

    public void startConfiguredAntiBot(String name, InitialHandler initialHandler, AntiBotCheckResult antiBotCheckResultType) {
        if (AntibotSettings.IMP.ANTIBOT.REJOIN_AFTER_CHECK == 1) {
            initialHandler.connectToAntiBotFilter(name, antiBotCheckResultType, true);
            return;
        }
        if (AntibotSettings.IMP.ANTIBOT.REJOIN_AFTER_CHECK == -1) {
            initialHandler.startLoginProcessForAntiBot(name, antiBotCheckResultType);
            return;
        }
        if (AntibotSettings.IMP.ANTIBOT.REJOIN_AFTER_CHECK == 0 && this.nullCordX.isUnderBotAttack()) {
            initialHandler.connectToAntiBotFilter(name, antiBotCheckResultType, true);
            return;
        }
        initialHandler.startLoginProcessForAntiBot(name, antiBotCheckResultType);
    }

    public void handleLoginRequest(InitialHandler initialHandler) throws Exception {
        CachedProxyCheckerImpl cachedProxyChecker;
        CachedDataChecker cachedASNChecker;
        MaxMindResult result;
        CachedDataChecker cachedCountryChecker;
        InetAddress address = initialHandler.getAddress().getAddress();
        if (this.antiBotCheckLimiter.isEnabled()) {
            AddressLimitResult addressLimitResult = this.antiBotCheckLimiter.getManyCheckResult(address);
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("Returned many check result for address " + address.getHostAddress() + ": " + addressLimitResult.name());
            }
            if (addressLimitResult != AddressLimitResult.ALLOW) {
                KickType kickType = KickType.MANY_CHECKS_SAME;
                if (addressLimitResult == AddressLimitResult.MANY_DIFFERENT_NICKNAMES) {
                    kickType = KickType.MANY_CHECKS_DIFFERENT;
                }
                this.kickPlayerWithReason(address, initialHandler, kickType, "Rate-limited bot check: " + addressLimitResult.name(), AntibotSettings.IMP.ANTIBOT.MANY_CHECKS.BLACKLIST_ADDRESS);
                return;
            }
        }
        if (this.antiBotDirectConnection.isEnabled() && this.antiBotDirectConnection.isDirectConnected(initialHandler)) {
            this.kickPlayerWithReason(address, initialHandler, KickType.DIRECT_CONNECTION, "Direct-connection spoof", AntibotSettings.IMP.ANTIBOT.DIRECT_CONNECTION_CHECK.BLACKLIST_ADDRESS_IF_DETECTED);
            return;
        }
        if (this.antiCountryManager.canUseFastCacheCheck(initialHandler.isGeyser()) && (cachedCountryChecker = this.antiCountryManager.getCheckerByAddress(address)) != null) {
            String countryISO;
            CountryResultData countryResultData = (CountryResultData)cachedCountryChecker.getCachedResult();
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("Country cached result for address '" + address.getHostAddress() + "': " + countryResultData);
            }
            if ((result = countryResultData.getResult()) == MaxMindResult.SUCCESSFULLY && (countryISO = countryResultData.getCountryISO()) != null && this.antiCountryManager.isBlacklistedCountryISO(countryISO)) {
                this.kickPlayerWithReason(address, initialHandler, KickType.COUNTRY, "Blacklisted country", AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.BLACKLIST_ADDRESS_IF_DETECTED);
                return;
            }
        }
        if (this.antiASNManager.canUseFastCacheCheck(initialHandler.isGeyser()) && (cachedASNChecker = this.antiASNManager.getCheckerByAddress(address)) != null) {
            Long asn;
            ASNResultData ASNResultData2 = (ASNResultData)cachedASNChecker.getCachedResult();
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("ASN cached result for address '" + address.getHostAddress() + "': " + ASNResultData2);
            }
            if ((result = ASNResultData2.getResult()) == MaxMindResult.SUCCESSFULLY && (asn = ASNResultData2.getAsn()) != null && this.antiASNManager.isBlacklistedASN(asn)) {
                this.kickPlayerWithReason(address, initialHandler, KickType.ASN, "Blacklisted asn", AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.BLACKLIST_ADDRESS_IF_DETECTED);
                return;
            }
        }
        if (this.antiProxyManager.canUseFastCacheCheck(initialHandler.isGeyser()) && (cachedProxyChecker = this.antiProxyManager.getCheckerByAddress(address)) != null) {
            ProxyResult result2 = cachedProxyChecker.getCachedResult();
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("Proxy cached result for address '" + address.getHostAddress() + "': " + result2);
            }
            if (result2 == ProxyResult.DETECTED) {
                this.kickPlayerWithReason(address, initialHandler, KickType.PROXY, "Proxy detected", AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.BLACKLIST_ADDRESS_IF_DETECTED);
                return;
            }
        }
        if (this.userManager.isUserOnChecking(initialHandler.getName())) {
            this.kickPlayerWithReason(address, initialHandler, KickType.ALREADY_CONNECTED, "Already connected", false);
            return;
        }
        if (this.nullCordX.canChangeTimeoutForInitConnection()) {
            initialHandler.getCh().getHandle().pipeline().replace("timeout", "timeout", (ChannelHandler)new ReadTimeoutHandler(BungeeCord.getInstance().config.getTimeout(), TimeUnit.MILLISECONDS));
        }
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("Player " + initialHandler.getName() + ". Original address: '" + initialHandler.getTrueAddress().getAddress().getHostAddress() + "'. Current address: '" + initialHandler.getAddress().getAddress().getHostAddress() + "'. Protocol: " + initialHandler.getVersion() + ". Is geyser? " + initialHandler.isGeyser());
        }
        initialHandler.delayedHandleLoginRequest(this.nullCordX, this);
    }

    private void kickPlayerWithReason(InetAddress address, InitialHandler initialHandler, KickType kickType, String reason, boolean blacklist) {
        this.cachedPacketManager.getCachedMessagesByLanguage(this.languageManager.getDefaultLanguage()).sendKickPacket(kickType, initialHandler.getCh(), Protocol.LOGIN, initialHandler.getVersion());
        if (blacklist) {
            this.blacklistManager.blackList(address, reason);
        } else if (this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog("Closed address > " + address.getHostAddress() + " by " + reason);
        }
        this.statisticsManager.addBlockedConnectionPerSecond();
    }

    public boolean checkBigPing(long ping) {
        return this.checkPing(ping, AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.MAX_PING);
    }

    public boolean checkBigPingAdvanced(long ping) {
        return this.checkPing(ping, AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.ADVANCED.MAX_DIFFERENCE);
    }

    private boolean checkPing(long ping, long maxValue) {
        if (AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.MODE == -1) {
            return false;
        }
        if (AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.MODE == 1 || AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.MODE == 0 && this.nullCordX.isUnderBotAttack()) {
            return ping >= maxValue;
        }
        return false;
    }

    public void submitUtilsTask(Runnable task) {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(task);
    }

    private void scheduleFilterCleanup() {
        int interval = AntibotSettings.IMP.ANTIBOT.SCHEDULE_TASK_INTERVAL;
        if (interval <= 0) {
            interval = 1;
        }
        this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                AntiBotManagerImpl.this.checkTimeoutTask();
                AntiBotManagerImpl.this.checkSameAddressTask();
            }
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTimeoutTask() {
        HashSet<String> toRemoveSet = new HashSet<String>();
        try {
            long currTime = System.currentTimeMillis();
            for (VirtualConnector user : this.userManager.getAllCheckingUsers()) {
                String name = user.getName();
                if (!user.isConnected() || user.isCompleted()) {
                    toRemoveSet.add(name);
                    continue;
                }
                AbstractChecking checking = user.getCurrentChecking();
                if (currTime > user.getTimeoutTime()) {
                    user.kick(KickType.TIMED_OUT, "Timeout" + (String)(checking != null ? " while " + checking.getName() + " check" : ""));
                    toRemoveSet.add(name);
                    continue;
                }
                user.onScheduledTask();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to handle timeout", e);
        }
        finally {
            for (String remove : toRemoveSet) {
                this.userManager.removeConnection(remove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSameAddressTask() {
        HashSet<String> toRemoveSet = new HashSet<String>();
        try {
            for (Map.Entry<InetAddress, List<VirtualConnector>> entry : this.findSameConnectedAddresses().entrySet()) {
                List<VirtualConnector> users = entry.getValue();
                if (users.size() <= AntibotSettings.IMP.ANTIBOT.MAX_SAME_ADDRESS_LIMIT) continue;
                for (VirtualConnector user : users) {
                    user.kick(KickType.FAILED_CHECK, "Exceeded ip address limit");
                    toRemoveSet.add(user.getName());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to calculate same addresses", e);
        }
        finally {
            for (String remove : toRemoveSet) {
                this.userManager.removeConnection(remove);
            }
        }
    }

    public Map<InetAddress, List<VirtualConnector>> findSameConnectedAddresses() {
        HashMap<InetAddress, List<VirtualConnector>> tmp = new HashMap<InetAddress, List<VirtualConnector>>();
        for (VirtualConnector user : this.userManager.getAllCheckingUsers()) {
            List list = tmp.computeIfAbsent(user.getAddress().getAddress(), v -> new ArrayList());
            list.add(user);
        }
        return tmp;
    }

    public LanguageManagerImpl getLanguageManager() {
        return this.languageManager;
    }

    public LocalScheduler getLocalScheduler() {
        return this.localScheduler;
    }

    public StatisticsManagerImpl getStatisticsManager() {
        return this.statisticsManager;
    }

    public UserManagerImpl getUserManager() {
        return this.userManager;
    }

    public CachedPacketManagerImpl getCachedPacketManager() {
        return this.cachedPacketManager;
    }

    public AntiBotCheckLimiter getAntiBotCheckLimiter() {
        return this.antiBotCheckLimiter;
    }

    public BlacklistManager getBlacklistManager() {
        return this.blacklistManager;
    }

    public AntiBotAttributesLimiter getAntiBotAttributesLimiter() {
        return this.antiBotAttributesLimiter;
    }

    public AntiBotDirectConnection getAntiBotDirectConnection() {
        return this.antiBotDirectConnection;
    }

    public AntiCountryManagerImpl getAntiCountryManager() {
        return this.antiCountryManager;
    }

    public AntiASNManagerImpl getAntiASNManager() {
        return this.antiASNManager;
    }

    public AntiProxyManagerImpl getAntiProxyManager() {
        return this.antiProxyManager;
    }

    public PingCheckFactory getPingCheckFactory() {
        return this.pingCheckFactory;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public CustomNeedCheckHandler getCustomNeedCheckHandler() {
        return this.customNeedCheckHandler;
    }

    @Override
    public void setCustomNeedCheckHandler(CustomNeedCheckHandler customNeedCheckHandler) {
        this.customNeedCheckHandler = customNeedCheckHandler;
    }
}

