/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.antiproxy.services;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.AbstractAntiProxyService;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.ProxyServiceCheckFailedException;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.client.methods.HttpGet;

public class CustomProxyService
extends AbstractAntiProxyService {
    private final String apiUrl;
    private final Map<String, String> requestProperties;
    private final Pattern detectedPattern;

    public CustomProxyService(NullCordXImpl nullCordX, int timeout, String apiUrl, Map<String, String> requestProperties, Pattern detectedPattern) {
        super("Custom", nullCordX, timeout);
        this.apiUrl = apiUrl;
        this.requestProperties = requestProperties;
        this.detectedPattern = detectedPattern;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProxyResult checkProxy(InetAddress address) throws ProxyServiceCheckFailedException {
        String replacedApi = this.apiUrl.replace("%ip%", address.getHostAddress());
        try {
            URI uri = URI.create(replacedApi);
            HttpGet httpGet = new HttpGet(uri);
            for (Map.Entry<String, String> property : this.requestProperties.entrySet()) {
                httpGet.setHeader(property.getKey(), property.getValue().replace("%ip%", address.getHostAddress()));
            }
            try (HttpUtils.HttpByteArrayInputStream inputStream = HttpUtils.makeRequest(httpGet, this.timeout);){
                BufferedReader reader;
                block17: {
                    ProxyResult proxyResult;
                    int code = inputStream.getCode();
                    if (code != 200) {
                        throw new ProxyServiceCheckFailedException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
                    }
                    reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                    try {
                        String response = reader.lines().collect(Collectors.joining("\n"));
                        if (!this.detectedPattern.matcher(response).find()) break block17;
                        proxyResult = ProxyResult.DETECTED;
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    reader.close();
                    return proxyResult;
                }
                ProxyResult proxyResult = ProxyResult.ALLOWED;
                reader.close();
                return proxyResult;
            }
        }
        catch (Exception e) {
            throw new ProxyServiceCheckFailedException(e);
        }
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onUnload() {
    }
}

