/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.attributeslimiter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AttributeLookupResponse;
import net.shieldcommunity.nullcordx.antibot.attributeslimiter.AttributeResponse;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;

@Singleton
public class AntiBotAttributesLimiter
extends ManagerComponent {
    private final CheckingFactoriesImpl checkingFactories;
    private final List<Pattern> nicknamePatterns = new ArrayList<Pattern>();
    private final List<Pattern> brandPatterns = new ArrayList<Pattern>();
    private ExecutorService executor = null;

    @Inject
    public AntiBotAttributesLimiter(NullCordXLogger logger, NullCordXImpl nullCordX, CheckingFactoriesImpl checkingFactories) {
        super(logger, nullCordX, "AntiBotAttributesLimiter");
        this.checkingFactories = checkingFactories;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!this.checkingFactories.isAttributesCheckUsed()) {
            this.logger.log(Level.INFO, this.componentName + " disabled: Not used anywhere in the antibot settings!");
            return;
        }
        for (String patternString : AntibotSettings.IMP.ANTIBOT.ATTRIBUTES_LIMITER_CHECK.NICKNAME_PATTERNS) {
            try {
                this.nicknamePatterns.add(Pattern.compile(patternString));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to parse pattern '" + patternString + "'", e);
            }
        }
        for (String patternString : AntibotSettings.IMP.ANTIBOT.ATTRIBUTES_LIMITER_CHECK.BRAND_PATTERNS) {
            try {
                this.brandPatterns.add(Pattern.compile(patternString));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to parse pattern '" + patternString + "'", e);
            }
        }
        int threads = AntibotSettings.IMP.ANTIBOT.ATTRIBUTES_LIMITER_CHECK.THREAD_POOL_SIZE;
        if (threads == -1) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        this.executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setNameFormat("NullCordX-Attributes-Check-%d").build());
    }

    @Override
    protected void onUnload() {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during executor shutdown", e);
            }
        }
    }

    public void submitLookup(String nickname, String brand, AttributeLookupResponse response) {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(() -> {
            if (!response.canExecute()) {
                return;
            }
            boolean nicknameDetected = this.matchNickname(nickname);
            boolean brandDetected = this.matchBrand(brand);
            response.onExecute(new AttributeResponse(nicknameDetected, brandDetected));
        });
    }

    public boolean matchNickname(String name) {
        if (name == null) {
            return false;
        }
        return AntiBotAttributesLimiter.matchString(this.nicknamePatterns, name);
    }

    public boolean matchBrand(String name) {
        if (name == null) {
            return false;
        }
        return AntiBotAttributesLimiter.matchString(this.brandPatterns, name);
    }

    private static boolean matchString(List<Pattern> patterns, String name) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).find()) continue;
            return true;
        }
        return false;
    }
}

