/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.imagesource;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.shieldcommunity.nullcordx.antibot.captcha.imagesource.ImageDataSource;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.client.methods.HttpGet;

public class ApiNinjasImageSource
implements ImageDataSource {
    private static final String API_URL = "https://api.api-ninjas.com/v1/randomimage";
    private static final Set<String> SUPPORTED_GROUPS = new HashSet<String>(Arrays.asList("nature", "city", "technology", "food", "still_life", "abstract", "wildlife"));
    private final String license;
    private final int timeout;
    private final long maxCacheTime;
    private final Set<String> groups;
    private final int imagesCount;

    public ApiNinjasImageSource(String license, int timeout, long maxCacheTime, Collection<String> groups, int imagesCount) {
        this.license = license;
        this.timeout = timeout;
        this.maxCacheTime = maxCacheTime;
        HashSet<String> newGroups = new HashSet<String>();
        for (String group : groups) {
            if (!SUPPORTED_GROUPS.contains(group)) continue;
            newGroups.add(group);
        }
        if (newGroups.isEmpty()) {
            newGroups.add("nature");
            newGroups.add("city");
        }
        this.groups = newGroups;
        this.imagesCount = imagesCount;
    }

    @Override
    public String getName() {
        return "ApiNinjas";
    }

    @Override
    public void downloadAndSaveImage(File groupFile, String groupName, String imageName, int width, int height) throws Exception {
        File imageFile = new File(groupFile, this.getName() + "-" + imageName + ".jpeg");
        if (imageFile.exists()) {
            long lastModified = imageFile.lastModified();
            if (System.currentTimeMillis() - lastModified <= this.maxCacheTime) {
                return;
            }
        }
        URI uri = URI.create("https://api.api-ninjas.com/v1/randomimage?category=" + groupName + "&width=" + width + "&height=" + height);
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeader("Accept-Encoding", "UTF-8");
        httpGet.setHeader("Accept", "image/jpg");
        httpGet.setHeader("X-Api-Key", this.license);
        try (HttpUtils.HttpByteArrayInputStream inputStream = HttpUtils.makeRequest(httpGet, this.timeout);){
            int code = inputStream.getCode();
            if (inputStream.getCode() != 200) {
                throw new IllegalStateException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
            }
            byte[] bytes = inputStream.getOriginalBuf();
            try (FileOutputStream outputStream = new FileOutputStream(imageFile);){
                outputStream.write(bytes);
            }
        }
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public int getImagesCount() {
        return this.imagesCount;
    }
}

