/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter;

import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.ColorIndexWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.IndexesVersion;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapBuffer;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class PerVersionMapBuffer {
    private final Map<IndexesVersion, MapBuffer> buffers;
    private final Int2ObjectMap<byte[]> buffersByVersion;

    public PerVersionMapBuffer(int width, int height, Map<IndexesVersion, ColorIndexWrapper> indexes, Int2ObjectMap<ColorIndexWrapper> indexesByVersion) {
        EnumMap<IndexesVersion, MapBuffer> buffers = new EnumMap<IndexesVersion, MapBuffer>(IndexesVersion.class);
        for (ColorIndexWrapper colorIndexWrapper : indexes.values()) {
            buffers.put(colorIndexWrapper.getIndexesVersion(), new MapBuffer(colorIndexWrapper, width, height));
        }
        this.buffers = buffers;
        Int2ObjectOpenHashMap<byte[]> buffersByVersion = new Int2ObjectOpenHashMap<byte[]>();
        for (Int2ObjectMap.Entry entry : indexesByVersion.int2ObjectEntrySet()) {
            buffersByVersion.put(entry.getIntKey(), this.buffers.get((Object)((ColorIndexWrapper)entry.getValue()).getIndexesVersion()).getMapBuffer());
        }
        this.buffersByVersion = buffersByVersion;
    }

    public void draw(BufferedImage image) {
        for (MapBuffer mapBuffer : this.buffers.values()) {
            mapBuffer.draw(image);
        }
    }

    public Map<IndexesVersion, MapBuffer> getBuffers() {
        return this.buffers;
    }

    public Int2ObjectMap<byte[]> getBuffersByVersion() {
        return this.buffersByVersion;
    }
}

