/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerColorize
extends AbstractRenderLayer {
    private final RenderLayer renderLayer;
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    private boolean lazyLoaded = false;

    public RenderLayerColorize(String name, RenderLayer renderLayer, int red, int green, int blue, int alpha) {
        super(name);
        this.renderLayer = renderLayer;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage renderedImage = this.renderLayer.drawLayer(new BufferedImage(width, height, image.getType()), new Color(this.red, this.green, this.blue, this.alpha), random, renderSession);
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)renderedImage.getRaster().getDataBuffer()).getData();
        ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, false);
        return image;
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        if (this.renderLayer == null) {
            return;
        }
        this.renderLayer.lazyLoad(executor);
        this.lazyLoaded = true;
    }

    public String toString() {
        return "RenderLayerColorize(red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ")";
    }
}

