/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapCanvasConstants;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerCurve
extends AbstractRenderLayer {
    private final int count;
    private final float size;
    private final double firstOffset;
    private final double secondOffset;
    private final CapType capType;
    private final JoinType joinType;

    public RenderLayerCurve(String name, int count, float size, double firstOffset, double secondOffset, CapType capType, JoinType joinType) {
        super(name);
        this.count = count;
        this.size = size;
        this.firstOffset = firstOffset;
        this.secondOffset = secondOffset;
        this.capType = capType;
        this.joinType = joinType;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = this.drawCurves(width, height, color, random);
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
        ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, false);
        return image;
    }

    public BufferedImage drawCurves(int width, int height, Color color, Random rnd) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setColor(color);
        for (int i = 1; i <= this.count; ++i) {
            RenderLayerCurve.addCurve(width, height, g2, this.size * (float)MapCanvasConstants.calculateSizeModification(width), this.firstOffset, this.secondOffset, this.capType, this.joinType, rnd);
        }
        g2.dispose();
        return bufferedImage;
    }

    private static void addCurve(int width, int height, Graphics2D graphics, float size, double firstOffset, double secondOffset, CapType capType, JoinType joinType, Random rnd) {
        if (size <= 0.0f) {
            size = 1.0f;
        }
        CubicCurve2D.Double cubicCurve = rnd.nextBoolean() ? new CubicCurve2D.Double(rnd.nextDouble() * (double)width, rnd.nextDouble() * firstOffset * (double)height, rnd.nextDouble() * (double)width, rnd.nextDouble() * (double)height, rnd.nextDouble() * (double)width, rnd.nextDouble() * (double)height, rnd.nextDouble() * (double)width, (secondOffset + firstOffset * rnd.nextDouble()) * (double)height) : new CubicCurve2D.Double(rnd.nextDouble() * firstOffset * (double)width, rnd.nextDouble() * (double)height, rnd.nextDouble() * (double)width, rnd.nextDouble() * (double)height, rnd.nextDouble() * (double)width, rnd.nextDouble() * (double)height, (secondOffset + firstOffset * rnd.nextDouble()) * (double)width, rnd.nextDouble() * (double)height);
        double[] positions = new double[6];
        PathIterator pathIterator = cubicCurve.getPathIterator(null, 0.1);
        pathIterator.currentSegment(positions);
        Point2D.Double prev = new Point2D.Double(positions[0], positions[1]);
        pathIterator.next();
        graphics.setStroke(new BasicStroke(size, capType.getValue(), joinType.getValue()));
        while (!pathIterator.isDone()) {
            int currentSegment = pathIterator.currentSegment(positions);
            if (currentSegment == 0 || currentSegment == 1) {
                Point2D.Double point = new Point2D.Double(positions[0], positions[1]);
                graphics.drawLine((int)prev.x, (int)prev.y, (int)point.x, (int)point.y);
                prev = point;
            }
            pathIterator.next();
        }
    }

    public String toString() {
        return "RenderLayerCurve(count=" + this.count + ", size=" + this.size + ", firstOffset=" + this.firstOffset + ", secondOffset=" + this.secondOffset + ", capType=" + this.capType + ", joinType=" + this.joinType + ")";
    }

    public static enum CapType {
        BUTT(0),
        ROUND(1),
        SQUARE(2);

        private final int value;

        private CapType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "RenderLayerCurve.CapType." + this.name() + "(value=" + this.getValue() + ")";
        }
    }

    public static enum JoinType {
        MITER(0),
        ROUND(1),
        BEVEL(2);

        private final int value;

        private JoinType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "RenderLayerCurve.JoinType." + this.name() + "(value=" + this.getValue() + ")";
        }
    }
}

