/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerPaste
extends AbstractRenderLayer {
    private final int id;
    private final boolean ignoreTransparent;

    public RenderLayerPaste(String name, int id, boolean ignoreTransparent) {
        super(name);
        this.id = id;
        this.ignoreTransparent = ignoreTransparent;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        BufferedImage newImage = renderSession.getImageById(this.id);
        if (newImage != null) {
            int width = image.getWidth();
            int height = image.getHeight();
            int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            int[] srcArray = ((DataBufferInt)ImageUtils.copyImage(newImage).getRaster().getDataBuffer()).getData();
            ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, this.ignoreTransparent);
        }
        return image;
    }

    public String toString() {
        return "RenderLayerPaste(id=" + this.id + ", ignoreTransparent=" + this.ignoreTransparent + ")";
    }
}

