/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.AnswerGeneratorFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.FontCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.font.FontListDataTask;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.CodeAnswerGenerator;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.TasksUtils;

public class CodeAnswerFactory
implements AnswerGeneratorFactory {
    private final String name;
    private final Logger logger;
    private final CheckingFactoriesImpl checkingFactories;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATE codeAnswerLayerTemplate;
    private final FontCacheType fontCacheType;
    private final File cacheDirectory;

    @Override
    public AbstractCaptchaAnswerGenerator create() {
        try {
            int minRows = 1;
            int maxRows = 1;
            int minColumns = 1;
            int maxColumns = 1;
            if (this.checkingFactories.isFramedCaptchaUsed()) {
                minRows = this.checkingFactories.getMinFrameRow();
                maxRows = this.checkingFactories.getMaxFrameRow();
                minColumns = this.checkingFactories.getMinFrameColumn();
                maxColumns = this.checkingFactories.getMaxFrameColumn();
            }
            PerRaCStorage<FontListData> fontListDataPerRaCStorage = new PerRaCStorage<FontListData>(FontListData.class, minRows, maxRows, minColumns, maxColumns);
            int threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION;
            if (threads < 0) {
                threads = Runtime.getRuntime().availableProcessors();
            }
            ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("FontLoaderAndResizer", 1), null, false);
            HashSet<Character> characterSet = new HashSet<Character>();
            for (char c : this.codeAnswerLayerTemplate.CHAR_SET.toCharArray()) {
                characterSet.add(Character.valueOf(c));
            }
            this.logger.log(Level.INFO, "Loading " + characterSet.size() + " characters for code type fonts for render layer '" + this.name + "'...");
            long start = System.currentTimeMillis();
            List<PerRaCStorage.StorageComputeTask> tasks = fontListDataPerRaCStorage.createTasks(minRows, maxRows, minColumns, maxColumns, (row, column) -> executor.invoke(new FontListDataTask(this.codeAnswerLayerTemplate.FONT_SIZE * row, 128 * column, this.codeAnswerLayerTemplate.ROTATE_COUNT, this.codeAnswerLayerTemplate.OUTLINE, this.codeAnswerLayerTemplate.DEFAULT_FONT_SANS_SERIF, this.codeAnswerLayerTemplate.DEFAULT_FONT_SERIF, this.codeAnswerLayerTemplate.DEFAULT_FONT_MONOSPACED, this.codeAnswerLayerTemplate.DEFAULT_FONT_DIALOG, this.codeAnswerLayerTemplate.DEFAULT_FONT_DIALOG_INPUT, characterSet, this.codeAnswerLayerTemplate.CUSTOM_FONTS, this.fontCacheType, this.cacheDirectory, this.logger)));
            TasksUtils.executeSimpleTasks(executor, this.logger, tasks, (logger, dataToGenerate, perSec) -> logger.log(Level.INFO, "Async code font loader and resizer for '" + this.name + "' [" + dataToGenerate + "/+" + perSec + " cps]"));
            fontListDataPerRaCStorage.loadFutureTasks(tasks);
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Loaded " + characterSet.size() + " characters for code type fonts for render layer '" + this.name + "' with amount of " + fontListDataPerRaCStorage.getAllData().get(0).getLoadedFontsCount() + " fonts in " + (end - start) + "ms");
            return new CodeAnswerGenerator(fontListDataPerRaCStorage, this.codeAnswerLayerTemplate);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to create code answer for render layer '" + this.name + "'", e);
            return null;
        }
    }

    public CodeAnswerFactory(String name, Logger logger, CheckingFactoriesImpl checkingFactories, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATE codeAnswerLayerTemplate, FontCacheType fontCacheType, File cacheDirectory) {
        this.name = name;
        this.logger = logger;
        this.checkingFactories = checkingFactories;
        this.codeAnswerLayerTemplate = codeAnswerLayerTemplate;
        this.fontCacheType = fontCacheType;
        this.cacheDirectory = cacheDirectory;
    }
}

