/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.libs.gifdecoder.GifDecoder;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.GifEncoder;
import net.shieldcommunity.nullcordx.libs.squareup.gifencoder.ImageOptions;
import net.shieldcommunity.nullcordx.utils.IOUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GifCacheType {
    BIN{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return row + "-" + column + "-" + mode + ".bin";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedGif loadGifFromCache(int row, int column, File file) throws Exception {
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buf.writeBytes(bytes);
                BufferedGif bufferedGif = GifCacheType.load(buf, row, column);
                return bufferedGif;
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveGifToCache(BufferedGif gif, File file) throws Exception {
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                1.save(buf, gif);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                    int size = buf.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(buf.readByte());
                    }
                }
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
        }
    }
    ,
    BINZ{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return row + "-" + column + "-" + mode + ".binz";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedGif loadGifFromCache(int row, int column, File file) throws Exception {
            ByteBuf out;
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buf.writeBytes(bytes);
                out = IOUtils.decompress(buf);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
            if (out == null) {
                return new BufferedGif(Collections.emptyList());
            }
            try {
                BufferedGif bufferedGif = GifCacheType.load(out, row, column);
                return bufferedGif;
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveGifToCache(BufferedGif gif, File file) throws Exception {
            ByteBuf out;
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                2.save(buf, gif);
                out = IOUtils.compress(buf);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
            if (out == null) {
                return;
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                int size = out.readableBytes();
                for (int i = 0; i < size; ++i) {
                    outputStream.write(out.readByte());
                }
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }
    }
    ,
    GIF{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return row + "-" + column + "-" + mode + ".gif";
        }

        @Override
        public BufferedGif loadGifFromCache(int row, int column, File file) throws Exception {
            GifDecoder gifDecoder = new GifDecoder();
            ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
            int status = gifDecoder.read(file);
            if (status != 0) {
                return new BufferedGif(Collections.emptyList());
            }
            int count = gifDecoder.getFrameCount();
            for (int i = 0; i < count; ++i) {
                frames.add(gifDecoder.getFrame(i));
            }
            if (frames.isEmpty()) {
                return new BufferedGif(Collections.emptyList());
            }
            return new BufferedGif(frames);
        }

        @Override
        public void saveGifToCache(BufferedGif gif, File file) throws Exception {
            List<BufferedImage> frames = gif.getFrames();
            BufferedImage firstFrame = frames.get(0);
            int width = firstFrame.getWidth();
            int height = firstFrame.getHeight();
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                ImageOptions options = new ImageOptions();
                GifEncoder gifEncoder = new GifEncoder(outputStream, width, height, 0);
                for (BufferedImage bufferedImage : frames) {
                    int[] data = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                    gifEncoder.addImage(data, width, options);
                }
                gifEncoder.finishEncoding();
            }
        }
    }
    ,
    NONE{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return null;
        }

        @Override
        public BufferedGif loadGifFromCache(int row, int column, File file) throws Exception {
            return null;
        }

        @Override
        public void saveGifToCache(BufferedGif gif, File file) throws Exception {
        }
    };


    public abstract String getCacheFileName(int var1, int var2, int var3);

    public abstract BufferedGif loadGifFromCache(int var1, int var2, File var3) throws Exception;

    public abstract void saveGifToCache(BufferedGif var1, File var2) throws Exception;

    private static BufferedGif load(ByteBuf buf, int row, int column) {
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            buf.readInt();
            int expectedWidth = 128 * row;
            int expectedHeight = 128 * column;
            int width = buf.readInt();
            if (width > expectedWidth) {
                throw new IllegalStateException("Loaded image width is more then " + expectedWidth + ". We got " + width);
            }
            int height = buf.readInt();
            if (height > expectedHeight) {
                throw new IllegalStateException("Loaded image height is more then " + expectedHeight + ". We got " + height);
            }
            int size = buf.readInt();
            int[] src = new int[size];
            for (int j = 0; j < size; ++j) {
                src[j] = buf.readInt();
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            int[] dest = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            System.arraycopy(src, 0, dest, 0, src.length);
            frames.add(bufferedImage);
        }
        if (buf.isReadable()) {
            throw new IllegalStateException("Gif larger than expected. Extra bytes: " + buf.readableBytes());
        }
        return new BufferedGif(frames);
    }

    public static void save(ByteBuf out, BufferedGif gif) {
        List<BufferedImage> frames = gif.getFrames();
        out.writeInt(frames.size());
        for (int i = 0; i < frames.size(); ++i) {
            out.writeInt(i);
            BufferedImage image = frames.get(i);
            out.writeInt(image.getWidth());
            out.writeInt(image.getHeight());
            int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            out.writeInt(data.length);
            for (int d : data) {
                out.writeInt(d);
            }
        }
    }
}

