/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import io.netty.buffer.ByteBuf;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.utils.IOUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ImageCacheType {
    PNG{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return row + "-" + column + "-" + mode + ".png";
        }

        @Override
        public BufferedImage loadImageFromCache(int row, int column, File file) throws Exception {
            int expectedWidth = 128 * row;
            int expectedHeight = 128 * column;
            BufferedImage readImage = ImageIO.read(file);
            int width = readImage.getWidth();
            if (width > expectedWidth) {
                throw new IllegalStateException("Loaded image width is more then " + expectedWidth + ". We got " + width);
            }
            int height = readImage.getHeight();
            if (height > expectedHeight) {
                throw new IllegalStateException("Loaded image height is more then " + expectedHeight + ". We got " + height);
            }
            BufferedImage captchaBufferedImage = new BufferedImage(width, height, 2);
            Graphics2D gg = captchaBufferedImage.createGraphics();
            gg.drawImage((Image)readImage, 0, 0, null);
            gg.dispose();
            return captchaBufferedImage;
        }

        @Override
        public void saveImageToCache(BufferedImage image, File file) throws Exception {
            ImageIO.write((RenderedImage)image, "png", file);
        }
    }
    ,
    BIN{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return row + "-" + column + "-" + mode + ".bin";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImage loadImageFromCache(int row, int column, File file) throws Exception {
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buf.writeBytes(bytes);
                int expectedWidth = 128 * row;
                int expectedHeight = 128 * column;
                int width = buf.readInt();
                if (width > expectedWidth) {
                    throw new IllegalStateException("Loaded image width is more then " + expectedWidth + ". We got " + width);
                }
                int height = buf.readInt();
                if (height > expectedHeight) {
                    throw new IllegalStateException("Loaded image height is more then " + expectedHeight + ". We got " + height);
                }
                int size = buf.readInt();
                int[] src = new int[size];
                for (int i = 0; i < size; ++i) {
                    src[i] = buf.readInt();
                }
                if (buf.isReadable()) {
                    throw new IllegalStateException("Image larger than expected. Extra bytes: " + buf.readableBytes());
                }
                BufferedImage captchaBufferedImage = new BufferedImage(width, height, 2);
                int[] dest = ((DataBufferInt)captchaBufferedImage.getRaster().getDataBuffer()).getData();
                System.arraycopy(src, 0, dest, 0, src.length);
                BufferedImage bufferedImage = captchaBufferedImage;
                return bufferedImage;
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveImageToCache(BufferedImage image, File file) throws Exception {
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buf.writeInt(image.getWidth());
                buf.writeInt(image.getHeight());
                int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                buf.writeInt(data.length);
                for (int d : data) {
                    buf.writeInt(d);
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                    int size = buf.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(buf.readByte());
                    }
                }
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
        }
    }
    ,
    NONE{

        @Override
        public String getCacheFileName(int row, int column, int mode) {
            return null;
        }

        @Override
        public BufferedImage loadImageFromCache(int row, int column, File file) throws Exception {
            return null;
        }

        @Override
        public void saveImageToCache(BufferedImage image, File file) throws Exception {
        }
    };


    public abstract String getCacheFileName(int var1, int var2, int var3);

    public abstract BufferedImage loadImageFromCache(int var1, int var2, File var3) throws Exception;

    public abstract void saveImageToCache(BufferedImage var1, File var2) throws Exception;
}

