/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Logger;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.AnimatedFramesEntityMetaListData;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.GifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.CaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedEntityFrameDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedItemFrameRotationDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesAnimatedFramedCaptchaImpl;
import net.shieldcommunity.nullcordx.config.FrameSizes;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedCaptchaSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class AnimatedFramedCaptchaGenerationTask
extends CaptchaGenerationTask<CachedFramesAnimatedFramedCaptchaImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>>> {
    private final GifGenerator gifGenerator;
    private final boolean reverse;

    public AnimatedFramedCaptchaGenerationTask(ForkJoinPool executor, Logger logger, NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, boolean force, CaptchaHolderImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>>> holder, List<Color> colors, List<RenderLayer> groupedRenderLayers, List<RenderLayer> postRenderLayers, String cacheHash, CaptchaFileCacheType<CachedFramesAnimatedFramedCaptchaImpl<CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>>> cacheType, GifGenerator gifGenerator, boolean reverse) {
        super(executor, logger, nullCordX, generationStateWrapper, compressorThreadLocal, force, holder, colors, groupedRenderLayers, postRenderLayers, cacheHash, cacheType);
        this.gifGenerator = gifGenerator;
        this.reverse = reverse;
    }

    @Override
    public void generate(File cachedCaptchaFile) {
        XoRoShiRo128PlusRandom rnd = FastRandom.getFastRandom();
        Color randomColor = (Color)this.colors.get(((Random)rnd).nextInt(this.colors.size()));
        FrameSizes.Frame frame = AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.FRAME_SIZES.getRandomFrame(rnd);
        int row = frame.getRow();
        int column = frame.getColumn();
        int width = 128 * row;
        int height = 128 * column;
        RenderSession renderSession = new RenderSession();
        BufferedImage image = RenderLayer.renderCurrentLayers(new BufferedImage(width, height, 2), this.groupedRenderLayers, randomColor, rnd, renderSession);
        ArrayList<CachedFramesAnimatedFramedCaptchaImpl> frames = new ArrayList<CachedFramesAnimatedFramedCaptchaImpl>();
        int[] randomFrameInFrameRotation = new int[row * column];
        Arrays.fill(randomFrameInFrameRotation, 0);
        for (int i = AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.RANDOM_FRAME_ROTATE_COUNT; i > 0; --i) {
            int randomFrameIndex = ((Random)rnd).nextInt(randomFrameInFrameRotation.length);
            randomFrameInFrameRotation[randomFrameIndex] = 90 * (((Random)rnd).nextInt(3) + 1);
        }
        ArrayList<GifFrameGenerationTask> gifFrameTasks = new ArrayList<GifFrameGenerationTask>();
        BufferedGif randomGif = this.gifGenerator.generate(image, randomColor.getRGB(), rnd, renderSession);
        int frameId = 1;
        for (BufferedImage bufferedImage : randomGif.getFrames()) {
            BufferedImage copiedFrame = ImageUtils.copyImage(bufferedImage);
            copiedFrame = RenderLayer.renderCurrentLayers(copiedFrame, this.postRenderLayers, randomColor, rnd, renderSession);
            gifFrameTasks.add(new GifFrameGenerationTask(this.nullCordX, this.generationStateWrapper, this.compressorThreadLocal, frameId, row, column, randomFrameInFrameRotation, copiedFrame, this.reverse));
            ++frameId;
        }
        ArrayList unsortedFrames = new ArrayList(AnimatedFramedCaptchaGenerationTask.invokeAll(gifFrameTasks));
        Collections.sort(unsortedFrames);
        for (GifFrameGenerationTask task : unsortedFrames) {
            try {
                frames.add((CachedFramesAnimatedFramedCaptchaImpl)task.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CachedEntityFrameDataImpl cachedEntityFrameDataImpl = this.nullCordX.getCachedCaptchaManager().getCachedEntityFrameData().getDataByRaC(row, column);
        CachedFramesAnimatedFramedCaptchaImpl cachedFrames = new CachedFramesAnimatedFramedCaptchaImpl(1, Collections.unmodifiableList(frames), cachedEntityFrameDataImpl, null);
        AbstractCaptchaAnswerGenerator answer = renderSession.getAnswer();
        this.holder.setNewCaptcha(answer, cachedFrames);
        if (this.generationStateWrapper.isCancelled()) {
            return;
        }
        this.cacheType.saveCaptchaCache(answer != null ? answer.getAnswer() : null, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, cachedFrames, cachedCaptchaFile);
    }

    private static class GifFrameGenerationTask
    extends RecursiveTask<CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>>
    implements Comparable<GifFrameGenerationTask> {
        private final NullCordXImpl nullCordX;
        private final GenerationStateWrapper generationStateWrapper;
        private final CompressorThreadLocal compressorThreadLocal;
        private final int frameId;
        private final int rows;
        private final int columns;
        private final int[] randomFrameInFrameRotation;
        private final BufferedImage image;
        private final boolean reverse;

        @Override
        protected CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket> compute() {
            if (this.generationStateWrapper.isCancelled()) {
                return new CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>(this.frameId, Collections.unmodifiableList(new ArrayList()), null, null);
            }
            BufferedImage[] dividedImages = ImageUtils.splitImage(this.image, this.rows, this.columns);
            ArrayList<CachedMapDataPacket> framesInFrame = new ArrayList<CachedMapDataPacket>();
            ArrayList<MapDataGenerationTask> mapDataTasks = new ArrayList<MapDataGenerationTask>();
            int maxMapId = this.frameId * (this.rows * this.columns);
            int mapId = maxMapId - this.rows * this.columns;
            for (int mapPosition = 1; mapPosition <= this.rows * this.columns; ++mapPosition) {
                ++mapId;
                BufferedImage frameInFramedImage = dividedImages[mapPosition - 1];
                int rotation = this.randomFrameInFrameRotation[mapPosition - 1];
                if (rotation > 0) {
                    frameInFramedImage = ImageUtils.rotateImageByDegrees(frameInFramedImage, rotation);
                }
                mapDataTasks.add(new MapDataGenerationTask(this.generationStateWrapper, this.compressorThreadLocal, mapId, frameInFramedImage));
            }
            for (MapDataGenerationTask task : GifFrameGenerationTask.invokeAll(mapDataTasks)) {
                try {
                    framesInFrame.add((CachedMapDataPacket)task.get());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Collections.shuffle(framesInFrame, FastRandom.getFastRandom());
            AnimatedFramesEntityMetaListData animatedFramesEntityMetaListData = this.nullCordX.getCachedCaptchaManager().getAnimatedFramesEntityMetaData().getDataByRaC(this.rows, this.columns);
            CachedItemFrameRotationDataImpl itemFrameRotationData = animatedFramesEntityMetaListData.getData().get(this.frameId - 1);
            return new CachedFramesAnimatedFramedCaptchaImpl<CachedMapDataPacket>(this.frameId, Collections.unmodifiableList(framesInFrame), null, itemFrameRotationData);
        }

        @Override
        public int compareTo(GifFrameGenerationTask other) {
            int i = this.reverse ? Integer.compare(other.getFrameId(), this.frameId) : Integer.compare(this.frameId, other.getFrameId());
            if (i == 0) {
                i = -1;
            }
            return i;
        }

        public GifFrameGenerationTask(NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, int frameId, int rows, int columns, int[] randomFrameInFrameRotation, BufferedImage image, boolean reverse) {
            this.nullCordX = nullCordX;
            this.generationStateWrapper = generationStateWrapper;
            this.compressorThreadLocal = compressorThreadLocal;
            this.frameId = frameId;
            this.rows = rows;
            this.columns = columns;
            this.randomFrameInFrameRotation = randomFrameInFrameRotation;
            this.image = image;
            this.reverse = reverse;
        }

        public NullCordXImpl getNullCordX() {
            return this.nullCordX;
        }

        public GenerationStateWrapper getGenerationStateWrapper() {
            return this.generationStateWrapper;
        }

        public CompressorThreadLocal getCompressorThreadLocal() {
            return this.compressorThreadLocal;
        }

        public int getFrameId() {
            return this.frameId;
        }

        public int getRows() {
            return this.rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public int[] getRandomFrameInFrameRotation() {
            return this.randomFrameInFrameRotation;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        private static class MapDataGenerationTask
        extends RecursiveTask<CachedMapDataPacket> {
            private final GenerationStateWrapper generationStateWrapper;
            private final CompressorThreadLocal compressorThreadLocal;
            private final int mapId;
            private final BufferedImage image;

            @Override
            protected CachedMapDataPacket compute() {
                if (this.generationStateWrapper.isCancelled()) {
                    return new CachedMapDataPacket();
                }
                ProtocolMapData map = MapPalette.imageToMapData(this.image);
                return CachedMapDataPacket.create(new MapDataPacket(this.mapId, 0, map), this.compressorThreadLocal);
            }

            public MapDataGenerationTask(GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, int mapId, BufferedImage image) {
                this.generationStateWrapper = generationStateWrapper;
                this.compressorThreadLocal = compressorThreadLocal;
                this.mapId = mapId;
                this.image = image;
            }
        }
    }
}

