/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Logger;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.GifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.CaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesImpl;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class AnimatedHandCaptchaGenerationTask
extends CaptchaGenerationTask<CachedFramesImpl<CachedMapDataPacket>> {
    private final GifGenerator gifGenerator;
    private final boolean reverse;

    public AnimatedHandCaptchaGenerationTask(ForkJoinPool executor, Logger logger, NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, boolean force, CaptchaHolderImpl<CachedFramesImpl<CachedMapDataPacket>> holder, List<Color> colors, List<RenderLayer> groupedRenderLayers, List<RenderLayer> postRenderLayers, String cacheHash, CaptchaFileCacheType<CachedFramesImpl<CachedMapDataPacket>> cacheType, GifGenerator gifGenerator, boolean reverse) {
        super(executor, logger, nullCordX, generationStateWrapper, compressorThreadLocal, force, holder, colors, groupedRenderLayers, postRenderLayers, cacheHash, cacheType);
        this.gifGenerator = gifGenerator;
        this.reverse = reverse;
    }

    @Override
    public void generate(File cachedCaptchaFile) {
        XoRoShiRo128PlusRandom rnd = FastRandom.getFastRandom();
        Color randomColor = (Color)this.colors.get(((Random)rnd).nextInt(this.colors.size()));
        RenderSession renderSession = new RenderSession();
        BufferedImage image = RenderLayer.renderCurrentLayers(new BufferedImage(128, 128, 2), this.groupedRenderLayers, randomColor, rnd, renderSession);
        ArrayList<CachedMapDataPacket> frames = new ArrayList<CachedMapDataPacket>();
        ArrayList<GifFrameGenerationTask> gifFrameTasks = new ArrayList<GifFrameGenerationTask>();
        BufferedGif randomGif = this.gifGenerator.generate(image, randomColor.getRGB(), rnd, renderSession);
        int frameId = 1;
        for (BufferedImage bufferedImage : randomGif.getFrames()) {
            BufferedImage copiedFrame = ImageUtils.copyImage(bufferedImage);
            copiedFrame = RenderLayer.renderCurrentLayers(copiedFrame, this.postRenderLayers, randomColor, rnd, renderSession);
            gifFrameTasks.add(new GifFrameGenerationTask(this.generationStateWrapper, this.compressorThreadLocal, frameId, copiedFrame, this.reverse));
            ++frameId;
        }
        ArrayList unsortedFrames = new ArrayList(AnimatedHandCaptchaGenerationTask.invokeAll(gifFrameTasks));
        Collections.sort(unsortedFrames);
        for (GifFrameGenerationTask task : unsortedFrames) {
            try {
                frames.add((CachedMapDataPacket)task.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CachedFramesImpl cachedFramesImpl = new CachedFramesImpl(1, Collections.unmodifiableList(frames));
        AbstractCaptchaAnswerGenerator answer = renderSession.getAnswer();
        this.holder.setNewCaptcha(answer, cachedFramesImpl);
        if (this.generationStateWrapper.isCancelled()) {
            return;
        }
        this.cacheType.saveCaptchaCache(answer != null ? answer.getAnswer() : null, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, cachedFramesImpl, cachedCaptchaFile);
    }

    private static class GifFrameGenerationTask
    extends RecursiveTask<CachedMapDataPacket>
    implements Comparable<GifFrameGenerationTask> {
        private final GenerationStateWrapper generationStateWrapper;
        private final CompressorThreadLocal compressorThreadLocal;
        private final int frameId;
        private final BufferedImage image;
        private final boolean reverse;

        @Override
        protected CachedMapDataPacket compute() {
            if (this.generationStateWrapper.isCancelled()) {
                return new CachedMapDataPacket();
            }
            ProtocolMapData map = MapPalette.imageToMapData(this.image);
            return CachedMapDataPacket.create(new MapDataPacket(0, 0, map), this.compressorThreadLocal);
        }

        @Override
        public int compareTo(GifFrameGenerationTask other) {
            int i = this.reverse ? Integer.compare(other.getFrameId(), this.frameId) : Integer.compare(this.frameId, other.getFrameId());
            if (i == 0) {
                i = -1;
            }
            return i;
        }

        public GifFrameGenerationTask(GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, int frameId, BufferedImage image, boolean reverse) {
            this.generationStateWrapper = generationStateWrapper;
            this.compressorThreadLocal = compressorThreadLocal;
            this.frameId = frameId;
            this.image = image;
            this.reverse = reverse;
        }

        public GenerationStateWrapper getGenerationStateWrapper() {
            return this.generationStateWrapper;
        }

        public CompressorThreadLocal getCompressorThreadLocal() {
            return this.compressorThreadLocal;
        }

        public int getFrameId() {
            return this.frameId;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean isReverse() {
            return this.reverse;
        }
    }
}

