/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Logger;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.CaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.api.utils.FastRandom;
import net.shieldcommunity.nullcordx.cache.CachedEntityFrameDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesFramedPuzzleImpl;
import net.shieldcommunity.nullcordx.config.FrameSizes;
import net.shieldcommunity.nullcordx.config.captcha.FramedPuzzleSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.util.XoRoShiRo128PlusRandom;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;
import net.shieldcommunity.nullcordx.protocol.packets.MapDataPacket;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class FramedPuzzleGenerationTask
extends CaptchaGenerationTask<CachedFramesFramedPuzzleImpl<CachedMapDataPacket>> {
    public FramedPuzzleGenerationTask(ForkJoinPool executor, Logger logger, NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, boolean force, CaptchaHolderImpl<CachedFramesFramedPuzzleImpl<CachedMapDataPacket>> holder, List<Color> colors, List<RenderLayer> groupedRenderLayers, List<RenderLayer> postRenderLayers, String cacheHash, CaptchaFileCacheType<CachedFramesFramedPuzzleImpl<CachedMapDataPacket>> cacheType) {
        super(executor, logger, nullCordX, generationStateWrapper, compressorThreadLocal, force, holder, colors, groupedRenderLayers, postRenderLayers, cacheHash, cacheType);
    }

    @Override
    public void generate(File cachedCaptchaFile) {
        XoRoShiRo128PlusRandom rnd = FastRandom.getFastRandom();
        Color randomColor = (Color)this.colors.get(((Random)rnd).nextInt(this.colors.size()));
        FrameSizes.Frame frame = FramedPuzzleSettings.IMP.FRAMED_PUZZLE.FRAME_SIZES.getRandomFrame(rnd);
        int row = frame.getRow();
        int column = frame.getColumn();
        int width = 128 * row;
        int height = 128 * column;
        RenderSession renderSession = new RenderSession();
        BufferedImage image = RenderLayer.renderCurrentLayers(new BufferedImage(width, height, 2), this.groupedRenderLayers, randomColor, rnd, renderSession);
        image = RenderLayer.renderCurrentLayers(image, this.postRenderLayers, randomColor, rnd, renderSession);
        BufferedImage[] dividedImages = ImageUtils.splitImage(image, row, column);
        ArrayList<CachedMapDataPacket> frames = new ArrayList<CachedMapDataPacket>();
        ArrayList<MapDataGenerationTask> mapDataTasks = new ArrayList<MapDataGenerationTask>();
        Int2ObjectOpenHashMap<ProtocolItemFrameRotationType> rotations = new Int2ObjectOpenHashMap<ProtocolItemFrameRotationType>();
        for (int mapId = 1; mapId <= row * column; ++mapId) {
            BufferedImage dividedImage = dividedImages[mapId - 1];
            int randomRotation = 0;
            if (FramedPuzzleSettings.IMP.FRAMED_PUZZLE.ROTATION_CHANCE > 0.0) {
                if (FramedPuzzleSettings.IMP.FRAMED_PUZZLE.ROTATION_CHANCE > ((Random)rnd).nextDouble()) {
                    randomRotation = 90 * (((Random)rnd).nextInt(3) + 1);
                }
                if (randomRotation != 0) {
                    dividedImage = ImageUtils.rotateImageByDegrees(dividedImage, randomRotation);
                }
            }
            ProtocolItemFrameRotationType rightRotationType = ProtocolItemFrameRotationType.findRotation(ProtocolItemFrameRotationType.degreesToType(randomRotation));
            mapDataTasks.add(new MapDataGenerationTask(this.generationStateWrapper, this.compressorThreadLocal, mapId, dividedImage));
            rotations.put(mapId, rightRotationType);
        }
        for (MapDataGenerationTask task : FramedPuzzleGenerationTask.invokeAll(mapDataTasks)) {
            try {
                frames.add((CachedMapDataPacket)task.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Collections.shuffle(frames, rnd);
        CachedEntityFrameDataImpl cachedEntityFrameData = this.nullCordX.getCachedCaptchaManager().getCachedEntityFrameData().getDataByRaC(row, column);
        CachedFramesFramedPuzzleImpl cachedFrames = new CachedFramesFramedPuzzleImpl(1, Collections.unmodifiableList(frames), cachedEntityFrameData, rotations);
        AbstractCaptchaAnswerGenerator answer = renderSession.getAnswer();
        this.holder.setNewCaptcha(answer, cachedFrames);
        if (this.generationStateWrapper.isCancelled()) {
            return;
        }
        this.cacheType.saveCaptchaCache(answer != null ? answer.getAnswer() : null, ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED, cachedFrames, cachedCaptchaFile);
    }

    private static class MapDataGenerationTask
    extends RecursiveTask<CachedMapDataPacket> {
        private final GenerationStateWrapper generationStateWrapper;
        private final CompressorThreadLocal compressorThreadLocal;
        private final int mapId;
        private final BufferedImage image;

        @Override
        protected CachedMapDataPacket compute() {
            if (this.generationStateWrapper.isCancelled()) {
                return new CachedMapDataPacket();
            }
            ProtocolMapData map = MapPalette.imageToMapData(this.image);
            return CachedMapDataPacket.create(new MapDataPacket(this.mapId, 0, map), this.compressorThreadLocal);
        }

        public MapDataGenerationTask(GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, int mapId, BufferedImage image) {
            this.generationStateWrapper = generationStateWrapper;
            this.compressorThreadLocal = compressorThreadLocal;
            this.mapId = mapId;
            this.image = image;
        }
    }
}

