/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache;

import io.netty.buffer.ByteBuf;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.AnimatedFramesEntityMetaListData;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.api.cache.CachedEntityFrameData;
import net.shieldcommunity.nullcordx.cache.CachedCaptchaManagerImpl;
import net.shieldcommunity.nullcordx.cache.CachedEntityFrameDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedItemFrameRotationDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesAnimatedFramedPuzzleImpl;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;
import net.shieldcommunity.nullcordx.utils.IOUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AnimatedFramedPuzzleFileCache implements CaptchaFileCacheType<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>>
{
    BINZ{

        @Override
        public String getCacheName() {
            return "animated_framed_puzzle.binz";
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>> readyPacket, File cachedCaptchaFile) {
            ByteBuf out;
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                AnimatedFramedPuzzleFileCache.save(answer, readyPacket, buffer);
                out = IOUtils.compress(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
            if (out == null) {
                return;
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(cachedCaptchaFile.toPath(), new OpenOption[0]));){
                int size = out.readableBytes();
                for (int i = 0; i < size; ++i) {
                    outputStream.write(out.readByte());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>> holder) {
            ByteBuf out;
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(cachedCaptchaFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buffer.writeBytes(bytes);
                out = IOUtils.decompress(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
            if (out == null) {
                return;
            }
            try {
                AnimatedFramedPuzzleFileCache.load(nullCordX, out, holder);
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }
    }
    ,
    BIN{

        @Override
        public String getCacheName() {
            return "animated_framed_puzzle.bin";
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>> readyPacket, File cachedCaptchaFile) {
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                AnimatedFramedPuzzleFileCache.save(answer, readyPacket, buffer);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(cachedCaptchaFile.toPath(), new OpenOption[0]));){
                    int size = buffer.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(buffer.readByte());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
        }

        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>> holder) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(cachedCaptchaFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buffer.writeBytes(bytes);
                AnimatedFramedPuzzleFileCache.load(nullCordX, buffer, holder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
        }
    }
    ,
    NONE{

        @Override
        public String getCacheName() {
            return null;
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>> readyPacket, File cachedCaptchaFile) {
        }

        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>> holder) {
        }
    };


    private static void save(String answer, CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>> readyPacket, ByteBuf buffer) {
        buffer.writeInt(4);
        IOUtils.writeString(answer, buffer);
        CachedEntityFrameData cachedEntityFrameData = readyPacket.getEntityFrameData();
        Set<Int2ObjectMap.Entry<ProtocolItemFrameRotationType>> rotations = readyPacket.getAllRotations();
        int rotationsSize = rotations.size();
        buffer.writeInt(rotationsSize);
        for (Int2ObjectMap.Entry<ProtocolItemFrameRotationType> entry : rotations) {
            buffer.writeInt(entry.getIntKey());
            buffer.writeInt(((ProtocolItemFrameRotationType)((Object)entry.getValue())).getRotation());
        }
        buffer.writeInt(cachedEntityFrameData.getRows());
        buffer.writeInt(cachedEntityFrameData.getColumns());
        List frames = readyPacket.getFrames();
        buffer.writeInt(frames.size());
        for (CachedFramesAnimatedFramedPuzzleImpl frameInsideFramePackets : frames) {
            buffer.writeInt(frameInsideFramePackets.getFrameId());
            List frameInsideFrame = frameInsideFramePackets.getFrames();
            int frameInsideFrameSize = frameInsideFrame.size();
            buffer.writeInt(frameInsideFrameSize);
            for (int j = 0; j < frameInsideFrameSize; ++j) {
                buffer.writeInt(j);
                ((CachedMapDataPacket)frameInsideFrame.get(j)).serialize(buffer);
            }
        }
    }

    private static void load(NullCordXImpl nullCordX, ByteBuf out, CaptchaHolderImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedFramesAnimatedFramedPuzzleImpl<CachedMapDataPacket>>> holder) {
        int captchaVersion = out.readInt();
        if (captchaVersion != 4) {
            throw new IllegalStateException("Wrong captcha version! We got: " + captchaVersion);
        }
        String answer = IOUtils.readString(out);
        int rotationsSize = out.readInt();
        Int2ObjectOpenHashMap<ProtocolItemFrameRotationType> rotations = new Int2ObjectOpenHashMap<ProtocolItemFrameRotationType>();
        for (int i = 0; i < rotationsSize; ++i) {
            int frameId = out.readInt();
            int rotationType = out.readInt();
            ProtocolItemFrameRotationType type = ProtocolItemFrameRotationType.findRotation(rotationType);
            if (type == null) {
                throw new IllegalStateException("Failed to find rotation type. We got " + rotationType);
            }
            rotations.put(frameId, type);
        }
        int rows = out.readInt();
        int columns = out.readInt();
        CachedCaptchaManagerImpl cachedCaptchaManager = nullCordX.getCachedCaptchaManager();
        CachedEntityFrameDataImpl cachedEntityFrameData = cachedCaptchaManager.getCachedEntityFrameData().getDataByRaC(rows, columns);
        ArrayList frames = new ArrayList();
        int frameSize = out.readInt();
        for (int i = 0; i < frameSize; ++i) {
            int frameId = out.readInt();
            ArrayList<CachedMapDataPacket> frameInFrames = new ArrayList<CachedMapDataPacket>();
            int frameInFrameSize = out.readInt();
            for (int j = 0; j < frameInFrameSize; ++j) {
                out.readInt();
                frameInFrames.add(CachedMapDataPacket.deserialize(out));
            }
            AnimatedFramesEntityMetaListData animatedFramesEntityMetaListData = cachedCaptchaManager.getAnimatedFramesEntityMetaData().getDataByRaC(rows, columns);
            CachedItemFrameRotationDataImpl itemFrameRotationData = animatedFramesEntityMetaListData.getData().get(frameId - 1);
            frames.add(new CachedFramesAnimatedFramedPuzzleImpl(frameId, Collections.unmodifiableList(frameInFrames), null, null, itemFrameRotationData));
        }
        if (out.isReadable()) {
            throw new IllegalStateException("Data larger than expected. Extra bytes: " + out.readableBytes());
        }
        CachedFramesAnimatedFramedPuzzleImpl cachedFrames = new CachedFramesAnimatedFramedPuzzleImpl(1, Collections.unmodifiableList(frames), cachedEntityFrameData, rotations, null);
        holder.setNewCaptcha(() -> answer, cachedFrames);
    }
}

