/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache;

import io.netty.buffer.ByteBuf;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.api.cache.CachedEntityFrameData;
import net.shieldcommunity.nullcordx.cache.CachedEntityFrameDataImpl;
import net.shieldcommunity.nullcordx.cache.CachedMapDataPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.cache.cachedframes.CachedFramesPickCaptchaImpl;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectSet;
import net.shieldcommunity.nullcordx.utils.IOUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PickCaptchaFileCache implements CaptchaFileCacheType<CachedFramesPickCaptchaImpl<CachedMapDataPacket>>
{
    BINZ{

        @Override
        public String getCacheName() {
            return "pick_captcha.binz";
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedFramesPickCaptchaImpl<CachedMapDataPacket> readyPacket, File cachedCaptchaFile) {
            ByteBuf out;
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                PickCaptchaFileCache.save(readyPacket, buffer);
                out = IOUtils.compress(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
            if (out == null) {
                return;
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(cachedCaptchaFile.toPath(), new OpenOption[0]));){
                int size = out.readableBytes();
                for (int i = 0; i < size; ++i) {
                    outputStream.write(out.readByte());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> holder) {
            ByteBuf out;
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(cachedCaptchaFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buffer.writeBytes(bytes);
                out = IOUtils.decompress(buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
            if (out == null) {
                return;
            }
            try {
                PickCaptchaFileCache.load(nullCordX, out, holder);
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }
    }
    ,
    BIN{

        @Override
        public String getCacheName() {
            return "pick_captcha.bin";
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedFramesPickCaptchaImpl<CachedMapDataPacket> readyPacket, File cachedCaptchaFile) {
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                PickCaptchaFileCache.save(readyPacket, buffer);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(cachedCaptchaFile.toPath(), new OpenOption[0]));){
                    int size = buffer.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(buffer.readByte());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
        }

        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> holder) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(cachedCaptchaFile.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuf buffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buffer.writeBytes(bytes);
                PickCaptchaFileCache.load(nullCordX, buffer, holder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buffer);
            }
        }
    }
    ,
    NONE{

        @Override
        public String getCacheName() {
            return null;
        }

        @Override
        public void saveCaptchaCache(String answer, List<Integer> supportedVersions, CachedFramesPickCaptchaImpl<CachedMapDataPacket> readyPacket, File cachedCaptchaFile) {
        }

        @Override
        public void loadCaptchaCache(NullCordXImpl nullCordX, File cachedCaptchaFile, CaptchaHolderImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> holder) {
        }
    };


    /*
     * WARNING - void declaration
     */
    private static void save(CachedFramesPickCaptchaImpl<CachedMapDataPacket> readyPacket, ByteBuf buffer) {
        void var7_9;
        buffer.writeInt(4);
        CachedEntityFrameData cachedEntityFrameData = readyPacket.getEntityFrameData();
        String mainTheme = readyPacket.getMainTheme();
        IOUtils.writeString(mainTheme, buffer);
        ObjectSet<Int2ObjectMap.Entry<String>> answerPerFrame = readyPacket.getAnswerPerFrame().int2ObjectEntrySet();
        int answerPerFrameSize = answerPerFrame.size();
        buffer.writeInt(answerPerFrameSize);
        for (Int2ObjectMap.Entry entry : answerPerFrame) {
            buffer.writeInt(entry.getIntKey());
            String value = (String)entry.getValue();
            IOUtils.writeString(value, buffer);
        }
        buffer.writeInt(cachedEntityFrameData.getRows());
        buffer.writeInt(cachedEntityFrameData.getColumns());
        List frames = readyPacket.getFrames();
        buffer.writeInt(frames.size());
        boolean bl = false;
        while (var7_9 < frames.size()) {
            buffer.writeInt((int)var7_9);
            ((CachedMapDataPacket)frames.get((int)var7_9)).serialize(buffer);
            ++var7_9;
        }
    }

    private static void load(NullCordXImpl nullCordX, ByteBuf out, CaptchaHolderImpl<CachedFramesPickCaptchaImpl<CachedMapDataPacket>> holder) {
        int captchaVersion = out.readInt();
        if (captchaVersion != 4) {
            throw new IllegalStateException("Wrong captcha version! We got: " + captchaVersion);
        }
        String mainTheme = IOUtils.readString(out);
        int answerPerFrameSize = out.readInt();
        Int2ObjectOpenHashMap<String> answerPerFrame = new Int2ObjectOpenHashMap<String>();
        for (int i = 0; i < answerPerFrameSize; ++i) {
            int frameId = out.readInt();
            String value = IOUtils.readString(out);
            answerPerFrame.put(frameId, value);
        }
        int rows = out.readInt();
        int columns = out.readInt();
        CachedEntityFrameDataImpl cachedEntityFrameData = nullCordX.getCachedCaptchaManager().getCachedEntityFrameData().getDataByRaC(rows, columns);
        ArrayList<CachedMapDataPacket> frames = new ArrayList<CachedMapDataPacket>();
        int frameSize = out.readInt();
        for (int i = 0; i < frameSize; ++i) {
            out.readInt();
            frames.add(CachedMapDataPacket.deserialize(out));
        }
        if (out.isReadable()) {
            throw new IllegalStateException("Data larger than expected. Extra bytes: " + out.readableBytes());
        }
        CachedFramesPickCaptchaImpl cachedFrames = new CachedFramesPickCaptchaImpl(1, Collections.unmodifiableList(frames), cachedEntityFrameData, answerPerFrame, mainTheme);
        holder.setNewCaptcha(null, cachedFrames);
    }
}

