/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.GifCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedGif;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.libs.gifdecoder.GifDecoder;
import net.shieldcommunity.nullcordx.libs.imgscalr.Scalr;
import net.shieldcommunity.nullcordx.utils.ImageUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class GifResizeTask
extends RecursiveTask<ResizedGif> {
    private final Logger logger;
    private final ForkJoinPool executor;
    private final File cacheDirectory;
    private final int minRows;
    private final int maxRows;
    private final int minColumns;
    private final int maxColumns;
    private final GifCacheType gifCacheType;
    private final Scalr.Method resizeMethod;
    private final File gifFile;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ResizedGif compute() {
        if (this.gifFile.isDirectory()) {
            return null;
        }
        if (!this.gifFile.exists()) {
            return null;
        }
        try (InputStream is = Files.newInputStream(this.gifFile.toPath(), new OpenOption[0]);){
            String checksum = DigestUtils.md5Hex(is);
            File cachedImageDirectory = new File(this.cacheDirectory, checksum);
            if (!cachedImageDirectory.exists()) {
                cachedImageDirectory.mkdirs();
            }
            boolean cacheExists = true;
            block9: for (int w = this.minRows; w <= this.maxRows; ++w) {
                for (int h2 = this.minColumns; h2 <= this.maxColumns; ++h2) {
                    String cachedFileName = this.gifCacheType.getCacheFileName(w, h2, this.resizeMethod.ordinal());
                    if (cachedFileName == null) {
                        cacheExists = false;
                        break block9;
                    }
                    File cachedImageFile = new File(cachedImageDirectory, cachedFileName);
                    if (cachedImageFile.exists()) continue;
                    cacheExists = false;
                    break block9;
                }
            }
            PerRaCStorage<BufferedGif> perRaCStorage = new PerRaCStorage<BufferedGif>(BufferedGif.class, this.minRows, this.maxRows, this.minColumns, this.maxColumns);
            if (cacheExists) {
                perRaCStorage.loadNow(this.executor, (rows, columns) -> {
                    String cachedFileName = this.gifCacheType.getCacheFileName(rows, columns, this.resizeMethod.ordinal());
                    File cachedImageFile = new File(cachedImageDirectory, cachedFileName);
                    try {
                        return this.gifCacheType.loadGifFromCache(rows, columns, cachedImageFile);
                    }
                    catch (Exception e) {
                        cachedImageFile.delete();
                        this.logger.log(Level.SEVERE, "Error while loading cached gif " + cachedImageFile.toPath(), e);
                        return new BufferedGif(Collections.emptyList());
                    }
                });
            } else {
                GifDecoder gifDecoder = new GifDecoder();
                ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
                int status = gifDecoder.read(this.gifFile);
                if (status != 0) {
                    ResizedGif resizedGif = null;
                    return resizedGif;
                }
                int count = gifDecoder.getFrameCount();
                for (int i = 0; i < count; ++i) {
                    frames.add(gifDecoder.getFrame(i));
                }
                if (frames.isEmpty()) {
                    ResizedGif resizedGif = null;
                    return resizedGif;
                }
                perRaCStorage.loadNow(this.executor, (rows, columns) -> {
                    ArrayList<1> tasks = new ArrayList<1>();
                    for (Object imageFrame : frames) {
                        tasks.add(new RecursiveTask<BufferedImage>((BufferedImage)imageFrame, rows, columns){
                            final /* synthetic */ BufferedImage val$imageFrame;
                            final /* synthetic */ int val$rows;
                            final /* synthetic */ int val$columns;
                            {
                                this.val$imageFrame = bufferedImage;
                                this.val$rows = n;
                                this.val$columns = n2;
                            }

                            @Override
                            protected BufferedImage compute() {
                                return ImageUtils.resizeImage(this.val$imageFrame, 128 * this.val$rows, 128 * this.val$columns, GifResizeTask.this.resizeMethod);
                            }
                        });
                    }
                    ArrayList<BufferedImage> bufferedGifs = new ArrayList<BufferedImage>();
                    for (RecursiveTask task : GifResizeTask.invokeAll(tasks)) {
                        try {
                            BufferedImage image = (BufferedImage)task.get();
                            if (image == null) continue;
                            bufferedGifs.add(image);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    BufferedGif bufferedGif = new BufferedGif(bufferedGifs);
                    String cachedFileName = this.gifCacheType.getCacheFileName(rows, columns, this.resizeMethod.ordinal());
                    if (cachedFileName != null) {
                        File cachedImageFile = new File(cachedImageDirectory, cachedFileName);
                        try {
                            this.gifCacheType.saveGifToCache(bufferedGif, cachedImageFile);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "Error while writing a gif " + cachedImageFile.toPath(), e);
                        }
                    }
                    return bufferedGif;
                });
            }
            ResizedGif resizedGif = new ResizedGif(checksum, perRaCStorage);
            return resizedGif;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not load gif: '" + this.gifFile.toPath() + "'", e);
            return null;
        }
    }

    public GifResizeTask(Logger logger, ForkJoinPool executor, File cacheDirectory, int minRows, int maxRows, int minColumns, int maxColumns, GifCacheType gifCacheType, Scalr.Method resizeMethod, File gifFile) {
        this.logger = logger;
        this.executor = executor;
        this.cacheDirectory = cacheDirectory;
        this.minRows = minRows;
        this.maxRows = maxRows;
        this.minColumns = minColumns;
        this.maxColumns = maxColumns;
        this.gifCacheType = gifCacheType;
        this.resizeMethod = resizeMethod;
        this.gifFile = gifFile;
    }
}

