/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.maxmind;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.MaxMindDatabase;
import net.shieldcommunity.nullcordx.antibot.maxmind.AbstractMaxMindManager;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.DefaultMaxMindConnection;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.MaxMindConnection;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.ShieldcommunityMaxMindConnection;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.ASNCheck;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.CachedDataChecker;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.MaxMindResult;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.asnlimiter.ASNResultData;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.asnlimiter.AntiASNManager;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class AntiASNManagerImpl
extends AbstractMaxMindManager<ASNResultData>
implements AntiASNManager {
    private final LongOpenHashSet asns = new LongOpenHashSet();

    @Inject
    public AntiASNManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler, CheckingFactoriesImpl checkingFactories) {
        super(logger, nullCordX, localScheduler, checkingFactories, "AntiASNManager");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!this.checkingFactories.isASNCheckUsed()) {
            this.logger.log(Level.INFO, this.componentName + " disabled: Not used anywhere in the antibot settings!");
            return;
        }
        this.asns.addAll((Collection<? extends Long>)AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.ASNS);
        this.ignoredIps = AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.IGNORED_IPS.calculateAddresses(this.logger, "asn ignored addresses");
        MaxMindConnection maxMindConnection = AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.API_URL.USE_SHIELDCOMMUNITY_DATABASE ? new ShieldcommunityMaxMindConnection(AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.DOWNLOAD_CONNECTION_TIMEOUT, "asn") : new DefaultMaxMindConnection(AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.API_URL.DATABASE_DOWNLOAD_URL, AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.API_URL.LICENSE_KEY, AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.DOWNLOAD_CONNECTION_TIMEOUT);
        this.database = new MaxMindDatabase("ASN", AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.MAX_DATABASE_TIME, maxMindConnection, new File("NullCordX" + File.separator + "cache", "GeoIP-asn.mmdb"), this.logger);
        this.reloadDatabase();
        this.cache = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).expireAfterWrite(AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.MAX_CACHE_TIME, TimeUnit.MILLISECONDS).build(key -> {
            CachedDataChecker<ASNResultData> data = new CachedDataChecker<ASNResultData>((InetAddress)key);
            data.setCachedResult(new ASNResultData(MaxMindResult.NONE));
            return data;
        });
        int threads = AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.THREAD_POOL_SIZE;
        if (threads == -1) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        this.executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setNameFormat("NullCordX-ASN-Check-%d").build());
        this.scheduleCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedDataChecker<ASNResultData> lookup(InetAddress address) {
        if (this.cache == null) {
            return null;
        }
        CachedDataChecker cachedASNChecker = (CachedDataChecker)this.cache.get(address);
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            cachedASNChecker.setCachedResult(new ASNResultData(MaxMindResult.LOCAL_ADDRESS));
            return cachedASNChecker;
        }
        if (this.ignoredIps != null && this.ignoredIps.contains(address)) {
            cachedASNChecker.setCachedResult(new ASNResultData(MaxMindResult.IGNORED));
            return cachedASNChecker;
        }
        ReentrantLock lock = cachedASNChecker.getLock();
        if (!lock.tryLock()) {
            cachedASNChecker.setCachedResult(new ASNResultData(MaxMindResult.ALREADY_CHECKING));
            return cachedASNChecker;
        }
        try {
            if (this.database == null) {
                cachedASNChecker.setCachedResult(new ASNResultData(MaxMindResult.ERROR));
                CachedDataChecker cachedDataChecker = cachedASNChecker;
                return cachedDataChecker;
            }
            Long asn = this.database.getASN(address);
            if (asn == null) {
                cachedASNChecker.setCachedResult(new ASNResultData(MaxMindResult.ERROR));
                CachedDataChecker cachedDataChecker = cachedASNChecker;
                return cachedDataChecker;
            }
            cachedASNChecker.setCachedResult(new ASNResultData(asn, MaxMindResult.SUCCESSFULLY));
            CachedDataChecker cachedDataChecker = cachedASNChecker;
            return cachedDataChecker;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isBlacklistedASN(long asn) {
        if (AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.WHITELIST) {
            return !this.asns.contains(asn);
        }
        return this.asns.contains(asn);
    }

    private void scheduleCleanup() {
        int checkTime = AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.DATABASE_CHECK_TIME;
        if (checkTime > 0) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    AntiASNManagerImpl.this.checkDatabase();
                }
            }, checkTime, checkTime, TimeUnit.MINUTES);
        }
        if (AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.USE_FAST_CACHE_CHECK) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    AntiASNManagerImpl.this.fastCacheCheckForGeyser = AntiASNManagerImpl.this.checkAbilityForFastCache(true, ASNCheck.class);
                    AntiASNManagerImpl.this.fastCacheCheckForJava = AntiASNManagerImpl.this.checkAbilityForFastCache(false, ASNCheck.class);
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }
}

