/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.maxmind;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.MaxMindDatabase;
import net.shieldcommunity.nullcordx.antibot.maxmind.AbstractMaxMindManager;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.DefaultMaxMindConnection;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.MaxMindConnection;
import net.shieldcommunity.nullcordx.antibot.maxmind.connections.ShieldcommunityMaxMindConnection;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.CountryCheck;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.CachedDataChecker;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.MaxMindResult;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.countrylimiter.AntiCountryManager;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.countrylimiter.CountryResultData;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;

@Singleton
public class AntiCountryManagerImpl
extends AbstractMaxMindManager<CountryResultData>
implements AntiCountryManager {
    private final Set<String> countries = new HashSet<String>();

    @Inject
    public AntiCountryManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler, CheckingFactoriesImpl checkingFactories) {
        super(logger, nullCordX, localScheduler, checkingFactories, "AntiCountryManager");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!this.checkingFactories.isCountryCheckUsed()) {
            this.logger.log(Level.INFO, this.componentName + " disabled: Not used anywhere in the antibot settings!");
            return;
        }
        for (String countryISO : AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.COUNTRIES) {
            this.countries.add(countryISO.toLowerCase(Locale.ROOT));
        }
        this.ignoredIps = AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.IGNORED_IPS.calculateAddresses(this.logger, "country ignored addresses");
        MaxMindConnection maxMindConnection = AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.API_URL.USE_SHIELDCOMMUNITY_DATABASE ? new ShieldcommunityMaxMindConnection(AntibotSettings.IMP.ANTIBOT.ASN_LIMITER_CHECK.DOWNLOAD_CONNECTION_TIMEOUT, "country") : new DefaultMaxMindConnection(AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.API_URL.DATABASE_DOWNLOAD_URL, AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.API_URL.LICENSE_KEY, AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.DOWNLOAD_CONNECTION_TIMEOUT);
        this.database = new MaxMindDatabase("Country", AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.MAX_DATABASE_TIME, maxMindConnection, new File("NullCordX" + File.separator + "cache", "GeoIP-country.mmdb"), this.logger);
        this.reloadDatabase();
        this.cache = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).expireAfterWrite(AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.MAX_CACHE_TIME, TimeUnit.MILLISECONDS).build(key -> {
            CachedDataChecker<CountryResultData> data = new CachedDataChecker<CountryResultData>((InetAddress)key);
            data.setCachedResult(new CountryResultData(MaxMindResult.NONE));
            return data;
        });
        int threads = AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.THREAD_POOL_SIZE;
        if (threads == -1) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        this.executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setNameFormat("NullCordX-Country-Check-%d").build());
        this.scheduleCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedDataChecker<CountryResultData> lookup(InetAddress address) {
        if (this.cache == null) {
            return null;
        }
        CachedDataChecker cachedCountryChecker = (CachedDataChecker)this.cache.get(address);
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            cachedCountryChecker.setCachedResult(new CountryResultData(MaxMindResult.LOCAL_ADDRESS));
            return cachedCountryChecker;
        }
        if (this.ignoredIps != null && this.ignoredIps.contains(address)) {
            cachedCountryChecker.setCachedResult(new CountryResultData(MaxMindResult.IGNORED));
            return cachedCountryChecker;
        }
        ReentrantLock lock = cachedCountryChecker.getLock();
        if (!lock.tryLock()) {
            cachedCountryChecker.setCachedResult(new CountryResultData(MaxMindResult.ALREADY_CHECKING));
            return cachedCountryChecker;
        }
        try {
            if (this.database == null) {
                cachedCountryChecker.setCachedResult(new CountryResultData(MaxMindResult.ERROR));
                CachedDataChecker cachedDataChecker = cachedCountryChecker;
                return cachedDataChecker;
            }
            String countryISO = this.database.getCountryISO(address);
            if (countryISO == null) {
                cachedCountryChecker.setCachedResult(new CountryResultData(MaxMindResult.ERROR));
                CachedDataChecker cachedDataChecker = cachedCountryChecker;
                return cachedDataChecker;
            }
            cachedCountryChecker.setCachedResult(new CountryResultData(countryISO, MaxMindResult.SUCCESSFULLY));
            CachedDataChecker cachedDataChecker = cachedCountryChecker;
            return cachedDataChecker;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isBlacklistedCountryISO(String countryISO) {
        if (AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.WHITELIST) {
            return !this.countries.contains(countryISO.toLowerCase(Locale.ROOT));
        }
        return this.countries.contains(countryISO.toLowerCase(Locale.ROOT));
    }

    private void scheduleCleanup() {
        int checkTime = AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.DATABASE_CHECK_TIME;
        if (checkTime > 0) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    AntiCountryManagerImpl.this.checkDatabase();
                }
            }, checkTime, checkTime, TimeUnit.MINUTES);
        }
        if (AntibotSettings.IMP.ANTIBOT.COUNTRY_LIMITER_CHECK.USE_FAST_CACHE_CHECK) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    AntiCountryManagerImpl.this.fastCacheCheckForGeyser = AntiCountryManagerImpl.this.checkAbilityForFastCache(true, CountryCheck.class);
                    AntiCountryManagerImpl.this.fastCacheCheckForJava = AntiCountryManagerImpl.this.checkAbilityForFastCache(false, CountryCheck.class);
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }
}

