/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.HandCaptchaCheck;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;
import net.shieldcommunity.nullcordx.api.cache.cachedframes.CachedFrames;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedHandCaptchaSettings;

public class AnimatedHandCaptchaCheck
extends HandCaptchaCheck
implements AnimatedCaptchaCheck {
    private List<ByteBufPacket> frames = null;
    private ListIterator<ByteBufPacket> framesIterator = null;
    private boolean reverse = false;
    private boolean animationReady = false;

    public AnimatedHandCaptchaCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix, CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix, messagesAttemptsByLanguage);
    }

    @Override
    public String getName() {
        return "AnimatedHandCaptcha";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPositionHandCaptcha());
        this.connector.awaitTeleportConfirm();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingAnimatedHandCaptcha());
        this.sendCaptcha(flush);
    }

    @Override
    public void sendCaptcha(boolean flush) {
        this.animationReady = false;
        CaptchaHolder<? extends CachedFrames<? extends ByteBufPacket>> holder = this.nullCordX.getCachedCaptchaManager().getCachedAnimatedHandCaptchaPackets().randomCaptcha();
        if (holder == null) {
            this.complete(KickType.FAILED_CAPTCHA, this.getName() + " was not generated");
            return;
        }
        holder.setLastUsed(System.currentTimeMillis());
        this.captchaAnswerGenerator = holder.getAnswer();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSetSlotMap());
        CachedFrames<? extends ByteBufPacket> cachedFrames = holder.getCaptcha();
        this.frames = new ArrayList<ByteBufPacket>(cachedFrames.getFrames());
        this.framesIterator = null;
        this.doAnimation(flush);
        this.animationReady = true;
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingAnimatedHandCaptcha(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    @Override
    public void handleAnimation(boolean flush) {
        if (!this.animationReady) {
            return;
        }
        this.doAnimation(flush);
    }

    private void doAnimation(boolean flush) {
        if (this.frames == null) {
            return;
        }
        if (this.framesIterator == null) {
            this.framesIterator = this.frames.listIterator();
            this.reverse = false;
        }
        if (this.reverse ? !this.framesIterator.hasPrevious() : !this.framesIterator.hasNext()) {
            if (!AnimatedHandCaptchaSettings.IMP.ANIMATED_HAND_CAPTCHA.REVERSE_REPLAY_CYCLE) {
                this.framesIterator = this.frames.listIterator();
            } else {
                this.reverse = !this.reverse;
            }
        }
        this.connector.sendCachedPacket(this.reverse ? this.framesIterator.previous() : this.framesIterator.next(), flush);
    }
}

