/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import net.md_5.bungee.protocol.Protocol;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallCheckFactory;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.checking.AbstractVirtualChecking;
import net.shieldcommunity.nullcordx.api.checking.ConditionData;
import net.shieldcommunity.nullcordx.api.checking.LazyLoadedCheckingFactory;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedFallData;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CachedPacketManagerImpl;
import net.shieldcommunity.nullcordx.cache.CachedPerVersionFallData;
import net.shieldcommunity.nullcordx.cache.EmptyCachedPacket;
import net.shieldcommunity.nullcordx.cache.FallDataManager;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;
import net.shieldcommunity.nullcordx.protocol.ProtocolPosition;
import net.shieldcommunity.nullcordx.protocol.ProtocolRelativePositionType;
import net.shieldcommunity.nullcordx.protocol.packets.SynchronizePlayerPositionPacket;

public abstract class FallAndHandCaptchaCheckFactory
extends LazyLoadedCheckingFactory {
    private final Class<? extends AbstractVirtualChecking> type;
    private final LanguageManagerImpl languageManager;
    private final AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE data;
    private final ForkJoinPool executor;
    private final CheckingFactoriesImpl checkingFactories;
    protected final int maxAttempts;
    protected final int maxSolves;
    protected boolean newCaptchaOnFail;
    protected final String answerPrefix;
    protected ByteBufPacket tempCachedBlockPlacePacket = new EmptyCachedPacket();
    protected ByteBufPacket tempCachedBlockRemovePacket = new EmptyCachedPacket();
    protected ByteBufPacket cachedSynchronizePlayerPosition = new EmptyCachedPacket();
    protected CachedPerVersionFallData cachedFallDataForJavaList = new CachedPerVersionFallData(new Int2ObjectOpenHashMap<List<CachedFallData>>());
    protected CachedPerVersionFallData cachedFallDataForGeyserList = new CachedPerVersionFallData(new Int2ObjectOpenHashMap<List<CachedFallData>>());
    protected CachedMessagesByLanguage<CachedArrayPackets> messagesByLanguage;

    public FallAndHandCaptchaCheckFactory(String name, ConditionData conditionData, Class<? extends AbstractVirtualChecking> type, LanguageManagerImpl languageManager, AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE data, ForkJoinPool executor, CheckingFactoriesImpl checkingFactories, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix) {
        super(name, conditionData);
        this.type = type;
        this.languageManager = languageManager;
        this.data = data;
        this.executor = executor;
        this.checkingFactories = checkingFactories;
        this.maxAttempts = maxAttempts;
        this.maxSolves = maxSolves;
        this.newCaptchaOnFail = newCaptchaOnFail;
        this.answerPrefix = answerPrefix;
        EnumMap<LanguageType, CachedArrayPackets> cachedAttemptsMessagesMap = new EnumMap<LanguageType, CachedArrayPackets>(LanguageType.class);
        cachedAttemptsMessagesMap.put(languageManager.getDefaultLanguage(), new CachedArrayPackets(new ByteBufPacket[0]));
        this.messagesByLanguage = new CachedMessagesByLanguage(this.languageManager, cachedAttemptsMessagesMap);
    }

    public Class<? extends AbstractVirtualChecking> getType() {
        return this.type;
    }

    @Override
    public void lazyLoad() {
        if (this.lazyLoaded) {
            return;
        }
        HashSet<ProtocolBlockType> blockTypes = new HashSet<ProtocolBlockType>();
        for (String block : this.data.HIT_PLATFORM_BLOCKS) {
            ProtocolBlockType blockType;
            if (block.equalsIgnoreCase("*")) {
                blockTypes.addAll(ProtocolBlockType.getDefaultBlocks());
                continue;
            }
            try {
                blockType = ProtocolBlockType.valueOf(block.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.checkingFactories.getLogger().warning("Failed to parse block type '" + block + "' for fall and hand captcha check '" + this.getName() + "'");
                continue;
            }
            blockTypes.add(blockType);
        }
        AntibotSettings.ANTIBOT.DIMENSION.LOCATION location = AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION;
        this.cachedSynchronizePlayerPosition = CachedPacket.create(new SynchronizePlayerPositionPacket(location.X, this.data.SPAWN_HEIGHT, location.Z, 90.0f, 38.0f, this.checkingFactories.getWaitingTeleportId(), new ProtocolRelativePositionType[0]), Protocol.FILTER);
        this.tempCachedBlockPlacePacket = FallCheckFactory.createSingleBlock(new ProtocolPosition((int)location.X, this.data.SPAWN_HEIGHT - 1, (int)location.Z), ProtocolBlockType.STONE);
        this.tempCachedBlockRemovePacket = FallCheckFactory.createSingleBlock(new ProtocolPosition((int)location.X, this.data.SPAWN_HEIGHT - 1, (int)location.Z), ProtocolBlockType.AIR);
        this.cachedFallDataForJavaList = FallDataManager.createCachedPerVersionFallData(this.executor, this.data.SPAWN_HEIGHT, this.data.HIT_PLATFORM_MIN_HEIGHT, this.data.HIT_PLATFORM_MAX_HEIGHT, this.data.HIT_PLATFORM_ENABLED, false, blockTypes);
        this.cachedFallDataForGeyserList = FallDataManager.createCachedPerVersionFallData(this.executor, this.data.SPAWN_HEIGHT, this.data.HIT_PLATFORM_MIN_HEIGHT, this.data.HIT_PLATFORM_MAX_HEIGHT, this.data.HIT_PLATFORM_ENABLED, true, blockTypes);
        EnumMap<LanguageType, CachedArrayPackets> messagesByLanguage = new EnumMap<LanguageType, CachedArrayPackets>(LanguageType.class);
        for (MessagesSettings messagesSettings : this.languageManager.getAllMessagesSettings()) {
            ByteBufPacket[] messageAttempts = new ByteBufPacket[this.maxAttempts + 1];
            ReadyComponentMessage readyComponentMessage = messagesSettings.MESSAGES.NULLCORDX.CAPTCHA_WRONG;
            for (int i = 0; i <= this.maxAttempts; ++i) {
                messageAttempts[i] = CachedPacketManagerImpl.createMessagePacket(readyComponentMessage.replace("attempts", String.valueOf(i)));
            }
            messagesByLanguage.put(messagesSettings.getType(), new CachedArrayPackets(messageAttempts));
        }
        this.messagesByLanguage = new CachedMessagesByLanguage(this.languageManager, Collections.unmodifiableMap(messagesByLanguage));
        this.lazyLoaded = true;
    }

    @Override
    public void unload() {
        if (!this.lazyLoaded) {
            return;
        }
        this.tempCachedBlockPlacePacket.release();
        this.tempCachedBlockRemovePacket.release();
        this.cachedSynchronizePlayerPosition.release();
        this.cachedFallDataForJavaList.release();
        this.cachedFallDataForGeyserList.release();
        this.messagesByLanguage.release();
        this.lazyLoaded = false;
    }
}

