/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks.answer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapCanvasConstants;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.ArithmeticOperationType;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;

public class ArithmeticAnswerGenerator
extends AbstractCaptchaAnswerGenerator {
    private final Map<ArithmeticOperationType, char[]> charactersByArithmeticOperators;
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATE arithmeticAnswerLayerTemplate;
    private String answer;
    private ArithmeticOperationType currentOperationType;
    private int currentFirstNumber;
    private int currentSecondNumber;

    public ArithmeticAnswerGenerator(PerRaCStorage<FontListData> fonts, Map<ArithmeticOperationType, char[]> charactersByArithmeticOperators, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.ARITHMETIC_ANSWER_LAYER_TEMPLATE arithmeticAnswerLayerTemplate) {
        super(fonts);
        this.charactersByArithmeticOperators = charactersByArithmeticOperators;
        this.arithmeticAnswerLayerTemplate = arithmeticAnswerLayerTemplate;
    }

    @Override
    public String getAnswer() {
        return this.answer;
    }

    @Override
    public void generateAnswer(Random random) {
        int secondNumber;
        ArrayList<ArithmeticOperationType> operationsList = new ArrayList<ArithmeticOperationType>(this.charactersByArithmeticOperators.keySet());
        ArithmeticOperationType operationType = (ArithmeticOperationType)((Object)operationsList.get(random.nextInt(operationsList.size())));
        int firstNumber = random.nextInt(this.arithmeticAnswerLayerTemplate.MAX_ARITHMETIC_NUMBER + 1);
        if (firstNumber <= 0) {
            firstNumber = 1;
        }
        if ((secondNumber = random.nextInt(this.arithmeticAnswerLayerTemplate.MAX_ARITHMETIC_NUMBER + 1)) <= 0) {
            secondNumber = 1;
        }
        if (secondNumber > firstNumber) {
            int tmpFirst = firstNumber;
            firstNumber = secondNumber;
            secondNumber = tmpFirst;
        }
        int result = operationType.calculate(firstNumber, secondNumber);
        this.answer = String.valueOf(result);
        this.currentOperationType = operationType;
        this.currentFirstNumber = firstNumber;
        this.currentSecondNumber = secondNumber;
    }

    @Override
    public void draw(Color color, RenderedFont renderedFont, BufferedImage image, int width, int height, Random random) {
        List<String> examples = this.arithmeticAnswerLayerTemplate.ARITHMETIC_EXAMPLES;
        if (examples.isEmpty()) {
            return;
        }
        char[] operationSymbols = this.charactersByArithmeticOperators.get((Object)this.currentOperationType);
        char randomOperationSymbol = operationSymbols[random.nextInt(operationSymbols.length)];
        String arithExample = examples.get(random.nextInt(examples.size()));
        arithExample = arithExample.replace("%first%", String.valueOf(this.currentFirstNumber)).replace("%second%", String.valueOf(this.currentSecondNumber)).replace("%operator%", String.valueOf(randomOperationSymbol));
        ArithmeticAnswerGenerator.drawText(image, renderedFont, color.getRGB(), this.arithmeticAnswerLayerTemplate.FONT_SPACE * MapCanvasConstants.calculateSizeModification(width), this.arithmeticAnswerLayerTemplate.GLYPH_RANDOM_HEIGHT, arithExample, random);
    }

    @Override
    public ArithmeticAnswerGenerator createCopy() {
        return new ArithmeticAnswerGenerator(this.fonts, this.charactersByArithmeticOperators, this.arithmeticAnswerLayerTemplate);
    }

    public String toString() {
        return "ArithmeticAnswerGenerator(charactersByArithmeticOperators=" + this.charactersByArithmeticOperators + ", answer=" + this.getAnswer() + ", currentOperationType=" + this.currentOperationType + ", currentFirstNumber=" + this.currentFirstNumber + ", currentSecondNumber=" + this.currentSecondNumber + ")";
    }
}

