/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.api.cache;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import net.shieldcommunity.nullcordx.api.IChannelWrapper;
import net.shieldcommunity.nullcordx.api.Releasable;
import net.shieldcommunity.nullcordx.protocol.ReadyByteBuf;

public interface ByteBufPacket
extends Releasable {
    public ByteBuf getByteBufByProtocol(int var1);

    default public void writeAndClose(IChannelWrapper channelWrapper, int protocol) {
        this.writeAndClose(channelWrapper, protocol, false);
    }

    default public void writeAndClose(IChannelWrapper channelWrapper, int protocol, boolean onlineMode) {
        ByteBuf buf = this.getByteBufByProtocol(protocol);
        if (buf == null) {
            channelWrapper.close();
            return;
        }
        if (buf.refCnt() == 0) {
            channelWrapper.close();
            return;
        }
        channelWrapper.close(new ReadyByteBuf(onlineMode && this.isForceCopyOnOnlineMode() ? buf.copy() : buf.retainedDuplicate()));
    }

    default public void writePacket(IChannelWrapper channelWrapper, int protocol) {
        this.writePacket(channelWrapper.getHandle(), protocol);
    }

    default public void writePacket(IChannelWrapper channelWrapper, int protocol, boolean onlineMode) {
        this.writePacket(channelWrapper.getHandle(), protocol, onlineMode);
    }

    default public void writePacket(Channel channel, int protocol) {
        this.writePacket(channel, protocol, false);
    }

    default public void writePacket(Channel channel, int protocol, boolean onlineMode) {
        ByteBuf buf = this.getByteBufByProtocol(protocol);
        if (buf == null) {
            return;
        }
        channel.write(new ReadyByteBuf(onlineMode && this.isForceCopyOnOnlineMode() ? buf.copy() : buf.retainedDuplicate()), channel.voidPromise());
    }

    default public void writeAndFlushPacket(IChannelWrapper channelWrapper, int protocol) {
        this.writeAndFlushPacket(channelWrapper.getHandle(), protocol);
    }

    default public void writeAndFlushPacket(IChannelWrapper channelWrapper, int protocol, boolean onlineMode) {
        this.writeAndFlushPacket(channelWrapper.getHandle(), protocol, onlineMode);
    }

    default public void writeAndFlushPacket(Channel channel, int protocol) {
        this.writeAndFlushPacket(channel, protocol, false);
    }

    default public void writeAndFlushPacket(Channel channel, int protocol, boolean onlineMode) {
        ByteBuf buf = this.getByteBufByProtocol(protocol);
        if (buf == null) {
            return;
        }
        channel.writeAndFlush(new ReadyByteBuf(onlineMode && this.isForceCopyOnOnlineMode() ? buf.copy() : buf.retainedDuplicate()), channel.voidPromise());
    }

    default public boolean isForceCopyOnOnlineMode() {
        return false;
    }
}

