/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import java.util.List;
import java.util.Map;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedEntityFrameData;
import net.shieldcommunity.nullcordx.api.cache.CachedSpawnEntityItemFramePacket;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;

public class CachedEntityFrameDataImpl
implements CachedEntityFrameData {
    private final int rows;
    private final int columns;
    private final List<CachedSpawnEntityItemFramePacket> cachedItemFramesSpawn;
    private final Map<ProtocolItemFrameRotationType, Map<Integer, ByteBufPacket>> cachedMetaDataForFrames;
    private final Int2ObjectMap<ByteBufPacket> cachedEmptyMetaDataForFrames;
    private final ByteBufPacket cachedRemoveItemFrames;
    private final List<ByteBufPacket> cachedRemoveItemFramesLegacy;

    @Override
    public ByteBufPacket getRightFrameMetaByIdAndRotation(int entityId, ProtocolItemFrameRotationType rotation) {
        return this.getFrameMetaByRotation(rotation).get(entityId);
    }

    @Override
    public Map<Integer, ByteBufPacket> getFrameMetaByRotation(ProtocolItemFrameRotationType rotation) {
        return this.cachedMetaDataForFrames.get((Object)rotation);
    }

    @Override
    public ByteBufPacket getEmptyFrameMetadata(int entityId) {
        return (ByteBufPacket)this.cachedEmptyMetaDataForFrames.get(entityId);
    }

    @Override
    public void release() {
        for (CachedSpawnEntityItemFramePacket cachedSpawnEntityItemFramePacket : this.cachedItemFramesSpawn) {
            cachedSpawnEntityItemFramePacket.release();
        }
        for (Map map : this.cachedMetaDataForFrames.values()) {
            for (ByteBufPacket packet : map.values()) {
                packet.release();
            }
        }
        for (ByteBufPacket byteBufPacket : this.cachedEmptyMetaDataForFrames.values()) {
            byteBufPacket.release();
        }
        this.cachedRemoveItemFrames.release();
        for (ByteBufPacket byteBufPacket : this.cachedRemoveItemFramesLegacy) {
            byteBufPacket.release();
        }
    }

    public CachedEntityFrameDataImpl(int rows, int columns, List<CachedSpawnEntityItemFramePacket> cachedItemFramesSpawn, Map<ProtocolItemFrameRotationType, Map<Integer, ByteBufPacket>> cachedMetaDataForFrames, Int2ObjectMap<ByteBufPacket> cachedEmptyMetaDataForFrames, ByteBufPacket cachedRemoveItemFrames, List<ByteBufPacket> cachedRemoveItemFramesLegacy) {
        this.rows = rows;
        this.columns = columns;
        this.cachedItemFramesSpawn = cachedItemFramesSpawn;
        this.cachedMetaDataForFrames = cachedMetaDataForFrames;
        this.cachedEmptyMetaDataForFrames = cachedEmptyMetaDataForFrames;
        this.cachedRemoveItemFrames = cachedRemoveItemFrames;
        this.cachedRemoveItemFramesLegacy = cachedRemoveItemFramesLegacy;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public List<CachedSpawnEntityItemFramePacket> getCachedItemFramesSpawn() {
        return this.cachedItemFramesSpawn;
    }

    @Override
    public Map<ProtocolItemFrameRotationType, Map<Integer, ByteBufPacket>> getCachedMetaDataForFrames() {
        return this.cachedMetaDataForFrames;
    }

    @Override
    public Int2ObjectMap<ByteBufPacket> getCachedEmptyMetaDataForFrames() {
        return this.cachedEmptyMetaDataForFrames;
    }

    @Override
    public ByteBufPacket getCachedRemoveItemFrames() {
        return this.cachedRemoveItemFrames;
    }

    @Override
    public List<ByteBufPacket> getCachedRemoveItemFramesLegacy() {
        return this.cachedRemoveItemFramesLegacy;
    }
}

