/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import java.util.Map;
import net.md_5.bungee.protocol.Protocol;
import net.shieldcommunity.nullcordx.api.IChannelWrapper;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedCaptchaMessages;
import net.shieldcommunity.nullcordx.api.cache.CachedMessages;

public class CachedMessagesImpl
implements CachedMessages {
    private final Map<Protocol, Map<KickType, ByteBufPacket>> kickMessages;
    private final ByteBufPacket cachedMessageFallChecking;
    private final ByteBufPacket cachedMessageEmptyChecking;
    private final ByteBufPacket cachedMessageProxyChecking;
    private final ByteBufPacket cachedMessageCountryChecking;
    private final ByteBufPacket cachedMessageASNChecking;
    private final ByteBufPacket cachedMessageCheckingHandCaptcha;
    private final ByteBufPacket cachedMessageCheckingAnimatedHandCaptcha;
    private final ByteBufPacket cachedMessageCheckingFramedCaptcha;
    private final ByteBufPacket cachedMessageCheckingAnimatedFramedCaptcha;
    private final ByteBufPacket cachedMessageCheckingFramedPuzzle;
    private final ByteBufPacket cachedMessageCheckingAnimatedFramedPuzzle;
    private final ByteBufPacket cachedMessageCheckingMoreCaptcha;
    private final ByteBufPacket cachedMessageSuccessful;
    private CachedCaptchaMessages cachedPickCaptchaMessages;

    @Override
    public void release() {
        for (Map<KickType, ByteBufPacket> packets : this.kickMessages.values()) {
            for (ByteBufPacket packet : packets.values()) {
                packet.release();
            }
        }
        this.cachedMessageFallChecking.release();
        this.cachedMessageEmptyChecking.release();
        this.cachedMessageProxyChecking.release();
        this.cachedMessageCountryChecking.release();
        this.cachedMessageASNChecking.release();
        this.cachedMessageCheckingHandCaptcha.release();
        this.cachedMessageCheckingAnimatedHandCaptcha.release();
        this.cachedMessageCheckingFramedCaptcha.release();
        this.cachedMessageCheckingAnimatedFramedCaptcha.release();
        this.cachedMessageCheckingFramedPuzzle.release();
        this.cachedMessageCheckingAnimatedFramedPuzzle.release();
        this.cachedMessageCheckingMoreCaptcha.release();
        this.cachedMessageSuccessful.release();
        if (this.cachedPickCaptchaMessages != null) {
            this.cachedPickCaptchaMessages.release();
        }
    }

    @Override
    public void sendKickPacket(KickType kickType, IChannelWrapper wrapper, Protocol protocol, int version) {
        if (!wrapper.getHandle().isActive() || wrapper.isClosed() || wrapper.isClosing()) {
            return;
        }
        Map<KickType, ByteBufPacket> packets = this.kickMessages.get((Object)protocol);
        if (packets == null) {
            wrapper.close();
            return;
        }
        ByteBufPacket packet = packets.get((Object)kickType);
        if (packet == null) {
            wrapper.close();
            return;
        }
        packet.writeAndClose(wrapper, version);
    }

    public CachedMessagesImpl(Map<Protocol, Map<KickType, ByteBufPacket>> kickMessages, ByteBufPacket cachedMessageFallChecking, ByteBufPacket cachedMessageEmptyChecking, ByteBufPacket cachedMessageProxyChecking, ByteBufPacket cachedMessageCountryChecking, ByteBufPacket cachedMessageASNChecking, ByteBufPacket cachedMessageCheckingHandCaptcha, ByteBufPacket cachedMessageCheckingAnimatedHandCaptcha, ByteBufPacket cachedMessageCheckingFramedCaptcha, ByteBufPacket cachedMessageCheckingAnimatedFramedCaptcha, ByteBufPacket cachedMessageCheckingFramedPuzzle, ByteBufPacket cachedMessageCheckingAnimatedFramedPuzzle, ByteBufPacket cachedMessageCheckingMoreCaptcha, ByteBufPacket cachedMessageSuccessful, CachedCaptchaMessages cachedPickCaptchaMessages) {
        this.kickMessages = kickMessages;
        this.cachedMessageFallChecking = cachedMessageFallChecking;
        this.cachedMessageEmptyChecking = cachedMessageEmptyChecking;
        this.cachedMessageProxyChecking = cachedMessageProxyChecking;
        this.cachedMessageCountryChecking = cachedMessageCountryChecking;
        this.cachedMessageASNChecking = cachedMessageASNChecking;
        this.cachedMessageCheckingHandCaptcha = cachedMessageCheckingHandCaptcha;
        this.cachedMessageCheckingAnimatedHandCaptcha = cachedMessageCheckingAnimatedHandCaptcha;
        this.cachedMessageCheckingFramedCaptcha = cachedMessageCheckingFramedCaptcha;
        this.cachedMessageCheckingAnimatedFramedCaptcha = cachedMessageCheckingAnimatedFramedCaptcha;
        this.cachedMessageCheckingFramedPuzzle = cachedMessageCheckingFramedPuzzle;
        this.cachedMessageCheckingAnimatedFramedPuzzle = cachedMessageCheckingAnimatedFramedPuzzle;
        this.cachedMessageCheckingMoreCaptcha = cachedMessageCheckingMoreCaptcha;
        this.cachedMessageSuccessful = cachedMessageSuccessful;
        this.cachedPickCaptchaMessages = cachedPickCaptchaMessages;
    }

    @Override
    public Map<Protocol, Map<KickType, ByteBufPacket>> getKickMessages() {
        return this.kickMessages;
    }

    @Override
    public ByteBufPacket getCachedMessageFallChecking() {
        return this.cachedMessageFallChecking;
    }

    @Override
    public ByteBufPacket getCachedMessageEmptyChecking() {
        return this.cachedMessageEmptyChecking;
    }

    @Override
    public ByteBufPacket getCachedMessageProxyChecking() {
        return this.cachedMessageProxyChecking;
    }

    @Override
    public ByteBufPacket getCachedMessageCountryChecking() {
        return this.cachedMessageCountryChecking;
    }

    @Override
    public ByteBufPacket getCachedMessageASNChecking() {
        return this.cachedMessageASNChecking;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingHandCaptcha() {
        return this.cachedMessageCheckingHandCaptcha;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingAnimatedHandCaptcha() {
        return this.cachedMessageCheckingAnimatedHandCaptcha;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingFramedCaptcha() {
        return this.cachedMessageCheckingFramedCaptcha;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingAnimatedFramedCaptcha() {
        return this.cachedMessageCheckingAnimatedFramedCaptcha;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingFramedPuzzle() {
        return this.cachedMessageCheckingFramedPuzzle;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingAnimatedFramedPuzzle() {
        return this.cachedMessageCheckingAnimatedFramedPuzzle;
    }

    @Override
    public ByteBufPacket getCachedMessageCheckingMoreCaptcha() {
        return this.cachedMessageCheckingMoreCaptcha;
    }

    @Override
    public ByteBufPacket getCachedMessageSuccessful() {
        return this.cachedMessageSuccessful;
    }

    @Override
    public CachedCaptchaMessages getCachedPickCaptchaMessages() {
        return this.cachedPickCaptchaMessages;
    }

    public void setCachedPickCaptchaMessages(CachedCaptchaMessages cachedPickCaptchaMessages) {
        this.cachedPickCaptchaMessages = cachedPickCaptchaMessages;
    }
}

