/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;

public enum FallDataBlocks {
    V1_8(FallDataBlocks.createBlocks(ProtocolBlockType.FARMLAND, ProtocolBlockType.SNOW_LAYER_1), version -> version >= 47 && version <= 110),
    V1_10(FallDataBlocks.createBlocks(ProtocolBlockType.SNOW_LAYER_1), version -> version >= 210 && version <= 340),
    V1_13(FallDataBlocks.createBlocks(new ProtocolBlockType[0]), version -> version >= 393 && version <= 765);

    private final Set<ProtocolBlockType> blocks;
    private final Predicate<Integer> support;

    public List<Integer> calculateVersions(List<Integer> supported) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int protocol : supported) {
            if (!this.support.test(protocol)) continue;
            versions.add(protocol);
        }
        return versions;
    }

    private static Set<ProtocolBlockType> createBlocks(ProtocolBlockType ... ignore) {
        HashSet<ProtocolBlockType> tmp = new HashSet<ProtocolBlockType>(Arrays.asList(ProtocolBlockType.values()));
        for (ProtocolBlockType ignored : ignore) {
            tmp.remove((Object)ignored);
        }
        return tmp;
    }

    private FallDataBlocks(Set<ProtocolBlockType> blocks, Predicate<Integer> support) {
        this.blocks = blocks;
        this.support = support;
    }

    public Set<ProtocolBlockType> getBlocks() {
        return this.blocks;
    }

    public Predicate<Integer> getSupport() {
        return this.support;
    }
}

