/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.cache.CachedFallData;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CachedPerVersionFallData;
import net.shieldcommunity.nullcordx.cache.FallDataBlocks;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;
import net.shieldcommunity.nullcordx.protocol.ProtocolPosition;
import net.shieldcommunity.nullcordx.protocol.packets.MultiBlockUpdatePacket;

public final class FallDataManager {
    private static final double[] CACHED_TICK_SPEED;
    public static final int MAX_TICK = 1024;
    public static final int TICK_START = 1;

    public static CachedPerVersionFallData createCachedPerVersionFallData(ForkJoinPool executor, int spawnHeight, int minHeight, int maxHeight, boolean platform, boolean limited, Set<ProtocolBlockType> enabledBlocks) {
        if (enabledBlocks == null) {
            enabledBlocks = new HashSet<ProtocolBlockType>();
        }
        if (enabledBlocks.isEmpty()) {
            enabledBlocks.add(ProtocolBlockType.AIR);
        }
        Int2ObjectOpenHashMap<List<CachedFallData>> data = new Int2ObjectOpenHashMap<List<CachedFallData>>();
        if (platform) {
            EnumMap<FallDataBlocks, CalculatedData> calculatedData = new EnumMap<FallDataBlocks, CalculatedData>(FallDataBlocks.class);
            for (FallDataBlocks fallDataBlocks : FallDataBlocks.values()) {
                Collection<ProtocolBlockType> types = limited ? FallDataManager.getStandardHeightBlocks(fallDataBlocks.getBlocks()) : fallDataBlocks.getBlocks();
                List<Integer> versions = fallDataBlocks.calculateVersions(ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED);
                ArrayList<CachedFallData> tmp = new ArrayList<CachedFallData>();
                for (ProtocolBlockType type : types) {
                    if (!enabledBlocks.contains((Object)type)) continue;
                    List<CachedFallData> cachedFallDataList = FallDataManager.createCachedFallData(executor, spawnHeight, minHeight, maxHeight, type, versions);
                    tmp.addAll(cachedFallDataList);
                }
                calculatedData.put(fallDataBlocks, new CalculatedData(fallDataBlocks, versions, tmp));
            }
            for (CalculatedData calculated : calculatedData.values()) {
                for (int v : calculated.getVersions()) {
                    data.put(v, calculated.getCachedFallData());
                }
            }
        } else {
            for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED) {
                ArrayList<CachedFallData> tmp = new ArrayList<CachedFallData>();
                tmp.add(new CachedFallData(ProtocolBlockType.AIR, spawnHeight, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2.147483647E9, null, null));
                data.put(version, (List<CachedFallData>)tmp);
            }
        }
        return new CachedPerVersionFallData(data);
    }

    public static double normalizeSpeedDouble(double d) {
        return Math.floor(d * 100.0) / 100.0;
    }

    private static int calculateHitTick(int height, int platformY, double blockOffset) {
        double y = height;
        for (int i = 1; i < 1024; ++i) {
            double currentSpeed = FallDataManager.calculateSpeedByTick(i);
            double nextY = y - currentSpeed;
            if (nextY <= (double)platformY + blockOffset) {
                return i;
            }
            y = nextY;
        }
        return -1;
    }

    private static double calculateSpeedByTick(int ticks) {
        return -((Math.pow(0.98, ticks) - 1.0) * 3.92);
    }

    private static ByteBufPacket createMultiBlocks(int y, ProtocolBlockType block, List<Integer> versions) {
        int platformSize = 16;
        HashMap<ProtocolPosition, ProtocolBlockType> createsBlocks = new HashMap<ProtocolPosition, ProtocolBlockType>();
        for (int x = 0; x < platformSize; ++x) {
            for (int z = 0; z < platformSize; ++z) {
                createsBlocks.put(new ProtocolPosition(x, y, z), block);
            }
        }
        AntibotSettings.ANTIBOT.DIMENSION.LOCATION location = AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION;
        int chunkXOffset = (int)location.X >> 4;
        int chunkZOffset = (int)location.Z >> 4;
        return CachedPacket.create((DefinedPacket)new MultiBlockUpdatePacket(chunkXOffset, chunkZOffset, createsBlocks), Protocol.FILTER, versions);
    }

    private static List<CachedFallData> createCachedFallData(ForkJoinPool executor, int spawnHeight, int minHeight, int maxHeight, ProtocolBlockType block, List<Integer> versions) {
        ArrayList<Callable<CachedFallData>> tasks = new ArrayList<Callable<CachedFallData>>();
        if (maxHeight > spawnHeight) {
            maxHeight = spawnHeight;
        }
        if (minHeight > maxHeight) {
            minHeight = maxHeight;
        }
        int i = minHeight;
        while (i <= maxHeight) {
            int finalI = i++;
            tasks.add(() -> {
                int hitTick = FallDataManager.calculateHitTick(spawnHeight, finalI, block.getHeight());
                int hitTickHalf = hitTick / 2;
                return new CachedFallData(block, spawnHeight, hitTick, hitTickHalf, finalI, block.getHeight(), FallDataManager.createMultiBlocks(finalI, block, versions), FallDataManager.createMultiBlocks(finalI, ProtocolBlockType.AIR, versions));
            });
        }
        try {
            List future = executor.invokeAll(tasks);
            ArrayList<CachedFallData> fallData = new ArrayList<CachedFallData>();
            for (Future future2 : future) {
                fallData.add((CachedFallData)future2.get());
            }
            return fallData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double getCachedTickSpeed(int tick) {
        return CACHED_TICK_SPEED[tick];
    }

    private static List<ProtocolBlockType> getStandardHeightBlocks(Collection<ProtocolBlockType> protocolBlockTypes) {
        ArrayList<ProtocolBlockType> blocks = new ArrayList<ProtocolBlockType>();
        for (ProtocolBlockType type : protocolBlockTypes) {
            if (type.getHeight() < 0.5) continue;
            blocks.add(type);
        }
        return blocks;
    }

    private FallDataManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        double[] tickSpeed = new double[1024];
        for (int i = 0; i < 1024; ++i) {
            tickSpeed[i] = FallDataManager.normalizeSpeedDouble(FallDataManager.calculateSpeedByTick(i));
        }
        CACHED_TICK_SPEED = tickSpeed;
    }

    private static final class CalculatedData {
        private final FallDataBlocks fallDataBlocks;
        private final List<Integer> versions;
        private final List<CachedFallData> cachedFallData;

        public CalculatedData(FallDataBlocks fallDataBlocks, List<Integer> versions, List<CachedFallData> cachedFallData) {
            this.fallDataBlocks = fallDataBlocks;
            this.versions = versions;
            this.cachedFallData = cachedFallData;
        }

        public FallDataBlocks getFallDataBlocks() {
            return this.fallDataBlocks;
        }

        public List<Integer> getVersions() {
            return this.versions;
        }

        public List<CachedFallData> getCachedFallData() {
            return this.cachedFallData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CalculatedData)) {
                return false;
            }
            CalculatedData other = (CalculatedData)o;
            FallDataBlocks this$fallDataBlocks = this.getFallDataBlocks();
            FallDataBlocks other$fallDataBlocks = other.getFallDataBlocks();
            if (this$fallDataBlocks == null ? other$fallDataBlocks != null : !((Object)((Object)this$fallDataBlocks)).equals((Object)other$fallDataBlocks)) {
                return false;
            }
            List<Integer> this$versions = this.getVersions();
            List<Integer> other$versions = other.getVersions();
            if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
                return false;
            }
            List<CachedFallData> this$cachedFallData = this.getCachedFallData();
            List<CachedFallData> other$cachedFallData = other.getCachedFallData();
            return !(this$cachedFallData == null ? other$cachedFallData != null : !((Object)this$cachedFallData).equals(other$cachedFallData));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FallDataBlocks $fallDataBlocks = this.getFallDataBlocks();
            result = result * 59 + ($fallDataBlocks == null ? 43 : ((Object)((Object)$fallDataBlocks)).hashCode());
            List<Integer> $versions = this.getVersions();
            result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
            List<CachedFallData> $cachedFallData = this.getCachedFallData();
            result = result * 59 + ($cachedFallData == null ? 43 : ((Object)$cachedFallData).hashCode());
            return result;
        }

        public String toString() {
            return "FallDataManager.CalculatedData(fallDataBlocks=" + this.getFallDataBlocks() + ", versions=" + this.getVersions() + ", cachedFallData=" + this.getCachedFallData() + ")";
        }
    }
}

