/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.api.utils.TimeUtil;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;

public class ConsoleCpuCommand
extends CommandNodeBungee {
    public ConsoleCpuCommand(CommandNodeBungee root) {
        super(root, "cpu");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_CPU_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        long maxHeapMem = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long totalHeapMem = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        long freeHeapMem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
        long usedHeapMem = totalHeapMem - freeHeapMem;
        String uptimeDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date(BungeeCord.UPTIME));
        sender.sendMessage(SEP);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PROXY_UPTIME.replace("uptime_data", uptimeDate).replace("uptime_time", TimeUtil.formatTime((System.currentTimeMillis() - BungeeCord.UPTIME) / 1000L, this.getMessagesSettings(sender))));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PROXY_CPU_USAGE.replace("cpu", StatisticsManagerImpl.getProcessorUsage(false)).replace("threads", "" + ManagementFactory.getThreadMXBean().getThreadCount()));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PROCESSOR_CPU_USAGE.replace("cpu", StatisticsManagerImpl.getProcessorUsage(true)).replace("cores", "" + Runtime.getRuntime().availableProcessors()));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.MAXIMUM_HEAP_MEMORY.replace("memory", "" + maxHeapMem));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_HEAP_MEMORY.replace("memory", "" + totalHeapMem));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.FREE_HEAP_MEMORY.replace("memory", "" + freeHeapMem));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.USED_HEAP_MEMORY.replace("memory", "" + usedHeapMem));
        sender.sendMessage(" ");
        long usedDirectMem = 0L;
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean pool : pools) {
            usedDirectMem += pool.getMemoryUsed();
        }
        usedDirectMem = usedDirectMem / 1024L / 1024L;
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.USED_DIRECT_MEMORY.replace("memory", "" + usedDirectMem));
        long totalUsed = usedHeapMem + usedDirectMem;
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_USED_MEMORY.replace("memory", "" + totalUsed));
        sender.sendMessage(SEP);
    }
}

