/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.ConnectionThrottle;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class ConsoleUnbanCommand
extends CommandNodeBungee {
    public ConsoleUnbanCommand(CommandNodeBungee root) {
        super(root, "unban");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_UNBAN_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.sendCurrentHelp(sender);
            return;
        }
        BungeeCord bungeeCord = BungeeCord.getInstance();
        ConnectionThrottle throttle = bungeeCord.getConnectionThrottle();
        NullCordXImpl nullCordX = bungeeCord.getNullCordX();
        String address = args[0];
        if (address.equalsIgnoreCase("all")) {
            nullCordX.getAntiBotCheckLimiter().clear();
            nullCordX.getBlacklistManager().invalidateAll();
            nullCordX.getAntiProxyManager().clear(true);
            nullCordX.getAntiCountryManager().clear();
            if (throttle != null) {
                throttle.invalidateAll();
            }
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.ALL_ADDRESS_UNBAN);
            return;
        }
        InetAddress inetAddress = InetSocketUtil.getAddressSafe(address);
        if (inetAddress == null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.ADDRESS_PARSE_FAILED);
            return;
        }
        nullCordX.getAntiBotCheckLimiter().remove(inetAddress);
        nullCordX.getBlacklistManager().unBlacklist(inetAddress);
        nullCordX.getAntiProxyManager().remove(inetAddress, true);
        nullCordX.getAntiCountryManager().remove(inetAddress);
        if (throttle != null) {
            throttle.unthrottle(inetAddress);
        }
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.ADDRESS_UNBAN.replace("address", address));
    }

    @Override
    public Collection<String> onSuggest(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        HashSet<String> matches = new HashSet<String>();
        String search = args[0].toLowerCase();
        for (String arg : Collections.singletonList("all")) {
            if (!arg.toLowerCase().startsWith(search)) continue;
            matches.add(arg);
        }
        return matches;
    }
}

