/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.api.database.WhitelistedUserData;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;

public class ConsoleWhiteListAddCommand
extends CommandNodeBungee {
    public ConsoleWhiteListAddCommand(CommandNodeBungee root) {
        super(root, "add");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_WHITELIST_ADD_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.sendCurrentHelp(sender);
            return;
        }
        String name = args[0];
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        WhitelistedUserData whitelistedUserData = nullCordX.getUserManager().getWhitelistedUser(name);
        if (whitelistedUserData != null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.ALREADY_WHITELISTED.replace("user", name));
            return;
        }
        nullCordX.getUserManager().addPlayerToWhitelist(name);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.WHITELIST_ADDED.replace("user", name));
    }

    @Override
    public Collection<String> onSuggest(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        HashSet<String> matches = new HashSet<String>();
        String search = args[0].toLowerCase();
        for (ProxiedPlayer player : BungeeCord.getInstance().getPlayers()) {
            if (!player.getName().toLowerCase().startsWith(search)) continue;
            matches.add(player.getName());
        }
        return matches;
    }
}

