/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.shieldcommunity.nullcordx.config.IpAddresses;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.IpAddressesSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.MapType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class AntibotSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new IpAddressesSerializer()).build();
    @Transient
    public static final AntibotSettings IMP = new AntibotSettings();
    public ANTIBOT ANTIBOT = new ANTIBOT();
    public long CONFIG_VERSION = 2L;

    public AntibotSettings() {
        super(Paths.get("NullCordX/antibot.yml", new String[0]), CONFIG);
    }

    @Comment(value={@CommentValue(value="Configuration for antibot")})
    public static class ANTIBOT {
        @Comment(value={@CommentValue(value="Does the proxy need to constantly check all the players who join the server each time?")})
        public boolean ALWAYS_CHECK = false;
        @NewLine
        @Comment(value={@CommentValue(value="Does the proxy need to constantly check all players only when a bot attack is detected?")})
        public boolean ALWAYS_CHECK_ON_ATTACK = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the number of current players on check be added to the online counter?")})
        public boolean SHOW_ONLINE = false;
        @NewLine
        @Comment(value={@CommentValue(value="List of ip addresses to ignore for checking")})
        public IpAddresses IGNORED_IPS = new IpAddresses(Arrays.asList("127.0.0.1/24", "172.18.0.1/24"));
        @NewLine
        @Comment(value={@CommentValue(value="How many players can be with the same IP address in the filter at the same time?")})
        public int MAX_SAME_ADDRESS_LIMIT = 1;
        @NewLine
        @Comment(value={@CommentValue(value="After how many milliseconds to kick the client if he did not send the expected packets on time?")})
        public int PACKET_RECEIVE_TIMEOUT = 12000;
        @NewLine
        @Comment(value={@CommentValue(value="How often should the filter schedule tasks for the player on the filter? In milliseconds.")})
        public int SCHEDULE_TASK_INTERVAL = 1000;
        @NewLine
        @Comment(value={@CommentValue(value="Should the antibot wait for ClientSettings from the client?"), @CommentValue(value="If disabled, the proxy will start checking as soon as the player was connected to the filter."), @CommentValue(value="Warning! Disabling this has no effect on 1.20.2+ clients, since those clients always send ClientSettings during the configuration phase.")})
        public boolean WAIT_CLIENT_SETTINGS = true;
        @NewLine
        @Comment(value={@CommentValue(value="Whether to force to check the player if his ip address was changed even when he successfully passed the check before?"), @CommentValue(value="Turning off the option will force the proxy to check the player only 1 time (until the automatic cache purge configured in sql.yml is performed)"), @CommentValue(value="And also turning it off makes the very essence of the check insecure, since the attacker can attack nicknames that have already successfully passed the checks, thus bypassing all the checks.")})
        public boolean CHECK_PLAYER_ON_IP_CHANGE = true;
        @NewLine
        @Comment(value={@CommentValue(value="How big a packet can a client send during the check?")})
        public int MAX_BYTES = 2048;
        @NewLine
        @Comment(value={@CommentValue(value="How many packets the player can send per second during the check?")})
        public int MAX_PACKETS_PER_SECOND = 100;
        @NewLine
        @Comment(value={@CommentValue(value="What is the maximum size of all sent packets per second during the check?")})
        public int MAX_PACKET_BYTES_PER_SECOND = 8192;
        @NewLine
        @Comment(value={@CommentValue(value="What is the maximum size in bytes of a PluginMessage expected from a client?")})
        public int MAX_PLUGIN_MESSAGES_BYTES = 65536;
        @NewLine
        @Comment(value={@CommentValue(value="What is the maximum number of plugin messages a client can register on a filter?")})
        public int MAX_PLUGIN_MESSAGES_AMOUNT = 128;
        public CONNECT_TO_FILTER_ONLY_ON_ATTACK CONNECT_TO_FILTER_ONLY_ON_ATTACK = new CONNECT_TO_FILTER_ONLY_ON_ATTACK();
        public MANY_CHECKS MANY_CHECKS = new MANY_CHECKS();
        public MODES MODES = new MODES();
        @NewLine
        @Comment(value={@CommentValue(value="When to ask players to rejoin after a successful check?"), @CommentValue(value="-1 - Disabled"), @CommentValue(value="0 - Just in a bot attack (Warning! Some plugins, such as FastLogin, listen to the PreLoginEvent,"), @CommentValue(value="because of this, they themselves can detect a bot attack before NullCordX and prevent it,"), @CommentValue(value="which is why NullCordX may not detect it in time.)"), @CommentValue(value="1 - Always"), @CommentValue, @CommentValue(value="Using this function, you can potentially increase performance, since when connecting to a filter,"), @CommentValue(value="the proxy will not fire such events as LoginEvent and PreLoginEvent, because the player will still"), @CommentValue(value="be kicked at the end of the check and there is no point in continuing the login process."), @CommentValue(value="Also, if online-mode is enabled in the bungee settings, the proxy will not authorize premium players from mojang servers,"), @CommentValue(value="since the player connects as a non-premium player, which means during bot attacks, you will not receive a ratelimit from mojang servers.")})
        public int REJOIN_AFTER_CHECK = 1;
        public BOT_ATTACK_DETECTION BOT_ATTACK_DETECTION = new BOT_ATTACK_DETECTION();
        public MODES_TEMPLATES MODES_TEMPLATE = new MODES_TEMPLATES();
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for condition check override."), @CommentValue, @CommentValue(value="The name of the check must be the name of the template."), @CommentValue(value="By default, all templates have the following conditions:"), @CommentValue(value="if-success: next"), @CommentValue(value="if-failed: kick"), @CommentValue(value="check-ping-on-complete: true"), @CommentValue(value="reset-ping-on-complete: true"), @CommentValue(value="But you can override the behavior for each template."), @CommentValue, @CommentValue(value="Available conditions:"), @CommentValue(value="next - The next check will be done. If there is no next check, the player will successfully check for a bot."), @CommentValue(value="finish - Instantly complete the check for the bot."), @CommentValue(value="kick - Instantly kick a player. The kick message will be unknown if the player was kicked while successfully passing one of the checks."), @CommentValue(value="Any other name - The name of the check template. The new specified check will start. This will allow the check to be performed in any order other than next."), @CommentValue, @CommentValue(value="Other settings:"), @CommentValue(value="check-ping-on-complete - Should a ping check be performed after the check has been completed?"), @CommentValue(value="It may be useful to avoid checking ping after quick checks such as asn or country, since the ping result may not be accurate."), @CommentValue(value="reset-ping-on-complete - Should the proxy reset the current ping state every time this check completes?")})
        @MapType(value=LinkedHashMap.class)
        public Map<String, CONDITION_CHECK> CONDITION_CHECKS_OVERRIDE = new LinkedHashMap<String, CONDITION_CHECK>();
        public COUNTRY_LIMITER_CHECK COUNTRY_LIMITER_CHECK;
        public ASN_LIMITER_CHECK ASN_LIMITER_CHECK;
        public ANTI_PROXY_CHECK ANTI_PROXY_CHECK;
        public ATTRIBUTES_LIMITER_CHECK ATTRIBUTES_LIMITER_CHECK;
        public UNSTABLE_PING_CHECK UNSTABLE_PING_CHECK;
        public DIRECT_CONNECTION_CHECK DIRECT_CONNECTION_CHECK;
        public DIMENSION DIMENSION;

        public ANTIBOT() {
            this.CONDITION_CHECKS_OVERRIDE.put("country-with-condition", new CONDITION_CHECK("on-successful-fast-fall", "framed-captcha", true, true));
            this.CONDITION_CHECKS_OVERRIDE.put("on-successful-fast-fall", new CONDITION_CHECK("finish", "framed-captcha", true, true));
            this.COUNTRY_LIMITER_CHECK = new COUNTRY_LIMITER_CHECK();
            this.ASN_LIMITER_CHECK = new ASN_LIMITER_CHECK();
            this.ANTI_PROXY_CHECK = new ANTI_PROXY_CHECK();
            this.ATTRIBUTES_LIMITER_CHECK = new ATTRIBUTES_LIMITER_CHECK();
            this.UNSTABLE_PING_CHECK = new UNSTABLE_PING_CHECK();
            this.DIRECT_CONNECTION_CHECK = new DIRECT_CONNECTION_CHECK();
            this.DIMENSION = new DIMENSION();
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for connect to filter on attack")})
        public static class CONNECT_TO_FILTER_ONLY_ON_ATTACK {
            @Comment(value={@CommentValue(value="Will the proxy connect players to the filter only if it detects a bot attack?"), @CommentValue(value="If enabled, any connection to the server will count the bot counter until a bot attack is detected, then if an attack is detected, players will be connected to the filter and the counter will be counted only on the filter.")})
            public boolean ENABLED = false;
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy treat each incoming player as a player who successfully passed the verification?"), @CommentValue(value="If enabled, the player connected to the server will be immediately written to the cache."), @CommentValue(value="If the under attack mode is enabled, such a player will not be checked for a bot because he is already cached.")})
            public boolean ALWAYS_CACHE = false;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for many checks")})
        public static class MANY_CHECKS {
            @Comment(value={@CommentValue(value="After how many connection attempts to filter will a player be added to the blacklist?")})
            public int MAX_ATTEMPTS = 4;
            public PROGRESSION PROGRESSION = new PROGRESSION();
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy block the ip address of a player who failed multiple bot checks?")})
            public boolean BLACKLIST_ADDRESS = false;

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for progression")})
            public static class PROGRESSION {
                @Comment(value={@CommentValue(value="During which time in seconds to count the number of times the player failed the check?")})
                public int PROGRESSION_MAX_TIME = 86400;
                @NewLine
                @Comment(value={@CommentValue(value="If a player with one IP address fails all checks while never trying to connect from other nicknames, then block for this number of seconds."), @CommentValue(value="The first value is how many bans must be in order to use the second value."), @CommentValue(value="The second value is how many seconds the ban should be."), @CommentValue(value="The number of bans at a time should always increase by one. Wrong: 1, 2, 5, 7. Correct: 1, 2, 3, 4, 5, 6, 7."), @CommentValue(value="You can add as many progressive bans as you like.")})
                @MapType(value=LinkedHashMap.class)
                public Map<String, Integer> SAME_NICKNAME_PROGRESSION = new LinkedHashMap<String, Integer>();
                @NewLine
                @Comment(value={@CommentValue(value="If a player with the same IP address fails all checks, and each time he tries to connect from different nicknames, then block for this number of seconds."), @CommentValue(value="The first value is how many bans must be in order to use the second value."), @CommentValue(value="The second value is how many seconds the ban should be."), @CommentValue(value="The number of bans at a time should always increase by one. Wrong: 1, 2, 5, 7. Correct: 1, 2, 3, 4, 5, 6, 7."), @CommentValue(value="You can add as many progressive bans as you like.")})
                @MapType(value=LinkedHashMap.class)
                public Map<String, Integer> DIFFERENT_NICKNAME_PROGRESSION;

                public PROGRESSION() {
                    this.SAME_NICKNAME_PROGRESSION.put("1", 60);
                    this.SAME_NICKNAME_PROGRESSION.put("2", 120);
                    this.SAME_NICKNAME_PROGRESSION.put("3", 300);
                    this.SAME_NICKNAME_PROGRESSION.put("4", 600);
                    this.SAME_NICKNAME_PROGRESSION.put("5", 1200);
                    this.DIFFERENT_NICKNAME_PROGRESSION = new LinkedHashMap<String, Integer>();
                    this.DIFFERENT_NICKNAME_PROGRESSION.put("1", 180);
                    this.DIFFERENT_NICKNAME_PROGRESSION.put("2", 600);
                    this.DIFFERENT_NICKNAME_PROGRESSION.put("3", 1200);
                    this.DIFFERENT_NICKNAME_PROGRESSION.put("4", 3600);
                    this.DIFFERENT_NICKNAME_PROGRESSION.put("5", 7200);
                }
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for protection modes."), @CommentValue, @CommentValue(value="What type of mode template should the proxy server use?"), @CommentValue(value="See modes-templates to see or customize the current mode templates."), @CommentValue, @CommentValue(value="You can add as many templates as you want in a row.")})
        public static class MODES {
            public JAVA JAVA = new JAVA();
            public BEDROCK BEDROCK = new BEDROCK();

            @Comment(value={@CommentValue(value="Configuration for java players modes.")})
            public static class JAVA {
                @Comment(value={@CommentValue(value="Should the proxy use these checks?"), @CommentValue(value="If disabled, the proxy will never connect the player to the filter and will never be able to determine if the server is under bot attack.")})
                public boolean ENABLED = true;
                @NewLine
                @Comment(value={@CommentValue(value="How much time the player will be in-check 1000ms = 1s (Less = better)")})
                public int TIME_OUT = 30000;
                @NewLine
                @Comment(value={@CommentValue(value="Normal mode configuration."), @CommentValue(value="If the attack was not detected, then the proxy uses this mode.")})
                @CollectionType(value=ArrayList.class)
                public List<String> NORMAL = Arrays.asList("attributes", "fast-empty", "fast-fall");
                @NewLine
                @Comment(value={@CommentValue(value="On attack mode configuration."), @CommentValue(value="If the proxy has detected an attack, then it uses this mode.")})
                @CollectionType(value=ArrayList.class)
                public List<String> ON_ATTACK = Arrays.asList("attributes", "empty", "fall", "country");
                @NewLine
                @Comment(value={@CommentValue(value="Configuration for custom modes."), @CommentValue(value="These modes are only used when the custom mode is enabled with the /antibot toggle custom command."), @CommentValue(value="With the /antibot check custom command, you can specify one of these modes so that it will be used later when the custom mode is switched.")})
                @MapType(value=LinkedHashMap.class)
                public Map<String, List<String>> CUSTOM = new LinkedHashMap<String, List<String>>();

                public JAVA() {
                    this.CUSTOM.put("example", Collections.singletonList("fast-fall"));
                }
            }

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for bedrock players modes.")})
            public static class BEDROCK {
                @Comment(value={@CommentValue(value="Should the proxy use these checks?"), @CommentValue(value="If disabled, the proxy will never connect the player to the filter and will never be able to determine if the server is under bot attack.")})
                public boolean ENABLED = true;
                @NewLine
                @Comment(value={@CommentValue(value="How much time the player will be in-check 1000ms = 1s (Less = better)")})
                public int TIME_OUT = 30000;
                @NewLine
                @Comment(value={@CommentValue(value="Normal mode configuration."), @CommentValue(value="If the attack was not detected, then the proxy uses this mode.")})
                @CollectionType(value=ArrayList.class)
                public List<String> NORMAL = Arrays.asList("attributes", "fast-empty");
                @NewLine
                @Comment(value={@CommentValue(value="On attack mode configuration."), @CommentValue(value="If the proxy has detected an attack, then it uses this mode.")})
                @CollectionType(value=ArrayList.class)
                public List<String> ON_ATTACK = Arrays.asList("attributes", "fast-empty");
                @NewLine
                @Comment(value={@CommentValue(value="Configuration for custom modes."), @CommentValue(value="These modes are only used when the custom mode is enabled with the /antibot toggle custom command."), @CommentValue(value="With the /antibot check custom command, you can specify one of these modes so that it will be used later when the custom mode is switched.")})
                @MapType(value=LinkedHashMap.class)
                public Map<String, List<String>> CUSTOM = new LinkedHashMap<String, List<String>>();

                public BEDROCK() {
                    this.CUSTOM.put("example", Collections.singletonList("fast-empty"));
                }
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for bot attack detection")})
        public static class BOT_ATTACK_DETECTION {
            @Comment(value={@CommentValue(value="This function turns on the under attack mode if more players than this value have connected to the filter for a certain amount of time."), @CommentValue(value="This depends on your server, more traffic = more threshold limit.")})
            public int BOT_THRESHOLD = 30;
            @NewLine
            @Comment(value={@CommentValue(value="How long should it take before checking if the server is under attack in order to reset the bot counter or continue to consider the server under attack. In milliseconds 1 sec = 1000")})
            public int BOT_THRESHOLD_TIME = 60000;
            @NewLine
            @Comment(value={@CommentValue(value="How long is the protection active? In milliseconds 1 sec = 1000")})
            public int BOT_PROTECTION_TIME = 120000;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for modes templates"), @CommentValue, @CommentValue(value="Mode templates provide a convenient way to create different templates with different settings."), @CommentValue(value="Each template has its own type. For now, here is the list of templates:"), @CommentValue, @CommentValue(value="empty - There will be no checks, the player will be on the filter for some time."), @CommentValue, @CommentValue(value="fall - Checking the player for the correct (vanilla) handling of falling from a height."), @CommentValue(value="Useful because the attacker needs to handle a fall from a height correctly in order to pass the check."), @CommentValue, @CommentValue(value="hand-captcha - Shows the player a captcha to be solved. Helps a lot from any bots, since the attacker needs more computing power to solve it very quickly."), @CommentValue, @CommentValue(value="animated-hand-captcha - Exactly the same captcha, except for the animated background. Not recommended for"), @CommentValue(value="use in 'on-attack' mode, as it can consume a lot of traffic during an attack."), @CommentValue(value="Warning! This captcha can use a lot of RAM, it directly depends on the number of frames in the gif file."), @CommentValue, @CommentValue(value="framed-captcha - Captcha based on the frames in which the maps are placed and represent the whole image."), @CommentValue(value="The player can rotate it. It is much more difficult for an attacker to solve it, especially if some parts of the image were initially rotated in a different direction from the generator."), @CommentValue(value="Warning! This captcha can use a lot of RAM, it directly depends on the number of frames configured in captcha.yml."), @CommentValue, @CommentValue(value="animated-framed-captcha - Exactly the same framed captcha, except for the animated background."), @CommentValue(value="Warning! Do not use a huge number of animation frames and a high refresh rate, otherwise it will greatly affect the server traffic!"), @CommentValue, @CommentValue(value="framed-puzzle - It is a set of images rotated in different directions. The player needs to rotate them to the correct position to get the whole image."), @CommentValue(value="Warning! This captcha can use a lot of RAM, it directly depends on the number of frames configured in captcha.yml."), @CommentValue, @CommentValue(value="animated-framed-puzzle - Exactly the same framed puzzle, except for the animated background."), @CommentValue(value="Warning! Do not use a huge number of animation frames and a high refresh rate, otherwise it will greatly affect the server traffic!"), @CommentValue, @CommentValue(value="pick-captcha - Captcha where you need to click on the images where the specified abstract object is shown and if they are no longer there, then enter any text in the chat."), @CommentValue(value="It is very similar to re\u0421aptcha or hCaptcha where you have to click on traffic lights."), @CommentValue(value="Warning! This captcha can use a lot of RAM, it directly depends on the number of frames configured in captcha.yml."), @CommentValue, @CommentValue(value="fall-and-hand-captcha - A mix of fall and hand-captcha check. Both checks are performed at the same time."), @CommentValue, @CommentValue(value="fall-and-animated-hand-captcha - A mix of fall and animated-hand-captcha check. Both checks are performed at the same time."), @CommentValue, @CommentValue(value="fall-and-proxy - A mix of fall and proxy check. Both checks are performed at the same time."), @CommentValue, @CommentValue(value="country - Checking the IP address to see if it belongs to the country."), @CommentValue, @CommentValue(value="asn - Checking the IP address to see if it belongs to the ASN."), @CommentValue, @CommentValue(value="proxy - Checking the ip address for belonging to a proxy or vpn."), @CommentValue, @CommentValue(value="attributes - Checking a client nickname or brand for a forbidden sequence of characters."), @CommentValue, @CommentValue(value="Each mode has its own custom name, you can add and name as many modes as you like."), @CommentValue(value="By default, the name of a configurable modes is equal to its type, however, you can change this to your liking."), @CommentValue, @CommentValue(value="If you have any questions about how it works feel free to ask on Discord.")})
        public static class MODES_TEMPLATES {
            @Comment(value={@CommentValue(value="Configuration for empty check mode templates"), @CommentValue, @CommentValue(value="max-check-time - How many milliseconds the player must be in the check before the check ends automatically")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, EMPTY_CHECK_TEMPLATE> EMPTY_CHECK_TEMPLATES = new LinkedHashMap<String, EMPTY_CHECK_TEMPLATE>();
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for fall check mode templates"), @CommentValue, @CommentValue(value="max-check-time - How long should the check last before it ends in ticks (1 tick == 50 ms)"), @CommentValue(value="spawn-height - At what height to spawn the player"), @CommentValue(value="min-height-reset - From what height to automatically teleport the player back"), @CommentValue(value="hit-platform-enabled - Whether to use an advanced fall validation platform"), @CommentValue(value="hit-platform-min-height - What is the minimum platform height?"), @CommentValue(value="hit-platform-max-height - What is the maximum platform height?"), @CommentValue(value="hit-platform-blocks - What platform blocks should the check use? Use the '*' character to enable all available blocks.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, FALL_CHECK_TEMPLATE> FALL_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for hand-captcha check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CAPTCHA_CHECK_TEMPLATE> HAND_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for animated-hand-captcha check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CAPTCHA_CHECK_TEMPLATE> ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for framed-captcha check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CAPTCHA_CHECK_TEMPLATE> FRAMED_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for animated-framed-captcha check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CAPTCHA_CHECK_TEMPLATE> ANIMATED_FRAMED_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for framed-puzzle check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?"), @CommentValue(value="complete-on-chat - Should the check only end when the player enters any text into the chat?"), @CommentValue(value="expect-code - Should the player be expected to enter the correct code shown in the captcha? Works only if complete-on-chat option is enabled.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, PUZZLE_CAPTCHA_CHECK_TEMPLATE> FRAMED_PUZZLE_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for animated-framed-puzzle check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?"), @CommentValue(value="answer-prefix - What text should be written before the answer? This could be a command like /captcha"), @CommentValue(value="complete-on-chat - Should the check only end when the player enters any text into the chat?"), @CommentValue(value="expect-code - Should the player be expected to enter the correct code shown in the captcha? Works only if complete-on-chat option is enabled.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, PUZZLE_CAPTCHA_CHECK_TEMPLATE> ANIMATED_FRAMED_PUZZLE_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for pick-captcha check mode templates"), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?"), @CommentValue(value="answer-prefix - What text should be written before the answer? This could be a command like /captcha")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, CAPTCHA_CHECK_TEMPLATE> PICK_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for fall-and-hand-captcha check mode templates"), @CommentValue, @CommentValue(value="max-check-time - How long should the check last before it ends in ticks (1 tick == 50 ms)"), @CommentValue(value="spawn-height - At what height to spawn the player"), @CommentValue(value="min-height-reset - From what height to automatically teleport the player back"), @CommentValue(value="hit-platform-enabled - Whether to use an advanced fall validation platform"), @CommentValue(value="hit-platform-min-height - What is the minimum platform height?"), @CommentValue(value="hit-platform-max-height - What is the maximum platform height?"), @CommentValue(value="hit-platform-blocks - What platform blocks should the check use? Use the '*' character to enable all available blocks."), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, FALL_AND_CAPTCHA_TEMPLATE> FALL_AND_HAND_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for fall-and-animated-hand-captcha check mode templates"), @CommentValue, @CommentValue(value="max-check-time - How long should the check last before it ends in ticks (1 tick == 50 ms)"), @CommentValue(value="spawn-height - At what height to spawn the player"), @CommentValue(value="min-height-reset - From what height to automatically teleport the player back"), @CommentValue(value="hit-platform-enabled - Whether to use an advanced fall validation platform"), @CommentValue(value="hit-platform-min-height - What is the minimum platform height?"), @CommentValue(value="hit-platform-max-height - What is the maximum platform height?"), @CommentValue(value="hit-platform-blocks - What platform blocks should the check use? Use the '*' character to enable all available blocks."), @CommentValue, @CommentValue(value="max-attempts - How many attempts will a player have to enter a captcha before they get kicked?"), @CommentValue(value="max-solves - At least how many times must a player enter the captcha correctly to complete the check?"), @CommentValue(value="new-captcha-on-fail - Should the proxy send a new captcha if the player entered the captcha incorrectly?"), @CommentValue(value="answer-prefix - What text should be written before the answer? This could be a command like /captcha")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, FALL_AND_CAPTCHA_TEMPLATE> FALL_AND_ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for fall-and-proxy check mode templates"), @CommentValue, @CommentValue(value="max-check-time - How long should the check last before it ends in ticks (1 tick == 50 ms)"), @CommentValue(value="spawn-height - At what height to spawn the player"), @CommentValue(value="min-height-reset - From what height to automatically teleport the player back"), @CommentValue(value="hit-platform-enabled - Whether to use an advanced fall validation platform"), @CommentValue(value="hit-platform-min-height - What is the minimum platform height?"), @CommentValue(value="hit-platform-max-height - What is the maximum platform height?"), @CommentValue(value="hit-platform-blocks - What platform blocks should the check use? Use the '*' character to enable all available blocks.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, FALL_AND_PROXY_TEMPLATE> FALL_AND_PROXY_CHECK_TEMPLATES;
            @CollectionType(value=ArrayList.class)
            public List<String> COUNTRY_CHECK_TEMPLATES;
            @CollectionType(value=ArrayList.class)
            public List<String> ASN_CHECK_TEMPLATES;
            @CollectionType(value=ArrayList.class)
            public List<String> PROXY_CHECK_TEMPLATE;
            @CollectionType(value=ArrayList.class)
            public List<String> ATTRIBUTES_CHECK_TEMPLATE;

            public MODES_TEMPLATES() {
                this.EMPTY_CHECK_TEMPLATES.put("empty", new EMPTY_CHECK_TEMPLATE());
                this.EMPTY_CHECK_TEMPLATES.put("fast-empty", new EMPTY_CHECK_TEMPLATE(1000));
                this.FALL_CHECK_TEMPLATES = new LinkedHashMap<String, FALL_CHECK_TEMPLATE>();
                this.FALL_CHECK_TEMPLATES.put("fall", new FALL_CHECK_TEMPLATE());
                this.FALL_CHECK_TEMPLATES.put("fast-fall", new FALL_CHECK_TEMPLATE(100, 200, 140, true, 180, 190, Collections.singletonList("*")));
                this.FALL_CHECK_TEMPLATES.put("fast-fall-snow", new FALL_CHECK_TEMPLATE(100, 200, 140, true, 180, 190, Arrays.asList("SNOW_LAYER_1", "SNOW_LAYER_2", "SNOW_LAYER_3", "SNOW_LAYER_4", "SNOW_LAYER_5", "SNOW_LAYER_6", "SNOW_LAYER_7", "SNOW_LAYER_8")));
                this.FALL_CHECK_TEMPLATES.put("on-successful-fast-fall", new FALL_CHECK_TEMPLATE(100, 200, 140, true, 180, 190, Collections.singletonList("*")));
                this.FALL_CHECK_TEMPLATES.put("fast-fall-no-hit", new FALL_CHECK_TEMPLATE(100, 200, 40, false, 0, 0, Collections.singletonList("*")));
                this.HAND_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, CAPTCHA_CHECK_TEMPLATE>();
                this.HAND_CAPTCHA_CHECK_TEMPLATES.put("hand-captcha", new CAPTCHA_CHECK_TEMPLATE());
                this.ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, CAPTCHA_CHECK_TEMPLATE>();
                this.ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES.put("animated-hand-captcha", new CAPTCHA_CHECK_TEMPLATE());
                this.FRAMED_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, CAPTCHA_CHECK_TEMPLATE>();
                this.FRAMED_CAPTCHA_CHECK_TEMPLATES.put("framed-captcha", new CAPTCHA_CHECK_TEMPLATE());
                this.ANIMATED_FRAMED_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, CAPTCHA_CHECK_TEMPLATE>();
                this.ANIMATED_FRAMED_CAPTCHA_CHECK_TEMPLATES.put("animated-framed-captcha", new CAPTCHA_CHECK_TEMPLATE());
                this.FRAMED_PUZZLE_CHECK_TEMPLATES = new LinkedHashMap<String, PUZZLE_CAPTCHA_CHECK_TEMPLATE>();
                this.FRAMED_PUZZLE_CHECK_TEMPLATES.put("framed-puzzle", new PUZZLE_CAPTCHA_CHECK_TEMPLATE());
                this.ANIMATED_FRAMED_PUZZLE_CHECK_TEMPLATES = new LinkedHashMap<String, PUZZLE_CAPTCHA_CHECK_TEMPLATE>();
                this.ANIMATED_FRAMED_PUZZLE_CHECK_TEMPLATES.put("animated-framed-puzzle", new PUZZLE_CAPTCHA_CHECK_TEMPLATE());
                this.PICK_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, CAPTCHA_CHECK_TEMPLATE>();
                this.PICK_CAPTCHA_CHECK_TEMPLATES.put("pick-captcha", new CAPTCHA_CHECK_TEMPLATE());
                this.FALL_AND_HAND_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, FALL_AND_CAPTCHA_TEMPLATE>();
                this.FALL_AND_HAND_CAPTCHA_CHECK_TEMPLATES.put("fall-and-hand-captcha", new FALL_AND_CAPTCHA_TEMPLATE());
                this.FALL_AND_ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES = new LinkedHashMap<String, FALL_AND_CAPTCHA_TEMPLATE>();
                this.FALL_AND_ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES.put("fall-and-animated-hand-captcha", new FALL_AND_CAPTCHA_TEMPLATE());
                this.FALL_AND_PROXY_CHECK_TEMPLATES = new LinkedHashMap<String, FALL_AND_PROXY_TEMPLATE>();
                this.FALL_AND_PROXY_CHECK_TEMPLATES.put("fall-and-proxy", new FALL_AND_PROXY_TEMPLATE());
                this.FALL_AND_PROXY_CHECK_TEMPLATES.put("fast-fall-and-proxy", new FALL_AND_PROXY_TEMPLATE(100, 200, 140, true, 170, 190, Collections.singletonList("*")));
                this.COUNTRY_CHECK_TEMPLATES = Arrays.asList("country", "country-with-condition");
                this.ASN_CHECK_TEMPLATES = Collections.singletonList("asn");
                this.PROXY_CHECK_TEMPLATE = Collections.singletonList("proxy");
                this.ATTRIBUTES_CHECK_TEMPLATE = Arrays.asList("nickname", "attributes");
            }

            public static class EMPTY_CHECK_TEMPLATE {
                public int MAX_CHECK_TIME = 5000;

                public EMPTY_CHECK_TEMPLATE() {
                }

                public EMPTY_CHECK_TEMPLATE(int MAX_CHECK_TIME) {
                    this.MAX_CHECK_TIME = MAX_CHECK_TIME;
                }
            }

            public static class FALL_CHECK_TEMPLATE {
                public int MAX_CHECK_TIME = 300;
                public int SPAWN_HEIGHT = 200;
                public int MIN_HEIGHT_RESET = 40;
                public boolean HIT_PLATFORM_ENABLED = true;
                public int HIT_PLATFORM_MIN_HEIGHT = 60;
                public int HIT_PLATFORM_MAX_HEIGHT = 190;
                @CollectionType(value=ArrayList.class)
                public List<String> HIT_PLATFORM_BLOCKS = Collections.singletonList("*");

                public FALL_CHECK_TEMPLATE() {
                }

                public FALL_CHECK_TEMPLATE(int MAX_CHECK_TIME, int SPAWN_HEIGHT, int MIN_HEIGHT_RESET, boolean HIT_PLATFORM_ENABLED, int HIT_PLATFORM_MIN_HEIGHT, int HIT_PLATFORM_MAX_HEIGHT, List<String> HIT_PLATFORM_BLOCKS) {
                    this.MAX_CHECK_TIME = MAX_CHECK_TIME;
                    this.SPAWN_HEIGHT = SPAWN_HEIGHT;
                    this.MIN_HEIGHT_RESET = MIN_HEIGHT_RESET;
                    this.HIT_PLATFORM_ENABLED = HIT_PLATFORM_ENABLED;
                    this.HIT_PLATFORM_MIN_HEIGHT = HIT_PLATFORM_MIN_HEIGHT;
                    this.HIT_PLATFORM_MAX_HEIGHT = HIT_PLATFORM_MAX_HEIGHT;
                    this.HIT_PLATFORM_BLOCKS = HIT_PLATFORM_BLOCKS;
                }
            }

            public static class CAPTCHA_CHECK_TEMPLATE {
                public int MAX_ATTEMPTS = 3;
                public int MAX_SOLVES = 1;
                public boolean NEW_CAPTCHA_ON_FAIL = true;
                public String ANSWER_PREFIX = "";

                public CAPTCHA_CHECK_TEMPLATE() {
                }

                public CAPTCHA_CHECK_TEMPLATE(int MAX_ATTEMPTS, int MAX_SOLVES, boolean NEW_CAPTCHA_ON_FAIL, String ANSWER_PREFIX) {
                    this.MAX_ATTEMPTS = MAX_ATTEMPTS;
                    this.MAX_SOLVES = MAX_SOLVES;
                    this.NEW_CAPTCHA_ON_FAIL = NEW_CAPTCHA_ON_FAIL;
                    this.ANSWER_PREFIX = ANSWER_PREFIX;
                }
            }

            public static class PUZZLE_CAPTCHA_CHECK_TEMPLATE {
                public int MAX_ATTEMPTS = 1;
                public int MAX_SOLVES = 1;
                public boolean NEW_CAPTCHA_ON_FAIL = true;
                public String ANSWER_PREFIX = "";
                public boolean COMPLETE_ON_CHAT = true;
                public boolean EXPECT_CODE = false;

                public PUZZLE_CAPTCHA_CHECK_TEMPLATE() {
                }

                public PUZZLE_CAPTCHA_CHECK_TEMPLATE(int MAX_ATTEMPTS, int MAX_SOLVES, boolean NEW_CAPTCHA_ON_FAIL, String ANSWER_PREFIX, boolean COMPLETE_ON_CHAT, boolean EXPECT_CODE) {
                    this.MAX_ATTEMPTS = MAX_ATTEMPTS;
                    this.MAX_SOLVES = MAX_SOLVES;
                    this.NEW_CAPTCHA_ON_FAIL = NEW_CAPTCHA_ON_FAIL;
                    this.ANSWER_PREFIX = ANSWER_PREFIX;
                    this.COMPLETE_ON_CHAT = COMPLETE_ON_CHAT;
                    this.EXPECT_CODE = EXPECT_CODE;
                }
            }

            public static class FALL_AND_CAPTCHA_TEMPLATE {
                public int MAX_CHECK_TIME = 300;
                public int SPAWN_HEIGHT = 200;
                public int MIN_HEIGHT_RESET = 40;
                public boolean HIT_PLATFORM_ENABLED = true;
                public int HIT_PLATFORM_MIN_HEIGHT = 60;
                public int HIT_PLATFORM_MAX_HEIGHT = 190;
                @CollectionType(value=ArrayList.class)
                public List<String> HIT_PLATFORM_BLOCKS = Collections.singletonList("*");
                public int MAX_ATTEMPTS = 3;
                public int MAX_SOLVES = 1;
                public boolean NEW_CAPTCHA_ON_FAIL = true;
                public String ANSWER_PREFIX = "";

                public FALL_AND_CAPTCHA_TEMPLATE() {
                }

                public FALL_AND_CAPTCHA_TEMPLATE(int MAX_CHECK_TIME, int SPAWN_HEIGHT, int MIN_HEIGHT_RESET, boolean HIT_PLATFORM_ENABLED, int HIT_PLATFORM_MIN_HEIGHT, int HIT_PLATFORM_MAX_HEIGHT, List<String> HIT_PLATFORM_BLOCKS, int MAX_ATTEMPTS, int MAX_SOLVES, boolean NEW_CAPTCHA_ON_FAIL, String ANSWER_PREFIX) {
                    this.MAX_CHECK_TIME = MAX_CHECK_TIME;
                    this.SPAWN_HEIGHT = SPAWN_HEIGHT;
                    this.MIN_HEIGHT_RESET = MIN_HEIGHT_RESET;
                    this.HIT_PLATFORM_ENABLED = HIT_PLATFORM_ENABLED;
                    this.HIT_PLATFORM_MIN_HEIGHT = HIT_PLATFORM_MIN_HEIGHT;
                    this.HIT_PLATFORM_MAX_HEIGHT = HIT_PLATFORM_MAX_HEIGHT;
                    this.HIT_PLATFORM_BLOCKS = HIT_PLATFORM_BLOCKS;
                    this.MAX_ATTEMPTS = MAX_ATTEMPTS;
                    this.MAX_SOLVES = MAX_SOLVES;
                    this.NEW_CAPTCHA_ON_FAIL = NEW_CAPTCHA_ON_FAIL;
                    this.ANSWER_PREFIX = ANSWER_PREFIX;
                }
            }

            public static class FALL_AND_PROXY_TEMPLATE {
                public int MAX_CHECK_TIME = 300;
                public int SPAWN_HEIGHT = 200;
                public int MIN_HEIGHT_RESET = 40;
                public boolean HIT_PLATFORM_ENABLED = true;
                public int HIT_PLATFORM_MIN_HEIGHT = 60;
                public int HIT_PLATFORM_MAX_HEIGHT = 190;
                @CollectionType(value=ArrayList.class)
                public List<String> HIT_PLATFORM_BLOCKS = Collections.singletonList("*");

                public FALL_AND_PROXY_TEMPLATE() {
                }

                public FALL_AND_PROXY_TEMPLATE(int MAX_CHECK_TIME, int SPAWN_HEIGHT, int MIN_HEIGHT_RESET, boolean HIT_PLATFORM_ENABLED, int HIT_PLATFORM_MIN_HEIGHT, int HIT_PLATFORM_MAX_HEIGHT, List<String> HIT_PLATFORM_BLOCKS) {
                    this.MAX_CHECK_TIME = MAX_CHECK_TIME;
                    this.SPAWN_HEIGHT = SPAWN_HEIGHT;
                    this.MIN_HEIGHT_RESET = MIN_HEIGHT_RESET;
                    this.HIT_PLATFORM_ENABLED = HIT_PLATFORM_ENABLED;
                    this.HIT_PLATFORM_MIN_HEIGHT = HIT_PLATFORM_MIN_HEIGHT;
                    this.HIT_PLATFORM_MAX_HEIGHT = HIT_PLATFORM_MAX_HEIGHT;
                    this.HIT_PLATFORM_BLOCKS = HIT_PLATFORM_BLOCKS;
                }
            }
        }

        public static class CONDITION_CHECK {
            public String IF_SUCCESS = "next";
            public String IF_FAILED = "kick";
            public boolean CHECK_PING_ON_COMPLETE = true;
            public boolean RESET_PING_ON_COMPLETE = true;

            public CONDITION_CHECK() {
            }

            public CONDITION_CHECK(String IF_SUCCESS, String IF_FAILED, boolean CHECK_PING_ON_COMPLETE, boolean RESET_PING_ON_COMPLETE) {
                this.IF_SUCCESS = IF_SUCCESS;
                this.IF_FAILED = IF_FAILED;
                this.CHECK_PING_ON_COMPLETE = CHECK_PING_ON_COMPLETE;
                this.RESET_PING_ON_COMPLETE = RESET_PING_ON_COMPLETE;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CONDITION_CHECK)) {
                    return false;
                }
                CONDITION_CHECK other = (CONDITION_CHECK)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.CHECK_PING_ON_COMPLETE != other.CHECK_PING_ON_COMPLETE) {
                    return false;
                }
                if (this.RESET_PING_ON_COMPLETE != other.RESET_PING_ON_COMPLETE) {
                    return false;
                }
                String this$IF_SUCCESS = this.IF_SUCCESS;
                String other$IF_SUCCESS = other.IF_SUCCESS;
                if (this$IF_SUCCESS == null ? other$IF_SUCCESS != null : !this$IF_SUCCESS.equals(other$IF_SUCCESS)) {
                    return false;
                }
                String this$IF_FAILED = this.IF_FAILED;
                String other$IF_FAILED = other.IF_FAILED;
                return !(this$IF_FAILED == null ? other$IF_FAILED != null : !this$IF_FAILED.equals(other$IF_FAILED));
            }

            protected boolean canEqual(Object other) {
                return other instanceof CONDITION_CHECK;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.CHECK_PING_ON_COMPLETE ? 79 : 97);
                result = result * 59 + (this.RESET_PING_ON_COMPLETE ? 79 : 97);
                String $IF_SUCCESS = this.IF_SUCCESS;
                result = result * 59 + ($IF_SUCCESS == null ? 43 : $IF_SUCCESS.hashCode());
                String $IF_FAILED = this.IF_FAILED;
                result = result * 59 + ($IF_FAILED == null ? 43 : $IF_FAILED.hashCode());
                return result;
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for country limiter."), @CommentValue, @CommentValue(value="For this function to work you need to add 'country' template name to modes."), @CommentValue(value="For example add 'country' to 'on-attack' mode to the very end so to make this check work after the others.")})
        public static class COUNTRY_LIMITER_CHECK {
            @Comment(value={@CommentValue(value="Whether to use a fast cache check at the moment when the player is just connecting to the server?"), @CommentValue(value="Allows you to block the address before the player connects to the filter.")})
            public boolean USE_FAST_CACHE_CHECK = false;
            @NewLine
            @Comment(value={@CommentValue(value="How long will the result of the check be cached in milliseconds?")})
            public int MAX_CACHE_TIME = 86400000;
            @NewLine
            @Comment(value={@CommentValue(value="After how many days to download a new database?")})
            public int MAX_DATABASE_TIME = 3;
            @NewLine
            @Comment(value={@CommentValue(value="How often to check the database is up to date in minutes?"), @CommentValue(value="Use -1 to disable check.")})
            public int DATABASE_CHECK_TIME = 60;
            @NewLine
            @Comment(value={@CommentValue(value="How long to wait for a database download in milliseconds?")})
            public int DOWNLOAD_CONNECTION_TIMEOUT = 15000;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for api url")})
            public API_URL API_URL = new API_URL();
            @NewLine
            @Comment(value={@CommentValue(value="What type of whitelist to use?"), @CommentValue(value="true - All countries that are not listed are blocked"), @CommentValue(value="false - All countries that are listed are blocked")})
            public boolean WHITELIST = true;
            @NewLine
            @Comment(value={@CommentValue(value="Which countries should be used for verification?"), @CommentValue(value="The name of the indicated countries must be according to the international standard."), @CommentValue(value="More on wikipedia https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes")})
            @CollectionType(value=ArrayList.class)
            public List<String> COUNTRIES = Arrays.asList("ES", "EN", "US");
            @NewLine
            @Comment(value={@CommentValue(value="What IP addresses should be ignored?")})
            public IpAddresses IGNORED_IPS = new IpAddresses(Arrays.asList("127.0.0.1/24", "172.18.0.1/24"));
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy blacklist the IP address if the country was blacklisted? Works only when connecting to a filter.")})
            public boolean BLACKLIST_ADDRESS_IF_DETECTED = false;
            @NewLine
            @Comment(value={@CommentValue(value="How many threads to use for concurrent database access?"), @CommentValue(value="Use -1 to use as many threads as the number of cores on the processor.")})
            public int THREAD_POOL_SIZE = -1;

            public static class API_URL {
                @Comment(value={@CommentValue(value="Should we use the database from shieldcommunity? If you don't have your own key, you can download our database.")})
                public boolean USE_SHIELDCOMMUNITY_DATABASE = true;
                @NewLine
                @Comment(value={@CommentValue(value="Key for downloading the MaxMind database. Ignored if use-shieldcommunity-database is used.")})
                public String LICENSE_KEY = "YOUR_LICENSE_KEY";
                @NewLine
                @Comment(value={@CommentValue(value="Where should the proxy download the country database from? Ignored if use-shieldcommunity-database is used."), @CommentValue(value="By default, the database is downloaded from the official MaxMind server")})
                public String DATABASE_DOWNLOAD_URL = "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-Country&license_key=%license_key%&suffix=tar.gz";
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for asn limiter."), @CommentValue, @CommentValue(value="For this function to work you need to add 'asn' template name to modes."), @CommentValue(value="For example add 'asn' to 'on-attack' mode to the very end so to make this check work after the others.")})
        public static class ASN_LIMITER_CHECK {
            @Comment(value={@CommentValue(value="Whether to use a fast cache check at the moment when the player is just connecting to the server?"), @CommentValue(value="Allows you to block the address before the player connects to the filter.")})
            public boolean USE_FAST_CACHE_CHECK = false;
            @NewLine
            @Comment(value={@CommentValue(value="How long will the result of the check be cached in milliseconds?")})
            public int MAX_CACHE_TIME = 86400000;
            @NewLine
            @Comment(value={@CommentValue(value="After how many days to download a new database?")})
            public int MAX_DATABASE_TIME = 3;
            @NewLine
            @Comment(value={@CommentValue(value="How often to check the database is up to date in minutes?"), @CommentValue(value="Use -1 to disable check.")})
            public int DATABASE_CHECK_TIME = 60;
            @NewLine
            @Comment(value={@CommentValue(value="How long to wait for a database download in milliseconds?")})
            public int DOWNLOAD_CONNECTION_TIMEOUT = 15000;
            @NewLine
            @Comment(value={@CommentValue(value="Configuration for api url")})
            public API_URL API_URL = new API_URL();
            @NewLine
            @Comment(value={@CommentValue(value="What type of whitelist to use?"), @CommentValue(value="true - All asns that are not listed are blocked"), @CommentValue(value="false - All asns that are listed are blocked")})
            public boolean WHITELIST = false;
            @NewLine
            @Comment(value={@CommentValue(value="Which asns should be used for verification?")})
            @CollectionType(value=ArrayList.class)
            public List<Long> ASNS = Arrays.asList(16276L, 24940L, 15169L, 32934L);
            @NewLine
            @Comment(value={@CommentValue(value="What IP addresses should be ignored?")})
            public IpAddresses IGNORED_IPS = new IpAddresses(Arrays.asList("127.0.0.1/24", "172.18.0.1/24"));
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy blacklist the IP address if the asn was blacklisted? Works only when connecting to a filter.")})
            public boolean BLACKLIST_ADDRESS_IF_DETECTED = false;
            @NewLine
            @Comment(value={@CommentValue(value="How many threads to use for concurrent database access?"), @CommentValue(value="Use -1 to use as many threads as the number of cores on the processor.")})
            public int THREAD_POOL_SIZE = -1;

            public static class API_URL {
                @Comment(value={@CommentValue(value="Should we use the database from shieldcommunity? If you don't have your own key, you can download our database.")})
                public boolean USE_SHIELDCOMMUNITY_DATABASE = true;
                @NewLine
                @Comment(value={@CommentValue(value="Key for downloading the MaxMind database. Ignored if use-shieldcommunity-database is used.")})
                public String LICENSE_KEY = "YOUR_LICENSE_KEY";
                @NewLine
                @Comment(value={@CommentValue(value="Where should the proxy download the asn database from? Ignored if use-shieldcommunity-database is used."), @CommentValue(value="By default, the database is downloaded from the official MaxMind server")})
                public String DATABASE_DOWNLOAD_URL = "https://download.maxmind.com/app/geoip_download?edition_id=GeoLite2-ASN&license_key=%license_key%&suffix=tar.gz";
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for anti proxy check."), @CommentValue, @CommentValue(value="For this function to work you need to add 'proxy' template name to modes."), @CommentValue(value="For example add 'proxy' to 'on-attack' mode to the very end so to make this check work after the others.")})
        public static class ANTI_PROXY_CHECK {
            @Comment(value={@CommentValue(value="Whether to use a fast cache check at the moment when the player is just connecting to the server?"), @CommentValue(value="Allows you to block the address before the player connects to the filter.")})
            public boolean USE_FAST_CACHE_CHECK = true;
            @NewLine
            @Comment(value={@CommentValue(value="How long will the result of the check be cached in milliseconds?")})
            public int MAX_CACHE_TIME = 86400000;
            @NewLine
            @Comment(value={@CommentValue(value="What IP addresses should be ignored?")})
            public IpAddresses IGNORED_IPS = new IpAddresses(Arrays.asList("127.0.0.1/24", "172.18.0.1/24"));
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy blacklist the IP address if the service detects it as a proxy? Works only when connecting to a filter.")})
            public boolean BLACKLIST_ADDRESS_IF_DETECTED = false;
            @NewLine
            @Comment(value={@CommentValue(value="If enabled and if an error occurs during validation, the player will not be kicked and their ip address will be considered trusted."), @CommentValue(value="Can be useful if you have a rate-limit but want players to be able to connect to the server anyway.")})
            public boolean DO_NOT_KICK_IF_ERROR = false;
            @NewLine
            @Comment(value={@CommentValue(value="How many concurrently open connections should be used to access services?"), @CommentValue(value="The more threads, the faster, in theory, the proxy will be able to check the players, but on the other hand, due to the large number of requests, services can restrict access (rate-limit) to you."), @CommentValue(value="Use -1 to use as many threads as the number of cores on the processor.")})
            public int THREAD_POOL_SIZE = 1;
            public SERVICES SERVICES = new SERVICES();

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for services"), @CommentValue, @CommentValue(value="Here you can configure which services the proxy should connect to in order to check the IP address for a VPN or proxy."), @CommentValue(value="If more than one type of service is enabled, the proxy will try to connect to services according to the order below, and if any service detects the VPN or Proxy, the player will be immediately kicked.")})
            public static class SERVICES {
                public PROXY_CHECK_IO PROXY_CHECK_IO = new PROXY_CHECK_IO();
                public IP_HUB_INFO IP_HUB_INFO = new IP_HUB_INFO();
                public VPN_API_INFO VPN_API_INFO = new VPN_API_INFO();
                public CUSTOM CUSTOM = new CUSTOM();

                @Comment(value={@CommentValue(value="Configuration for ProxyCheck.io service")})
                public static class PROXY_CHECK_IO {
                    @Comment(value={@CommentValue(value="Should the proxy use this service?")})
                    public boolean ENABLED = true;
                    @NewLine
                    @Comment(value={@CommentValue(value="Your license key to access the api."), @CommentValue(value="Please note that this service allows you to access the api even if the key is not correct or is specified as 'YOUR_LICENSE_KEY'."), @CommentValue(value="However, in this case, the number of requests is limited.")})
                    public String LICENSE_KEY = "YOUR_LICENSE_KEY";
                    @NewLine
                    @Comment(value={@CommentValue(value="When the vpn flag is set to 0 no VPN check will be performed, only a proxy check."), @CommentValue(value="When the vpn flag is set to 1 we will perform a VPN check on the IP address in addition to a proxy check, any proxy determinations will be shown even if the address is also a VPN due to proxies being considered higher risk."), @CommentValue(value="When the vpn flag is set to 2 we will only perform a VPN check, no proxy check will be performed."), @CommentValue(value="When the vpn flag is set to 3 we will perform both a proxy and VPN check and both answers will be present in the result returned to you, this differs from where a proxy result overwrites the VPN result.")})
                    public int VPN_MODE = 1;
                    @NewLine
                    @Comment(value={@CommentValue(value="What risk in percent should an IP address have in order to consider this address dangerous?")})
                    public int RISK = 66;
                    @NewLine
                    @Comment(value={@CommentValue(value="What is the maximum time the proxy can spend on one request to the service in milliseconds?")})
                    public int CONNECTION_TIMEOUT = 1000;
                }

                @NewLine
                @Comment(value={@CommentValue(value="Configuration for IpHub.info service")})
                public static class IP_HUB_INFO {
                    @Comment(value={@CommentValue(value="Should the proxy use this service?")})
                    public boolean ENABLED = false;
                    @NewLine
                    @Comment(value={@CommentValue(value="Your license key to access the api.")})
                    public String LICENSE_KEY = "YOUR_LICENSE_KEY";
                    @NewLine
                    @Comment(value={@CommentValue(value="What type of blocking to use?"), @CommentValue(value="-1 - Block non-residential IP (hosting provider, proxy, etc.) or non-residential & residential IP"), @CommentValue(value="1 - Block only non-residential IP"), @CommentValue(value="2 - Block only non-residential & residential IP")})
                    public int BLOCK_TYPE = -1;
                    @NewLine
                    @Comment(value={@CommentValue(value="What is the maximum time the proxy can spend on one request to the service in milliseconds?")})
                    public int CONNECTION_TIMEOUT = 1000;
                }

                @NewLine
                @Comment(value={@CommentValue(value="Configuration for VpnApi.io service")})
                public static class VPN_API_INFO {
                    @Comment(value={@CommentValue(value="Should the proxy use this service?")})
                    public boolean ENABLED = false;
                    @NewLine
                    @Comment(value={@CommentValue(value="Your license key to access the api.")})
                    public String LICENSE_KEY = "YOUR_LICENSE_KEY";
                    @NewLine
                    @Comment(value={@CommentValue(value="What type of blocking to use?"), @CommentValue(value="1 - Block vpn, proxy, tor and relay"), @CommentValue(value="2 - Block only vpn"), @CommentValue(value="3 - Block only proxy"), @CommentValue(value="4 - Block only vpn and proxy")})
                    public int BLOCK_TYPE = 1;
                    @NewLine
                    @Comment(value={@CommentValue(value="What is the maximum time the proxy can spend on one request to the service in milliseconds?")})
                    public int CONNECTION_TIMEOUT = 1000;
                }

                @NewLine
                @Comment(value={@CommentValue(value="Configuration for custom service")})
                public static class CUSTOM {
                    @Comment(value={@CommentValue(value="Should the proxy use this service?")})
                    public boolean ENABLED = false;
                    @NewLine
                    @Comment(value={@CommentValue(value="API url for the service."), @CommentValue(value="Available placeholders:"), @CommentValue(value="%ip% - ip address to check")})
                    public String API_URL = "https://your-custom-api/ip/%ip%";
                    @NewLine
                    @Comment(value={@CommentValue(value="What http properties should be sent?"), @CommentValue(value="Available placeholders:"), @CommentValue(value="%ip% - ip address to check")})
                    @CollectionType(value=ArrayList.class)
                    public List<String> REQUEST_PROPERTIES = Collections.singletonList("Accept-Encoding=UTF-8");
                    @NewLine
                    @Comment(value={@CommentValue(value="What character sequence should be in the response to the request so that the proxy considers the IP address to belong to vpn?"), @CommentValue(value="You can use regular expressions here.")})
                    public String DETECT_REGEX_PATTERN = "VPN";
                    @NewLine
                    @Comment(value={@CommentValue(value="What is the maximum time the proxy can spend on one request to the service in milliseconds?")})
                    public int CONNECTION_TIMEOUT = 1000;
                }
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for attributes limiter check"), @CommentValue, @CommentValue(value="For this function to work you need to add 'attributes' template name to modes."), @CommentValue(value="For example add 'attributes' to 'on-attack' mode to the very end so to make this check work after the others.")})
        public static class ATTRIBUTES_LIMITER_CHECK {
            @Comment(value={@CommentValue(value="How many threads should be used to calculate the blacklisted client nickname or brands at the same time?"), @CommentValue(value="Use -1 to use as many threads as the number of cores on the processor.")})
            public int THREAD_POOL_SIZE = 1;
            @NewLine
            @Comment(value={@CommentValue(value="List of blacklisted nicknames in the regex.")})
            @CollectionType(value=ArrayList.class)
            public List<String> NICKNAME_PATTERNS = Collections.singletonList("mcstorm|mcdown|mcbot|theresa_bot|dropbot|bebra_bot|mcspam|kingbot|bot");
            @NewLine
            @Comment(value={@CommentValue(value="List of blacklisted client brands in the regex.")})
            @CollectionType(value=ArrayList.class)
            public List<String> BRAND_PATTERNS = Collections.singletonList("mcstorm|bot");
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for unstable ping check."), @CommentValue, @CommentValue(value="Checks the player's ping during the check, if it is not stable then kicks the player.")})
        public static class UNSTABLE_PING_CHECK {
            @Comment(value={@CommentValue(value="When will the check work?"), @CommentValue(value="-1 - Never"), @CommentValue(value="0 - Just in a bot attack"), @CommentValue(value="1 - Always")})
            public int MODE = 0;
            @NewLine
            @Comment(value={@CommentValue(value="What type of ping check should the proxy use?"), @CommentValue(value="1 - Kick a player if his average ping is greater than the maximum at the time he passed any check."), @CommentValue(value="2 - Kick a player if his average ping is greater than the maximum at the time he passed last check."), @CommentValue(value="3 - Kick a player if at some point his ping becomes greater than the maximum. (without checking average ping)")})
            public int TYPE = 1;
            @NewLine
            @Comment(value={@CommentValue(value="What is the maximum allowed ping in milliseconds?")})
            public int MAX_PING = 350;
            public ADVANCED ADVANCED = new ADVANCED();

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for advanced ping check")})
            public static class ADVANCED {
                @Comment(value={@CommentValue(value="Whether to use advanced ping check?"), @CommentValue(value="The proxy will compare the latency of receiving a packet from the host to the latency of receiving a packet over the network."), @CommentValue(value="This may help against common proxy servers, however this check may falsely trigger on players using mobile internet or poor quality internet."), @CommentValue(value="Warning! This check only works on Linux systems!")})
                public boolean ENABLED = false;
                @NewLine
                @Comment(value={@CommentValue(value="What is the maximum ping difference in milliseconds after which we consider this connection as a proxy?"), @CommentValue(value="The lower the value, the stricter the check, but if most players experience connection problems, we recommend increasing the value or turning off this type of check.")})
                public int MAX_DIFFERENCE = 30;
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for direct connection."), @CommentValue, @CommentValue(value="Will only allow a player to connect if they have pinged the server. Useful if the attacker is attacking with bots that never ping the server in the beginning."), @CommentValue(value="If you are using a reverse proxy, remember to disable this option either will constantly ask for reconnect")})
        public static class DIRECT_CONNECTION_CHECK {
            @Comment(value={@CommentValue(value="When will the check work?"), @CommentValue(value="-1 - Never"), @CommentValue(value="0 - Just in a bot attack"), @CommentValue(value="1 - Always")})
            public int MODE = -1;
            @NewLine
            @Comment(value={@CommentValue(value="How long does it take to clear the player's cache before they have to ping the server again? In seconds.")})
            public int CACHE_TIME = 12;
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy blacklist the IP address if the player didn't ping the server?")})
            public boolean BLACKLIST_ADDRESS_IF_DETECTED = false;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for dimension of checking server")})
        public static class DIMENSION {
            @Comment(value={@CommentValue(value="What type of world dimension use?"), @CommentValue(value="0 - OVERWORLD"), @CommentValue(value="1 - THE_NETHER"), @CommentValue(value="2 - THE_END")})
            public int TYPE = 0;
            @NewLine
            @Comment(value={@CommentValue(value="What time to use? In ticks. (20 tick = 1 second)"), @CommentValue(value="0 is sunrise, 6000 is noon, 12000 is sunset, and 18000 is midnight")})
            public int TIME = 0;
            @NewLine
            @Comment(value={@CommentValue(value="In what position in the inventory should the captcha map be."), @CommentValue(value="Slot positions https://wiki.vg/File:Inventory-slots.png"), @CommentValue(value="Warning! In version 1.8 there is no left hand (45 slot)")})
            public int CAPTCHA_SLOT = 36;
            @NewLine
            @Comment(value={@CommentValue(value="How many empty chunks to send to the client?"), @CommentValue(value="0 - 1 chunk, 1 - 9 chunks, 2 - 16 chunks, 3 = 26 chunks and so on."), @CommentValue(value="Note that a client with the sodium mod will not be able to join if only 1 chunk has been sent.")})
            public int CHUNK_EDGE_SIZE = 1;
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy send the player a levitation effect that will prevent the player from moving up and down?")})
            public boolean LEVITATE_EFFECT = true;
            @NewLine
            @Comment(value={@CommentValue(value="Which game mode to use?"), @CommentValue, @CommentValue(value="Available game modes:"), @CommentValue(value="0 - Survival"), @CommentValue(value="1 - Creative"), @CommentValue(value="2 - Adventure"), @CommentValue(value="3 - Spectator")})
            public int GAME_MODE = 2;
            @NewLine
            @Comment(value={@CommentValue(value="Should the client assume that he has connected to a server where hardcore mode is enabled?")})
            public boolean HARDCORE_MODE = true;
            @NewLine
            @Comment(value={@CommentValue(value="Should the filter send the remaining timeout time as the player's level and experience?")})
            public boolean SEND_EXPERIENCE_BY_TIMEOUT = true;
            public PLAYER_LIST PLAYER_LIST = new PLAYER_LIST();
            public LOCATION LOCATION = new LOCATION();
            public ITEM_FRAME ITEM_FRAME = new ITEM_FRAME();
            public ALLOWED_REGION ALLOWED_REGION = new ALLOWED_REGION();
            public MESSAGES MESSAGES = new MESSAGES();

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for player list")})
            public static class PLAYER_LIST {
                @Comment(value={@CommentValue(value="What nickname to use in the tablist?")})
                public String NAME = "NullCordX";
                @NewLine
                @Comment(value={@CommentValue(value="What ping should this player have?"), @CommentValue(value="A value of -1 will display a missing connection icon.")})
                public int LATENCY = -1;
            }

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for spawn location")})
            public static class LOCATION {
                public double X = 7.5;
                public double Y = 200.0;
                public double Z = 7.5;
            }

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for item frame interaction")})
            public static class ITEM_FRAME {
                @Comment(value={@CommentValue(value="What should be the delay between frame rotations? In milliseconds.")})
                public int MAX_ROTATION_COOLDOWN = 150;
                @NewLine
                @Comment(value={@CommentValue(value="After how many quick attempts to rotate the frame to consider the player a bot?")})
                public int MAX_ROTATION_VIOLATIONS = 5;
                @NewLine
                @Comment(value={@CommentValue(value="How close should the frames be to the player?"), @CommentValue(value="The closer the value is to zero, the further the player is to the frame, and conversely, the higher the value, the closer the frame is.")})
                public double DISTANCE_MODIFIER = 2.0;
                @NewLine
                @Comment(value={@CommentValue(value="WARNING! EXPERIMENTAL!"), @CommentValue(value="What is the threshold for checking the direction of view when interacting with the frame in percent?"), @CommentValue(value="The higher the percentage, the stricter the checking of the player's view direction."), @CommentValue(value="Only allowed values between 0.0 and 1.0."), @CommentValue(value="Recommended value is '0.45'"), @CommentValue(value="Use -1 to disable the check.")})
                public double PLAYER_DIRECTION_THRESHOLD = -1.0;
            }

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for allowed region")})
            public static class ALLOWED_REGION {
                @Comment(value={@CommentValue(value="Whether to enable allowed region?"), @CommentValue(value="Players who leave this area will be teleported back to spawn."), @CommentValue(value="It can be useful if for some reason players leave the spawn location where the framed captcha can be located.")})
                public boolean ENABLED = true;
                @NewLine
                @Comment(value={@CommentValue(value="What is the maximum teleportation possible before a player gets kicked?"), @CommentValue(value="Useful as attackers can try to abuse it.")})
                public int MAX_TELEPORTS = 3;
                @NewLine
                @Comment(value={@CommentValue(value="How big will the cuboid be on the x side?")})
                public int X_SIZE = 5;
                @NewLine
                @Comment(value={@CommentValue(value="How big will the cuboid be on the y side?")})
                public int Y_SIZE = 5;
                @NewLine
                @Comment(value={@CommentValue(value="How big will the cuboid be on the z side?")})
                public int Z_SIZE = 5;
            }

            @NewLine
            @Comment(value={@CommentValue(value="Configuration for messages")})
            public static class MESSAGES {
                @Comment(value={@CommentValue(value="What message type to use?"), @CommentValue(value="0 - Chat"), @CommentValue(value="1 - System"), @CommentValue(value="2 - ActionBar")})
                public int MESSAGE_TYPE = 1;
                @NewLine
                @Comment(value={@CommentValue(value="How often to send checking messages in milliseconds?")})
                public int CHECKING_MESSAGES_DELAY = 2000;
            }
        }
    }
}

