/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class MotdSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).build();
    @Transient
    public static final MotdSettings IMP = new MotdSettings();
    public MOTD MOTD = new MOTD();
    public long CONFIG_VERSION = 1L;

    public MotdSettings() {
        super(Paths.get("NullCordX/motd.yml", new String[0]), CONFIG);
    }

    @Comment(value={@CommentValue(value="Motd cache configuration")})
    public static class MOTD {
        @Comment(value={@CommentValue(value="What type of cache use?"), @CommentValue(value="-1 - None"), @CommentValue(value="0 - Cache motd returned by plugins or BungeeCord (Recommended if you have a custom motd plugin)"), @CommentValue(value="1 - Use full caching configured in 'custom' section (It also ignores ping_passthrough)"), @CommentValue(value="2 - Use full caching by plugins (Combines mode 1 and 0. The proxy will call ProxyPingEvent itself and store the result globally for some time."), @CommentValue(value="The source motd is always taken from the first listener in the BungeeCord configuration, not from 'custom' section)")})
        public int MODE = 1;
        @NewLine
        @Comment(value={@CommentValue(value="What game protocol should be in motd?"), @CommentValue(value="-1 - the game protocol of all available versions of the game is used.")})
        public int PROTOCOL_VERSION = -1;
        @NewLine
        @Comment(value={@CommentValue(value="How long to cache motd or update online counter in milliseconds?")})
        public int MAX_CACHE_TIME = 5000;
        @NewLine
        @Comment(value={@CommentValue(value="Should favicon be hidden when a ping attack is detected?"), @CommentValue(value="Helps to save traffic, because the StatusRequest packet is never compressed, which means it can weigh at least 8 kilobytes.")})
        public boolean HIDE_FAVICON_ON_ATTACK = true;
        @NewLine
        @Comment(value={@CommentValue(value="Close the connection if the client tries to calculate a ping to the server after successfully sending motd during the attack.")})
        public boolean CLOSE_IF_TRY_CALCULATE_PING_ON_ATTACK = true;
        public PING_ATTACK_DETECTION PING_ATTACK_DETECTION = new PING_ATTACK_DETECTION();
        public CUSTOM CUSTOM = new CUSTOM();

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for ping attack detection")})
        public static class PING_ATTACK_DETECTION {
            @Comment(value={@CommentValue(value="This function turns on the attack mode if more than this value is pinged in a certain time."), @CommentValue(value="This depends on your server, more traffic = more threshold limit.")})
            public int PING_THRESHOLD = 500;
            @NewLine
            @Comment(value={@CommentValue(value="How long should it take before checking if the server is under attack in order to reset the ping counter or continue to consider the server under attack. In milliseconds 1 sec = 1000")})
            public int PING_THRESHOLD_TIME = 60000;
            @NewLine
            @Comment(value={@CommentValue(value="How long is the protection active? In milliseconds 1 sec = 1000")})
            public int PING_PROTECTION_TIME = 300000;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for custom motd."), @CommentValue(value="The default format is MiniMessages, which allows RGB colors and gradients."), @CommentValue(value="For more information: https://docs.advntr.dev/minimessage/index.html"), @CommentValue(value="To create a new line use the placeholder {NL}")})
        public static class CUSTOM {
            @Comment(value={@CommentValue(value="Standard motd message."), @CommentValue, @CommentValue(value="Available placeholders:"), @CommentValue(value="{PLAYER_ONLINE} - Current online players."), @CommentValue(value="{PLAYER_ONLINE_MAX} - Max online players. Can be variable if dynamic-max-player-count is enabled")})
            public ReadyComponentMessage MOTD = new ReadyComponentMessage("<blue><bold>Null<aqua><bold>Cord<white><bold>X<reset>{NL}<aqua>YourNetwork motd.");
            @NewLine
            @Comment(value={@CommentValue(value="Maximum number of players")})
            public int MAX_PLAYERS = 20;
            @NewLine
            @Comment(value={@CommentValue(value="Should the maximum number of players be equal to the current online?"), @CommentValue(value="A number greater than zero will be added to the counter, making it look like the player has the last chance to connect to the server. -1 - to disable.")})
            public int DYNAMIC_MAX_PLAYERS_COUNT = -1;
            @NewLine
            @Comment(value={@CommentValue(value="The path to the favicon. Disabled if empty.")})
            public String FAVICON_PATH = "server-icon.png";
            @NewLine
            @Comment(value={@CommentValue(value="How hard to compress the favicon? The closer the value is to zero, the stronger the compression."), @CommentValue(value="Fractional values from 0.0 to 1.0 are allowed. -1 - to disable.")})
            public double FAVICON_COMPRESSION_LEVEL = 0.0;
            @NewLine
            @Comment(value={@CommentValue(value="The name of the server that is displayed if the player tries to ping a server with an old or too new version of the game."), @CommentValue, @CommentValue(value="Available placeholders:"), @CommentValue(value="{PLAYER_ONLINE} - Current online players."), @CommentValue(value="{PLAYER_ONLINE_MAX} - Max online players. Can be variable if dynamic-max-player-count is enabled")})
            public ReadyComponentMessage NAME = new ReadyComponentMessage("<blue><bold>Null<aqua><bold>Cord<white><bold>X<reset>");
            @NewLine
            @Comment(value={@CommentValue(value="What to display when hovering over online numbers? Disabled if empty."), @CommentValue, @CommentValue(value="Available placeholders:"), @CommentValue(value="{PLAYER_ONLINE} - Current online players."), @CommentValue(value="{PLAYER_ONLINE_MAX} - Max online players. Can be variable if dynamic-max-player-count is enabled")})
            @CollectionType(value=ArrayList.class)
            public List<ReadyComponentMessage> PLAYER_INFO = Arrays.asList(new ReadyComponentMessage("<blue><bold>Null<aqua><bold>Cord<white><bold>X<reset>"), new ReadyComponentMessage("<aqua>YourNetwork player info"), new ReadyComponentMessage("<white>Online: <dark_aqua>{PLAYER_ONLINE}<dark_gray>/<aqua>{PLAYER_ONLINE_MAX}"));
        }
    }
}

