/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class SQLSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).build();
    @Transient
    public static final SQLSettings IMP = new SQLSettings();
    public SQL SQL = new SQL();
    public long CONFIG_VERSION = 1L;

    public SQLSettings() {
        super(Paths.get("NullCordX/sql.yml", new String[0]), CONFIG);
    }

    @Comment(value={@CommentValue(value="Configuration for database")})
    public static class SQL {
        @Comment(value={@CommentValue(value="Should the proxy use the database?"), @CommentValue(value="The proxy uses sql databases to store cached players who have successfully passed bot verification so they don't have to re-verify.")})
        public boolean ENABLED = true;
        @NewLine
        @Comment(value={@CommentValue(value="What type of database to use?"), @CommentValue(value="Local databases: SQLite"), @CommentValue(value="External databases: MySQL, PostgreSQL"), @CommentValue(value="If you want to access records from outside use external databases")})
        public String STORAGE_TYPE = "sqlite";
        @NewLine
        public String USERS_TABLE_NAME = "users";
        public String WHITELIST_TABLE_NAME = "whitelist";
        public String PROXIES_TABLE_NAME = "proxies";
        @NewLine
        @Comment(value={@CommentValue(value="How often should the proxy server synchronize the users record in minutes? 0 - to disable."), @CommentValue(value="Useful if multiple instances of the proxy server are used.")})
        public int USERS_SYNC_CHECK_TIME = 0;
        public USERS_PURGE USERS_PURGE = new USERS_PURGE();
        public CONNECTION CONNECTION = new CONNECTION();

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for users purge")})
        public static class USERS_PURGE {
            @Comment(value={@CommentValue(value="How often should the proxy check for old records in minutes? 0 - to disable.")})
            public int PURGE_CHECK_TIME = 120;
            @NewLine
            @Comment(value={@CommentValue(value="How long the record is kept in the database in days?")})
            public int PURGE_TIME = 14;
            @NewLine
            @Comment(value={@CommentValue(value="Should the proxy only delete old records in memory?"), @CommentValue(value="May be useful if multiple proxy servers are used and only one should clean up the database.")})
            public boolean PURGE_ONLY_MEMORY = false;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for external databases")})
        public static class CONNECTION {
            public String HOSTNAME = "127.0.0.1";
            public int PORT = 3306;
            public String USER = "user";
            public String PASSWORD = "password";
            public String DATABASE = "database";
            @NewLine
            @Comment(value={@CommentValue(value="How many threads to use for concurrent database access")})
            public int POOL_SIZE = 2;
            @NewLine
            public int CONNECTION_TIMEOUT = 15000;
            @NewLine
            @Comment(value={@CommentValue(value="What parameters to use to connect to the database")})
            @CollectionType(value=ArrayList.class)
            public List<String> PARAMETERS = Arrays.asList("useSSL=false", "useUnicode=true", "characterEncoding=utf-8", "autoReconnect=true");
        }
    }
}

