/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.bungee;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.MapType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class BungeeCordSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.SNAKE_CASE).registerSerializer(new ReadyComponentMessageSerializer()).build();
    @Transient
    public static final BungeeCordSettings IMP = new BungeeCordSettings();
    @Comment(value={@CommentValue(value="Configuration for listeners"), @CommentValue, @CommentValue(value="query_port - What port to run the UDP query on"), @CommentValue, @CommentValue(value="motd - The message to be displayed in the multiplayer menu when players ping the server"), @CommentValue, @CommentValue(value="tab_list - The tab list has a choice of 3 options:"), @CommentValue(value=" GLOBAL_PING: This shows all players connected to the proxy, complete with ping."), @CommentValue(value=" GLOBAL: As above, but without updating their ping."), @CommentValue(value=" SERVER: This shows the local players on the server you are connected to."), @CommentValue, @CommentValue(value="query_enabled - Whether to enable UDP query."), @CommentValue, @CommentValue(value="proxy_protocol - This allows the server to support the HAProxy PROXY protocol."), @CommentValue(value="Most users shouldn't need to enable this."), @CommentValue, @CommentValue(value="forced_hosts - Allows for redirection."), @CommentValue(value="If the pvp.md-5.net sub-domain of the domain md-5.net is joined, it will bypass the default server and go to the server that is stated in the config, in this case directly to the pvp server."), @CommentValue(value="Note: this requires you to make sub-domains forwarded to your BungeeCord address via the main Dynamic DNS as for your main domain."), @CommentValue, @CommentValue(value="ping_passthrough - Whether to pass the ping through when we can reliably get the target server (force default server)."), @CommentValue(value="When true, Bungee displays the player count and MOTD of the backend server, when the forced hosts are queried."), @CommentValue, @CommentValue(value="priorities - When a player connects for the first time or if force_default_server is enabled then BungeeCord goes through this list of servers from top to bottom and tries to forward the connection to each of them."), @CommentValue(value="So if you would like to support multiple client versions, simply specify at least one server per version and BungeeCord will do the matching for you."), @CommentValue, @CommentValue(value="bind_local_address - Whether the address Bungee uses to connect to your servers will be explicitly set to the address Bungee is listening on."), @CommentValue(value="This serves no purpose unless your system has multiple IP addresses."), @CommentValue, @CommentValue(value="host - The IP and Port in which the BungeeCord instance will be hosted on."), @CommentValue(value="Use 0.0.0.0 to listen to all IPs (recommended)."), @CommentValue, @CommentValue(value="max_players - The max player limit shown in the minecraft client's multiplayer menu."), @CommentValue(value="Note that this limit is fake, you can set it to 0, players will still be able to join. Look at player_limit above for a \"real\" player limit."), @CommentValue, @CommentValue(value="tab_size - The amount of players that will show up in the tab list (Pressing tab on keyboard)"), @CommentValue, @CommentValue(value="force_default_server - If true, the player will always connect to the default servers specified in the priorities list when they join the server."), @CommentValue(value="if false, the player will join the server they were last connected to. Note: forced_hosts does NOT override this."), @CommentValue(value="To make the forced_hosts setting work, set this to false. Should be kept on for cracked server!")})
    @CollectionType(value=ArrayList.class)
    public List<LISTENER> LISTENERS = Collections.singletonList(new LISTENER());
    @NewLine
    @Comment(value={@CommentValue(value="Configuration for servers"), @CommentValue, @CommentValue(value="motd - The message to be displayed in the multiplayer menu when players ping the server."), @CommentValue(value="address - The address of the backend server to which the proxy will try to connect the player"), @CommentValue(value="restricted - Prevents players from joining the server unless they have the bungeecord.server.[servername] permission")})
    @MapType(value=LinkedHashMap.class)
    public Map<String, SERVER> SERVERS = new LinkedHashMap<String, SERVER>();
    @NewLine
    @Comment(value={@CommentValue(value="Whether to enable IP (which forwards the players true IP to Bukkit, rather than the proxy IP) and UUID forwarding (which forwards the players true online-mode UUID to Bukkit, rather than an offline-mode username hash!)"), @CommentValue(value="If you're running an online-mode: true server, It is highly recommended you use this option.")})
    public boolean IP_FORWARD;
    @NewLine
    @Comment(value={@CommentValue(value="This makes the server send the IP of connecting players to Mojang to check if they are using a proxy to connect to the BungeeCord.")})
    public boolean PREVENT_PROXY_CONNECTIONS;
    @NewLine
    @Comment(value={@CommentValue(value="Whether the BungeeCord instance will authenticate with the Mojang servers. If set to false, cracked players will also be able to join your server.")})
    public boolean ONLINE_MODE;
    @NewLine
    @Comment(value={@CommentValue(value="Choose if your BungeeCord instance supports Forge clients or not.")})
    public boolean FORGE_SUPPORT;
    @NewLine
    @Comment(value={@CommentValue(value="Should a proxy reject connections made via transfer? This will prevent the player from connecting if he was sent to this proxy.")})
    public boolean REJECT_TRANSFERS;
    @NewLine
    @Comment(value={@CommentValue(value="When a player ping a BungeeCord server, that ping is also included in the BungeeCord console.")})
    public boolean LOG_PINGS;
    @NewLine
    @Comment(value={@CommentValue(value="When a player writes a BungeeCord command, that command is also included in the BungeeCord console.")})
    public boolean LOG_COMMANDS;
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy always expect a secure profile from a client?")})
    public boolean ENFORCE_SECURE_PROFILE;
    @NewLine
    @Comment(value={@CommentValue(value="After how many milliseconds to close the connection if no packet has been sent?")})
    public int TIMEOUT;
    @NewLine
    @Comment(value={@CommentValue(value="If the packet is larger than this value, it will be compressed. Use -1 to disable compression.")})
    public int NETWORK_COMPRESSION_THRESHOLD;
    @NewLine
    @Comment(value={@CommentValue(value="For how long in milliseconds BungeeCord should use cached results of server pings instead of manually pinging them to get the playercount. (-1 to disable)")})
    public int REMOTE_PING_CACHE;
    @NewLine
    @Comment(value={@CommentValue(value="How long in milliseconds BungeeCord will try to ping a server to get the playercount before cancelling the connection.")})
    public int REMOTE_PING_TIMEOUT;
    @NewLine
    @Comment(value={@CommentValue(value="Once an IP has connected connection_throttle_limit times within connection_throttle milliseconds, it must wait connection_throttle milliseconds before attempting to connect again."), @CommentValue(value="Example: With default settings, an IP may make 6 connection attempts in 4000ms (4s) before the IP is forced to wait 4s before connecting again.")})
    public int CONNECTION_THROTTLE_LIMIT;
    @NewLine
    @Comment(value={@CommentValue(value="The time delay before a client is allowed to connect again after a recent connection attempt to prevent attacks (in milliseconds).")})
    public int CONNECTION_THROTTLE;
    @NewLine
    @Comment(value={@CommentValue(value="How long in milliseconds BungeeCord will try to connect a player to a server before cancelling the connection.")})
    public int SERVER_CONNECT_TIMEOUT;
    @NewLine
    @Comment(value={@CommentValue(value="Global player limit for your BungeeCord instance. If set to 0 or below, this will allow an unlimited amount of users to join.")})
    public int PLAYER_LIMIT;
    @NewLine
    @Comment(value={@CommentValue(value="Use this to disable commands on your BungeeCord instance.")})
    @CollectionType(value=ArrayList.class)
    public List<String> DISABLED_COMMANDS;
    @NewLine
    @Comment(value={@CommentValue(value="These are the permissions of what commands or actions you can use within the proxy."), @CommentValue(value="Please note, that these are different to Bukkit/Spigot permissions."), @CommentValue(value="The permissions are group based and are used to attach players later on in the configuration."), @CommentValue(value="All players will have ability to use the commands under default, those players given the admin group in the groups section are allowed to use the extra commands for BungeeCord as stated below that group."), @CommentValue(value="Note each group only inherits default so you may need to put the same node in different groups if you add more.")})
    @MapType(value=LinkedHashMap.class)
    public Map<String, List<String>> PERMISSIONS;
    @NewLine
    @Comment(value={@CommentValue(value="Here, you can assign players to a permission group that you created earlier in the configuration."), @CommentValue(value="The format is groups, followed by each player, followed by each group they are in."), @CommentValue(value="By default md_5 is given admin group, which gives permissions as defined by permissions section."), @CommentValue(value="Every player has default. Only add players who need more than the default permissions.")})
    @MapType(value=LinkedHashMap.class)
    public Map<String, List<String>> GROUPS;
    @NewLine
    @Comment(value={@CommentValue(value="A unique value used for metrics statistics."), @CommentValue(value="Not used by proxy anywhere, but can be used for plugins.")})
    public String STATS;
    public long CONFIG_VERSION;

    public BungeeCordSettings() {
        super(Paths.get("config.yml", new String[0]), CONFIG);
        this.SERVERS.put("lobby", new SERVER(new ReadyComponentMessage("<blue>Just another NullCordX - Forced Host"), "localhost:25565", false));
        this.IP_FORWARD = false;
        this.PREVENT_PROXY_CONNECTIONS = false;
        this.ONLINE_MODE = false;
        this.FORGE_SUPPORT = false;
        this.REJECT_TRANSFERS = true;
        this.LOG_PINGS = false;
        this.LOG_COMMANDS = false;
        this.ENFORCE_SECURE_PROFILE = false;
        this.TIMEOUT = 20000;
        this.NETWORK_COMPRESSION_THRESHOLD = 256;
        this.REMOTE_PING_CACHE = -1;
        this.REMOTE_PING_TIMEOUT = 5000;
        this.CONNECTION_THROTTLE_LIMIT = 6;
        this.CONNECTION_THROTTLE = 4000;
        this.SERVER_CONNECT_TIMEOUT = 5000;
        this.PLAYER_LIMIT = -1;
        this.DISABLED_COMMANDS = Collections.singletonList("disabledcommandhere");
        this.PERMISSIONS = new LinkedHashMap<String, List<String>>();
        this.PERMISSIONS.put("default", Arrays.asList("bungeecord.command.server", "bungeecord.command.list"));
        this.PERMISSIONS.put("admin", Arrays.asList("bungeecord.command.alert", "bungeecord.command.end", "bungeecord.command.ip", "bungeecord.command.reload", "bungeecord.command.kick", "nullcordx.player", "nullcordx.player.help", "nullcordx.player.stats", "nullcordx.player.livestats.default", "nullcordx.player.livestats.cpu", "nullcordx.player.livestats.network", "nullcordx.player.livestats.upstream_network", "nullcordx.player.livestats.downstream_network"));
        this.GROUPS = new LinkedHashMap<String, List<String>>();
        this.GROUPS.put("md_5", Collections.singletonList("admin"));
        this.STATS = UUID.randomUUID().toString();
        this.CONFIG_VERSION = 1L;
    }

    public static class LISTENER {
        public int QUERY_PORT = 25577;
        public ReadyComponentMessage MOTD = new ReadyComponentMessage("<blue>Another NullCordX server");
        public String TAB_LIST = "GLOBAL_PING";
        public boolean QUERY_ENABLED = false;
        public boolean PROXY_PROTOCOL = false;
        @MapType(value=LinkedHashMap.class)
        public Map<String, String> FORCED_HOSTS = new LinkedHashMap<String, String>();
        public boolean PING_PASSTHROUGH;
        @CollectionType(value=ArrayList.class)
        public List<String> PRIORITIES;
        public boolean BIND_LOCAL_ADDRESS;
        public String HOST;
        public int MAX_PLAYERS;
        public int TAB_SIZE;
        public boolean FORCE_DEFAULT_SERVER;

        public LISTENER() {
            this.FORCED_HOSTS.put("pvp.md-5.net", "pvp");
            this.PING_PASSTHROUGH = false;
            this.PRIORITIES = Collections.singletonList("lobby");
            this.BIND_LOCAL_ADDRESS = true;
            this.HOST = "0.0.0.0:25577";
            this.MAX_PLAYERS = 1;
            this.TAB_SIZE = 60;
            this.FORCE_DEFAULT_SERVER = false;
        }

        public LISTENER(int QUERY_PORT, ReadyComponentMessage MOTD2, String TAB_LIST, boolean QUERY_ENABLED, boolean PROXY_PROTOCOL, Map<String, String> FORCED_HOSTS, boolean PING_PASSTHROUGH, List<String> PRIORITIES, boolean BIND_LOCAL_ADDRESS, String HOST, int MAX_PLAYERS, int TAB_SIZE, boolean FORCE_DEFAULT_SERVER) {
            this.FORCED_HOSTS.put("pvp.md-5.net", "pvp");
            this.PING_PASSTHROUGH = false;
            this.PRIORITIES = Collections.singletonList("lobby");
            this.BIND_LOCAL_ADDRESS = true;
            this.HOST = "0.0.0.0:25577";
            this.MAX_PLAYERS = 1;
            this.TAB_SIZE = 60;
            this.FORCE_DEFAULT_SERVER = false;
            this.QUERY_PORT = QUERY_PORT;
            this.MOTD = MOTD2;
            this.TAB_LIST = TAB_LIST;
            this.QUERY_ENABLED = QUERY_ENABLED;
            this.PROXY_PROTOCOL = PROXY_PROTOCOL;
            this.FORCED_HOSTS = FORCED_HOSTS;
            this.PING_PASSTHROUGH = PING_PASSTHROUGH;
            this.PRIORITIES = PRIORITIES;
            this.BIND_LOCAL_ADDRESS = BIND_LOCAL_ADDRESS;
            this.HOST = HOST;
            this.MAX_PLAYERS = MAX_PLAYERS;
            this.TAB_SIZE = TAB_SIZE;
            this.FORCE_DEFAULT_SERVER = FORCE_DEFAULT_SERVER;
        }
    }

    public static class SERVER {
        public ReadyComponentMessage MOTD = new ReadyComponentMessage("<blue>Just another NullCordX - Forced Host");
        public String ADDRESS = "localhost:25565";
        public boolean RESTRICTED = false;

        public SERVER() {
        }

        public SERVER(ReadyComponentMessage MOTD2, String ADDRESS, boolean RESTRICTED) {
            this.MOTD = MOTD2;
            this.ADDRESS = ADDRESS;
            this.RESTRICTED = RESTRICTED;
        }
    }
}

